/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.papi.expansion.server;

import com.extendedclip.papi.expansion.server.ServerUtils;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import me.clip.placeholderapi.PlaceholderAPI;
import me.clip.placeholderapi.PlaceholderAPIPlugin;
import me.clip.placeholderapi.expansion.Cacheable;
import me.clip.placeholderapi.expansion.Configurable;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ServerExpansion
extends PlaceholderExpansion
implements Cacheable,
Configurable {
    private ServerUtils serverUtils = null;
    private final Map<String, SimpleDateFormat> dateFormats = new HashMap<String, SimpleDateFormat>();
    private final Runtime runtime = Runtime.getRuntime();
    private String serverName;
    private String low = "&c";
    private String medium = "&e";
    private String high = "&a";
    private final Cache<String, Integer> cache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private final String VERSION = ((Object)((Object)this)).getClass().getPackage().getImplementationVersion();

    public boolean canRegister() {
        this.serverName = this.getString("server_name", "A Minecraft Server");
        this.low = this.getString("tps_color.low", "&c");
        this.medium = this.getString("tps_color.medium", "&e");
        this.high = this.getString("tps_color.high", "&a");
        return true;
    }

    public void clear() {
        this.dateFormats.clear();
        this.serverUtils = null;
        this.cache.invalidateAll();
    }

    @NotNull
    public String getIdentifier() {
        return "server";
    }

    @NotNull
    public String getAuthor() {
        return "clip";
    }

    @NotNull
    public String getVersion() {
        return this.VERSION;
    }

    public Map<String, Object> getDefaults() {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        defaults.put("tps_color.high", "&a");
        defaults.put("tps_color.medium", "&e");
        defaults.put("tps_color.low", "&c");
        defaults.put("server_name", "A Minecraft Server");
        return defaults;
    }

    @Nullable
    private String getCached(String key, Callable<Integer> callable) {
        try {
            return String.valueOf(this.cache.get((Object)key, callable));
        }
        catch (ExecutionException e) {
            if (this.getPlaceholderAPI().getPlaceholderAPIConfig().isDebugMode()) {
                this.getPlaceholderAPI().getLogger().log(Level.SEVERE, "[server] Could not access cache key " + key, e);
            }
            return "";
        }
    }

    private int getChunks() {
        return Bukkit.getWorlds().stream().mapToInt(world -> world.getLoadedChunks().length).sum();
    }

    private int getLivingEntities() {
        return Bukkit.getWorlds().stream().mapToInt(world -> world.getLivingEntities().size()).sum();
    }

    private Integer getTotalEntities() {
        return Bukkit.getWorlds().stream().mapToInt(world -> world.getEntities().size()).sum();
    }

    public String onRequest(OfflinePlayer p, @NotNull String identifier) {
        int MB = 0x100000;
        if (this.serverUtils == null) {
            this.serverUtils = new ServerUtils();
        }
        switch (identifier) {
            case "online": {
                return String.valueOf(Bukkit.getOnlinePlayers().size());
            }
            case "max_players": {
                return String.valueOf(Bukkit.getMaxPlayers());
            }
            case "unique_joins": {
                return String.valueOf(Bukkit.getOfflinePlayers().length);
            }
            case "version": {
                return this.serverUtils.getVersion();
            }
            case "build": {
                return this.serverUtils.getBuild();
            }
            case "version_build": 
            case "version_full": {
                return this.serverUtils.getVersion() + '-' + this.serverUtils.getBuild();
            }
            case "ram_used": {
                return String.valueOf((this.runtime.totalMemory() - this.runtime.freeMemory()) / 0x100000L);
            }
            case "ram_free": {
                return String.valueOf(this.runtime.freeMemory() / 0x100000L);
            }
            case "ram_total": {
                return String.valueOf(this.runtime.totalMemory() / 0x100000L);
            }
            case "ram_max": {
                return String.valueOf(this.runtime.maxMemory() / 0x100000L);
            }
            case "name": {
                return this.serverName == null ? "" : this.serverName;
            }
            case "variant": {
                return this.serverUtils.getServerVariant();
            }
            case "tps": {
                return this.getTps(null);
            }
            case "uptime": {
                long seconds = TimeUnit.MILLISECONDS.toSeconds(ManagementFactory.getRuntimeMXBean().getUptime());
                return ServerExpansion.formatTime(Duration.of(seconds, ChronoUnit.SECONDS));
            }
            case "total_chunks": {
                return this.getCached("chunks", this::getChunks);
            }
            case "total_living_entities": {
                return this.getCached("livingEntities", this::getLivingEntities);
            }
            case "total_entities": {
                return this.getCached("totalEntities", this::getTotalEntities);
            }
            case "has_whitelist": {
                return Bukkit.getServer().hasWhitelist() ? PlaceholderAPIPlugin.booleanTrue() : PlaceholderAPIPlugin.booleanFalse();
            }
        }
        if (identifier.startsWith("tps_")) {
            identifier = identifier.replace("tps_", "");
            return this.getTps(identifier);
        }
        if (identifier.startsWith("online_")) {
            identifier = identifier.replace("online_", "");
            int i = 0;
            for (Player o : Bukkit.getOnlinePlayers()) {
                if (!o.getWorld().getName().equals(identifier)) continue;
                ++i;
            }
            return String.valueOf(i);
        }
        if (identifier.startsWith("countdown_")) {
            Date then;
            SimpleDateFormat f;
            String time = identifier.replace("countdown_", "");
            if (!time.contains("_")) {
                Date then2;
                try {
                    then2 = PlaceholderAPIPlugin.getDateFormat().parse(time);
                }
                catch (Exception e) {
                    return null;
                }
                Date now = new Date();
                long between = then2.getTime() - now.getTime();
                if (between <= 0L) {
                    return "0";
                }
                return ServerExpansion.formatTime(Duration.of((int)TimeUnit.MILLISECONDS.toSeconds(between), ChronoUnit.SECONDS));
            }
            String[] parts = PlaceholderAPI.setBracketPlaceholders((OfflinePlayer)p, (String)time).split("_");
            if (parts.length != 2) {
                return "invalid format and time";
            }
            time = parts[1];
            String format = parts[0];
            try {
                f = new SimpleDateFormat(format);
            }
            catch (Exception e) {
                return "invalid date format";
            }
            try {
                then = f.parse(time);
            }
            catch (Exception e) {
                return "invalid date";
            }
            long t = System.currentTimeMillis();
            long between = then.getTime() - t;
            if (between <= 0L) {
                return "0";
            }
            return ServerExpansion.formatTime(Duration.of((int)TimeUnit.MILLISECONDS.toSeconds(between), ChronoUnit.SECONDS));
        }
        if (identifier.startsWith("time_")) {
            if (this.dateFormats.containsKey(identifier = identifier.replace("time_", ""))) {
                return this.dateFormats.get(identifier).format(new Date());
            }
            try {
                SimpleDateFormat format = new SimpleDateFormat(identifier);
                this.dateFormats.put(identifier, format);
                return format.format(new Date());
            }
            catch (IllegalArgumentException | NullPointerException ex) {
                return null;
            }
        }
        return null;
    }

    public String getTps(String arg) {
        if (arg == null || arg.isEmpty()) {
            StringJoiner joiner = new StringJoiner(ChatColor.GRAY + ", ");
            for (double tps : this.serverUtils.getTps()) {
                joiner.add(this.getColoredTps(tps));
            }
            return joiner.toString();
        }
        switch (arg) {
            case "1": 
            case "one": {
                return this.fix(this.serverUtils.getTps()[0]);
            }
            case "5": 
            case "five": {
                return this.fix(this.serverUtils.getTps()[1]);
            }
            case "15": 
            case "fifteen": {
                return this.fix(this.serverUtils.getTps()[2]);
            }
            case "1_colored": 
            case "one_colored": {
                return this.getColoredTps(this.serverUtils.getTps()[0]);
            }
            case "5_colored": 
            case "five_colored": {
                return this.getColoredTps(this.serverUtils.getTps()[1]);
            }
            case "15_colored": 
            case "fifteen_colored": {
                return this.getColoredTps(this.serverUtils.getTps()[2]);
            }
            case "percent": {
                StringJoiner joiner = new StringJoiner(ChatColor.GRAY + ", ");
                for (double t : this.serverUtils.getTps()) {
                    joiner.add(this.getColoredTpsPercent(t));
                }
                return joiner.toString();
            }
            case "1_percent": 
            case "one_percent": {
                return this.getPercent(this.serverUtils.getTps()[0]);
            }
            case "5_percent": 
            case "five_percent": {
                return this.getPercent(this.serverUtils.getTps()[1]);
            }
            case "15_percent": 
            case "fifteen_percent": {
                return this.getPercent(this.serverUtils.getTps()[2]);
            }
            case "1_percent_colored": 
            case "one_percent_colored": {
                return this.getColoredTpsPercent(this.serverUtils.getTps()[0]);
            }
            case "5_percent_colored": 
            case "five_percent_colored": {
                return this.getColoredTpsPercent(this.serverUtils.getTps()[1]);
            }
            case "15_percent_colored": 
            case "fifteen_percent_colored": {
                return this.getColoredTpsPercent(this.serverUtils.getTps()[2]);
            }
        }
        return null;
    }

    public static String formatTime(Duration duration) {
        StringBuilder builder = new StringBuilder();
        long seconds = duration.getSeconds();
        long minutes = seconds / 60L;
        long hours = minutes / 60L;
        long days = hours / 24L;
        long weeks = days / 7L;
        minutes %= 60L;
        hours %= 24L;
        days %= 7L;
        if ((seconds %= 60L) > 0L) {
            builder.insert(0, seconds + "s");
        }
        if (minutes > 0L) {
            if (builder.length() > 0) {
                builder.insert(0, ' ');
            }
            builder.insert(0, minutes + "m");
        }
        if (hours > 0L) {
            if (builder.length() > 0) {
                builder.insert(0, ' ');
            }
            builder.insert(0, hours + "h");
        }
        if (days > 0L) {
            if (builder.length() > 0) {
                builder.insert(0, ' ');
            }
            builder.insert(0, days + "d");
        }
        if (weeks > 0L) {
            if (builder.length() > 0) {
                builder.insert(0, ' ');
            }
            builder.insert(0, weeks + "w");
        }
        return builder.toString();
    }

    private String fix(double tps) {
        double finalTps = Math.min((double)Math.round(tps), 20.0);
        return (tps > 20.0 ? "*" : "") + finalTps;
    }

    private String color(double tps) {
        return ChatColor.translateAlternateColorCodes((char)'&', (String)(tps > 18.0 ? this.high : (tps > 16.0 ? this.medium : this.low)));
    }

    private String getColoredTps(double tps) {
        return this.color(tps) + this.fix(tps);
    }

    private String getColoredTpsPercent(double tps) {
        return this.color(tps) + this.getPercent(tps);
    }

    private String getPercent(double tps) {
        double finalPercent = Math.min((double)Math.round(5.0 * tps), 100.0);
        return (tps > 20.0 ? "*" : "") + finalPercent + "%";
    }
}

