/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.menu.menus;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.Menu;
import club.mher.compass.menu.menus.MainMenu;
import club.mher.compass.tasks.ActionBarTask;
import club.mher.compass.util.NBTItem;
import club.mher.compass.util.TextUtil;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.shop.ShopManager;
import com.andrei1058.bedwars.shop.quickbuy.PlayerQuickBuyCache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class TrackerMenu
extends Menu {
    private final YamlConfiguration yml;
    private final IArena arena;
    private final List<Integer> slots = new ArrayList<Integer>();
    private final HashMap<Integer, ITeam> teamSlotMap;
    private boolean backToShop = false;

    public TrackerMenu(Player player, IArena arena) {
        super(player);
        this.arena = arena;
        this.teamSlotMap = new HashMap();
        this.yml = MessagesData.getYml(player);
        for (String s : Compass.getMainConfig().getYml().getString("menus.tracker-menu.slots").split(",")) {
            int i;
            try {
                i = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                continue;
            }
            this.slots.add(i);
        }
    }

    @Override
    public String getMenuName() {
        return this.yml.getString("addons.compass.menus.tracker-menu.title");
    }

    @Override
    public int getSlots() {
        return Compass.getMainConfig().getInt("menus.tracker-menu.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        UUID uuid = player.getUniqueId();
        NBTItem nbtItem = new NBTItem(e.getCurrentItem());
        if (nbtItem.getString("data").equals("main-menu")) {
            if (this.backToShop) {
                ShopManager.shop.open(player, PlayerQuickBuyCache.getQuickBuyCache((UUID)player.getUniqueId()), false);
            } else {
                new MainMenu(player).open();
            }
        }
        if (!this.slots.contains(e.getSlot())) {
            return;
        }
        if (!this.isAllBedsDestroyed(this.arena.getTeam(player))) {
            player.closeInventory();
            player.sendMessage(TextUtil.colorize(this.yml.getString("addons.compass.messages.not-all-beds-destroyed")));
            return;
        }
        if (!player.getInventory().contains(Material.valueOf((String)Compass.getMainConfig().getString("player-track.resource")), Compass.getMainConfig().getInt("player-track.cost"))) {
            player.closeInventory();
            player.sendMessage(TextUtil.colorize(this.yml.getString("addons.compass.messages.not-enough-resource")));
            return;
        }
        player.closeInventory();
        if (Compass.isTracking(this.arena, uuid) && Compass.getTrackingTeam(this.arena, uuid).equals(this.teamSlotMap.get(e.getSlot()))) {
            player.sendMessage(TextUtil.colorize(this.yml.getString("addons.compass.messages.already-tracking")));
            return;
        }
        if (!Compass.getTrackingArenaMap().containsKey(this.arena)) {
            new ActionBarTask(this.arena).runTaskTimer((Plugin)Compass.getInstance(), 0L, Compass.getMainConfig().getInt("tracker-update-rate"));
        }
        Compass.setTrackingTeam(this.arena, uuid, this.teamSlotMap.get(e.getSlot()));
        Compass.getBedWars().getShopUtil().takeMoney(player, Material.valueOf((String)Compass.getMainConfig().getString("player-track.resource")), Compass.getMainConfig().getInt("player-track.cost"));
        player.sendMessage(TextUtil.colorize(this.yml.getString("addons.compass.messages.purchase-message")));
    }

    @Override
    public void setMenuItems() {
        NBTItem nbtItem = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.tracker-menu.back-item", true, "main-menu"));
        int index = 0;
        for (ITeam team : this.arena.getTeams()) {
            if (team.getMembers().isEmpty() || this.arena.getTeam(this.player).equals(team) || this.slots.size() <= index) continue;
            NBTItem teamItem = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.tracker-menu.team-item", false, null));
            this.teamSlotMap.put(this.slots.get(index), team);
            this.inventory.setItem(this.slots.get(index).intValue(), this.getTeamItem(teamItem.getItem(), team, this.player));
            ++index;
        }
        this.inventory.setItem(nbtItem.getInteger("slot").intValue(), nbtItem.getItem());
    }

    public ItemStack getTeamItem(ItemStack itemStack, ITeam team, Player player) {
        ItemMeta itemMeta = itemStack.getItemMeta();
        itemStack = Compass.getBedWars().getVersionSupport().colourItem(itemStack, team);
        itemMeta.setDisplayName(TextUtil.colorize(itemMeta.getDisplayName().replace("{team}", team.getDisplayName(Compass.getBedWars().getPlayerLanguage(player)))));
        if (itemMeta.hasLore()) {
            ArrayList newLore = new ArrayList();
            itemMeta.getLore().forEach(s -> newLore.add(TextUtil.colorize(s.replace("{status}", this.getStatus(player, this.arena)))));
            itemMeta.setLore(newLore);
        }
        itemStack.setItemMeta(itemMeta);
        return itemStack;
    }

    public String getStatus(Player player, IArena arena) {
        if (!this.isAllBedsDestroyed(arena.getTeam(player))) {
            return this.yml.getString("addons.compass.tracker-status.locked");
        }
        if (!player.getInventory().contains(Material.valueOf((String)Compass.getMainConfig().getString("player-track.resource")), Compass.getMainConfig().getInt("player-track.cost"))) {
            return this.yml.getString("addons.compass.tracker-status.not-enough");
        }
        return this.yml.getString("addons.compass.tracker-status.unlocked");
    }

    public boolean isAllBedsDestroyed(ITeam t) {
        boolean bool = true;
        for (ITeam team : this.arena.getTeams()) {
            if (team.equals(t) || team.isBedDestroyed()) continue;
            bool = false;
            break;
        }
        return bool;
    }

    public void setBackToShop(boolean b) {
        this.backToShop = b;
    }
}

