/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.menu.menus;

import club.mher.compass.Compass;
import club.mher.compass.data.MessagesData;
import club.mher.compass.menu.Menu;
import club.mher.compass.menu.menus.MainMenu;
import club.mher.compass.menu.menus.communicationMenus.ResourceSelector;
import club.mher.compass.menu.menus.communicationMenus.TeamSelector;
import club.mher.compass.util.MessagingUtil;
import club.mher.compass.util.NBTItem;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.InventoryClickEvent;

public class CommunicationsMenu
extends Menu {
    YamlConfiguration yml;
    IArena arena;

    public CommunicationsMenu(Player player, IArena arena) {
        super(player);
        this.yml = MessagesData.getYml(player);
        this.arena = arena;
    }

    @Override
    public String getMenuName() {
        return this.yml.getString("addons.compass.menus.communications.title");
    }

    @Override
    public int getSlots() {
        return Compass.getMainConfig().getInt("menus.communications.size");
    }

    @Override
    public void handleMenu(InventoryClickEvent e) {
        Player player = (Player)e.getWhoClicked();
        NBTItem nbti = new NBTItem(e.getCurrentItem());
        if (this.arena.isSpectator(player)) {
            return;
        }
        ITeam team = this.arena.getTeam(player);
        if (team.getMembers().size() <= 1) {
            return;
        }
        if (nbti.getString("data").equals("back-item")) {
            new MainMenu(player).open();
        } else if (nbti.getString("data").equals("communication-item")) {
            switch (nbti.getString("menuType")) {
                case "NONE": {
                    MessagingUtil.simpleMessage(player, team, nbti.getString("path"));
                    break;
                }
                case "TEAM": {
                    new TeamSelector(player, team, nbti.getString("path")).open();
                    break;
                }
                case "RESOURCE": {
                    new ResourceSelector(player, team, nbti.getString("path")).open();
                }
            }
        }
    }

    @Override
    public void setMenuItems() {
        for (String s : Compass.getMainConfig().getYml().getConfigurationSection("menus.communications.items").getKeys(false)) {
            NBTItem nbtItem = new NBTItem(Compass.getMainConfig().getCommunicationItem(this.player, "menus.communications.items." + s));
            this.inventory.setItem(nbtItem.getInteger("slot").intValue(), nbtItem.getItem());
        }
        NBTItem backItem = new NBTItem(Compass.getMainConfig().getItem(this.player, "menus.communications.back-item", true, "back-item"));
        this.inventory.setItem(backItem.getInteger("slot").intValue(), backItem.getItem());
    }
}

