/*
 * Decompiled with CFR 0.152.
 */
package club.mher.compass.listener;

import club.mher.compass.Compass;
import club.mher.compass.util.NBTItem;
import com.andrei1058.bedwars.api.arena.GameState;
import com.andrei1058.bedwars.api.arena.IArena;
import com.andrei1058.bedwars.api.arena.team.ITeam;
import com.andrei1058.bedwars.api.events.gameplay.GameStateChangeEvent;
import com.andrei1058.bedwars.api.events.player.PlayerKillEvent;
import com.andrei1058.bedwars.api.events.player.PlayerLeaveArenaEvent;
import com.andrei1058.bedwars.api.events.player.PlayerReSpawnEvent;
import java.util.UUID;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.ItemSpawnEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.ItemStack;

public class GameListener
implements Listener {
    @EventHandler
    public void onServerQuit(PlayerQuitEvent e) {
        Player player = e.getPlayer();
        UUID uuid = player.getUniqueId();
        if (!Compass.getBedWars().getArenaUtil().isPlaying(player)) {
            return;
        }
        IArena arena = Compass.getBedWars().getArenaUtil().getArenaByPlayer(player);
        if (!Compass.isTracking(arena, uuid)) {
            return;
        }
        Compass.removeTrackingTeam(arena, uuid);
    }

    @EventHandler
    public void onLeave(PlayerLeaveArenaEvent e) {
        UUID uuid;
        IArena arena = e.getArena();
        if (Compass.isTracking(arena, uuid = e.getPlayer().getUniqueId())) {
            Compass.removeTrackingTeam(arena, uuid);
        }
    }

    @EventHandler
    public void onKill(PlayerDeathEvent e) {
        Player player = e.getEntity();
        if (!Compass.getBedWars().getArenaUtil().isPlaying(player)) {
            return;
        }
        NBTItem nbti = new NBTItem(Compass.getMainConfig().getItem(player, "compass-item", true, "compass-item"));
        e.getDrops().remove(nbti.getItem());
    }

    @EventHandler
    public void onKill(PlayerKillEvent e) {
        IArena arena = e.getArena();
        Player victim = e.getVictim();
        UUID victimUniqueId = victim.getUniqueId();
        ITeam victimTeam = arena.getTeam(victim);
        if (Compass.isTracking(arena, victimUniqueId)) {
            Compass.removeTrackingTeam(arena, victimUniqueId);
        }
        if (victimTeam.getMembers().size() == 0) {
            Compass.getTrackingArenaMap().values().removeIf(victimTeam::equals);
        }
    }

    @EventHandler
    public void onRespawn(PlayerReSpawnEvent e) {
        this.addToInventory(e.getPlayer());
    }

    @EventHandler
    public void onStateChange(GameStateChangeEvent e) {
        IArena arena = e.getArena();
        if (e.getNewState().equals((Object)GameState.playing)) {
            arena.getPlayers().forEach(this::addToInventory);
        } else if (e.getNewState().equals((Object)GameState.restarting)) {
            Compass.removeTrackingArena(arena);
        }
    }

    @EventHandler
    public void onCompassDrop(ItemSpawnEvent e) {
        ItemStack is = e.getEntity().getItemStack();
        if (is == null) {
            return;
        }
        String data = new NBTItem(is).getString("data");
        if (data == null) {
            return;
        }
        if (data.equals("compass-item")) {
            e.setCancelled(true);
        }
    }

    public void addToInventory(Player p) {
        NBTItem nbti = new NBTItem(Compass.getMainConfig().getItem(p, "compass-item", true, "compass-item"));
        p.getInventory().setItem(nbti.getInteger("slot").intValue(), nbti.getItem());
    }
}

