/*
 * Decompiled with CFR 0.152.
 */
package at.helpch.placeholderapi.expansion.vault;

import at.helpch.placeholderapi.expansion.vault.VaultExpansion;
import at.helpch.placeholderapi.expansion.vault.VaultHook;
import com.google.common.primitives.Ints;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.OfflinePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EconomyHook
extends VaultHook {
    private static final Pattern BALANCE_DECIMAL_POINTS_PATTERN = Pattern.compile("balance_(?<points>\\d+)dp");
    private static final DecimalFormat COMMAS_FORMAT = new DecimalFormat("#,###");
    private static final DecimalFormat FIXED_FORMAT = new DecimalFormat("#");
    private static final Map<Integer, DecimalFormat> DECIMAL_FORMATS_CACHE = new HashMap<Integer, DecimalFormat>();
    private final NavigableMap<Long, String> suffixes = new TreeMap<Long, String>();
    private Economy economy;

    public EconomyHook(VaultExpansion expansion) {
        super(expansion);
        this.suffixes.put(1000L, expansion.getString("formatting.thousands", "K"));
        this.suffixes.put(1000000L, expansion.getString("formatting.millions", "M"));
        this.suffixes.put(1000000000L, expansion.getString("formatting.billions", "B"));
        this.suffixes.put(1000000000000L, expansion.getString("formatting.trillions", "T"));
        this.suffixes.put(1000000000000000L, expansion.getString("formatting.quadrillions", "Q"));
        this.setup();
    }

    private double getBalance(@NotNull OfflinePlayer player) {
        return this.economy.getBalance(player);
    }

    @NotNull
    private String setDecimalPoints(double balance, int points) {
        DecimalFormat cachedFormat = DECIMAL_FORMATS_CACHE.get(points);
        if (cachedFormat != null) {
            return cachedFormat.format(balance);
        }
        DecimalFormat decimalFormat = (DecimalFormat)DecimalFormat.getIntegerInstance();
        decimalFormat.setMaximumFractionDigits(points);
        decimalFormat.setGroupingUsed(false);
        DECIMAL_FORMATS_CACHE.put(points, decimalFormat);
        return decimalFormat.format(balance);
    }

    @NotNull
    private String formatBalance(long balance) {
        if (balance == Long.MIN_VALUE) {
            return this.formatBalance(-9223372036854775807L);
        }
        if (balance < 0L) {
            return "-" + this.formatBalance(-balance);
        }
        if (balance < 1000L) {
            return Long.toString(balance);
        }
        Map.Entry<Long, String> e = this.suffixes.floorEntry(balance);
        Long divideBy = e.getKey();
        String suffix = e.getValue();
        long truncated = balance / (divideBy / 10L);
        boolean hasDecimal = truncated < 100L && (double)truncated / 10.0 != (double)(truncated / 10L);
        return hasDecimal ? (double)truncated / 10.0 + suffix : truncated / 10L + suffix;
    }

    @Override
    public void setup() {
        this.economy = this.getService(Economy.class);
    }

    @Override
    public boolean isReady() {
        return this.economy != null;
    }

    @Override
    @Nullable
    public String onRequest(@Nullable OfflinePlayer offlinePlayer, @NotNull String params) {
        Matcher matcher;
        if (offlinePlayer == null) {
            return "";
        }
        double balance = this.getBalance(offlinePlayer);
        if (params.startsWith("balance_") && (matcher = BALANCE_DECIMAL_POINTS_PATTERN.matcher(params)).find()) {
            Integer points = Ints.tryParse((String)matcher.group("points"));
            if (points == null) {
                return matcher.group("points") + " is not a valid number";
            }
            return this.setDecimalPoints(balance, points);
        }
        switch (params) {
            case "balance": {
                return this.setDecimalPoints(balance, Math.max(2, this.economy.fractionalDigits()));
            }
            case "balance_fixed": {
                return FIXED_FORMAT.format(balance);
            }
            case "balance_formatted": {
                return this.formatBalance((long)balance);
            }
            case "balance_commas": {
                return COMMAS_FORMAT.format(balance);
            }
        }
        return null;
    }
}

