/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.world.importer;

import com.grinderwolf.swm.api.exceptions.InvalidWorldException;
import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.stream.NBTInputStream;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.plugin.world.importer.LevelData;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;

public class WorldImporter {
    private static final Pattern MAP_FILE_PATTERN = Pattern.compile("^(?:map_([0-9]*).dat)$");
    private static final int SECTOR_SIZE = 4096;

    public static CraftSlimeWorld readFromDirectory(File worldDir) throws InvalidWorldException, IOException {
        File levelFile = new File(worldDir, "level.dat");
        if (!levelFile.exists() || !levelFile.isFile()) {
            throw new InvalidWorldException(worldDir);
        }
        LevelData data = WorldImporter.readLevelData(levelFile);
        byte worldVersion = data.getVersion() == -1 ? (byte)1 : (data.getVersion() < 818 ? (byte)2 : (data.getVersion() < 1501 ? (byte)3 : (data.getVersion() < 1517 ? (byte)4 : 5)));
        File regionDir = new File(worldDir, "region");
        if (!regionDir.exists() || !regionDir.isDirectory()) {
            throw new InvalidWorldException(worldDir);
        }
        HashMap<Long, SlimeChunk> chunks = new HashMap<Long, SlimeChunk>();
        for (File file : regionDir.listFiles((dir, name) -> name.endsWith(".mca"))) {
            chunks.putAll(WorldImporter.loadChunks(file, worldVersion).stream().collect(Collectors.toMap(chunk -> (long)chunk.getZ() * Integer.MAX_VALUE + (long)chunk.getX(), chunk -> chunk)));
        }
        if (chunks.isEmpty()) {
            throw new InvalidWorldException(worldDir);
        }
        File dataDir = new File(worldDir, "data");
        ArrayList<CompoundTag> maps = new ArrayList<CompoundTag>();
        if (dataDir.exists()) {
            if (!dataDir.isDirectory()) {
                throw new InvalidWorldException(worldDir);
            }
            for (File mapFile : dataDir.listFiles((dir, name) -> MAP_FILE_PATTERN.matcher(name).matches())) {
                maps.add(WorldImporter.loadMap(mapFile));
            }
        }
        CompoundMap extraData = new CompoundMap();
        if (!data.getGameRules().isEmpty()) {
            CompoundMap gamerules = new CompoundMap();
            data.getGameRules().forEach((rule, value) -> gamerules.put((String)rule, new StringTag((String)rule, (String)value)));
            extraData.put("gamerules", new CompoundTag("gamerules", gamerules));
        }
        SlimePropertyMap propertyMap = new SlimePropertyMap();
        propertyMap.setInt(SlimeProperties.SPAWN_X, data.getSpawnX());
        propertyMap.setInt(SlimeProperties.SPAWN_Y, data.getSpawnY());
        propertyMap.setInt(SlimeProperties.SPAWN_Z, data.getSpawnZ());
        return new CraftSlimeWorld(null, worldDir.getName(), chunks, new CompoundTag("", extraData), maps, worldVersion, propertyMap, false, true);
    }

    private static CompoundTag loadMap(File mapFile) throws IOException {
        String fileName = mapFile.getName();
        int mapId = Integer.parseInt(fileName.substring(4, fileName.length() - 4));
        NBTInputStream nbtStream = new NBTInputStream(new FileInputStream(mapFile), 1, ByteOrder.BIG_ENDIAN);
        CompoundTag tag = nbtStream.readTag().getAsCompoundTag().get().getAsCompoundTag("data").get();
        tag.getValue().put("id", new IntTag("id", mapId));
        return tag;
    }

    private static LevelData readLevelData(File file) throws IOException, InvalidWorldException {
        Optional<CompoundTag> dataTag;
        NBTInputStream nbtStream = new NBTInputStream(new FileInputStream(file));
        Optional<CompoundTag> tag = nbtStream.readTag().getAsCompoundTag();
        if (tag.isPresent() && (dataTag = tag.get().getAsCompoundTag("Data")).isPresent()) {
            int dataVersion = dataTag.get().getIntValue("DataVersion").orElse(-1);
            HashMap<String, String> gameRules = new HashMap<String, String>();
            Optional<CompoundTag> rulesList = dataTag.get().getAsCompoundTag("GameRules");
            rulesList.ifPresent(compoundTag -> compoundTag.getValue().forEach((ruleName, ruleTag) -> gameRules.put((String)ruleName, ruleTag.getAsStringTag().get().getValue())));
            int spawnX = dataTag.get().getIntValue("SpawnX").orElse(0);
            int spawnY = dataTag.get().getIntValue("SpawnY").orElse(255);
            int spawnZ = dataTag.get().getIntValue("SpawnZ").orElse(0);
            return new LevelData(dataVersion, gameRules, spawnX, spawnY, spawnZ);
        }
        throw new InvalidWorldException(file.getParentFile());
    }

    private static List<SlimeChunk> loadChunks(File file, byte worldVersion) throws IOException {
        byte[] regionByteArray = Files.readAllBytes(file.toPath());
        DataInputStream inputStream = new DataInputStream(new ByteArrayInputStream(regionByteArray));
        ArrayList<ChunkEntry> chunks = new ArrayList<ChunkEntry>(1024);
        for (int i = 0; i < 1024; ++i) {
            int entry2 = inputStream.readInt();
            int chunkOffset = entry2 >>> 8;
            int chunkSize = entry2 & 0xF;
            if (entry2 == 0) continue;
            ChunkEntry chunkEntry = new ChunkEntry(chunkOffset * 4096, chunkSize * 4096);
            chunks.add(chunkEntry);
        }
        List<SlimeChunk> loadedChunks = chunks.stream().map(entry -> {
            try {
                DataInputStream headerStream = new DataInputStream(new ByteArrayInputStream(regionByteArray, entry.getOffset(), entry.getPaddedSize()));
                int chunkSize = headerStream.readInt() - 1;
                byte compressionScheme = headerStream.readByte();
                DataInputStream chunkStream = new DataInputStream(new ByteArrayInputStream(regionByteArray, entry.getOffset() + 5, chunkSize));
                InflaterInputStream decompressorStream = compressionScheme == 1 ? new GZIPInputStream(chunkStream) : new InflaterInputStream(chunkStream);
                NBTInputStream nbtStream = new NBTInputStream(decompressorStream, 0, ByteOrder.BIG_ENDIAN);
                CompoundTag globalCompound = (CompoundTag)nbtStream.readTag();
                CompoundMap globalMap = globalCompound.getValue();
                if (!globalMap.containsKey("Level")) {
                    throw new RuntimeException("Missing Level tag?");
                }
                CompoundTag levelCompound = (CompoundTag)globalMap.get("Level");
                return WorldImporter.readChunk(levelCompound, worldVersion);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).filter(Objects::nonNull).collect(Collectors.toList());
        return loadedChunks;
    }

    private static SlimeChunk readChunk(CompoundTag compound, byte worldVersion) {
        CompoundTag heightMapsCompound;
        int[] biomes;
        int chunkX = compound.getAsIntTag("xPos").get().getValue();
        int chunkZ = compound.getAsIntTag("zPos").get().getValue();
        Optional<String> status = compound.getStringValue("Status");
        if (status.isPresent() && !status.get().equals("postprocessed") && !status.get().startsWith("full")) {
            return null;
        }
        Object biomesTag = compound.getValue().get("Biomes");
        if (biomesTag instanceof IntArrayTag) {
            biomes = ((IntArrayTag)biomesTag).getValue();
        } else if (biomesTag instanceof ByteArrayTag) {
            byte[] byteBiomes = ((ByteArrayTag)biomesTag).getValue();
            biomes = WorldImporter.toIntArray(byteBiomes);
        } else {
            biomes = null;
        }
        Optional<CompoundTag> optionalHeightMaps = compound.getAsCompoundTag("Heightmaps");
        if (worldVersion >= 4) {
            heightMapsCompound = optionalHeightMaps.orElse(new CompoundTag("", new CompoundMap()));
        } else {
            int[] heightMap = compound.getIntArrayValue("HeightMap").orElse(new int[256]);
            heightMapsCompound = new CompoundTag("", new CompoundMap());
            heightMapsCompound.getValue().put("heightMap", new IntArrayTag("heightMap", heightMap));
        }
        Object tileEntities = compound.getAsListTag("TileEntities").orElse(new ListTag("TileEntities", TagType.TAG_COMPOUND, new ArrayList())).getValue();
        Object entities = compound.getAsListTag("Entities").orElse(new ListTag("Entities", TagType.TAG_COMPOUND, new ArrayList())).getValue();
        ListTag<?> sectionsTag = compound.getAsListTag("Sections").get();
        SlimeChunkSection[] sectionArray = new SlimeChunkSection[16];
        SlimeChunkSection[] slimeChunkSectionArray = sectionsTag.getValue().iterator();
        while (slimeChunkSectionArray.hasNext()) {
            long[] blockStatesArray;
            ListTag paletteTag;
            NibbleArray dataArray;
            CompoundTag sectionTag = (CompoundTag)slimeChunkSectionArray.next();
            byte index = sectionTag.getByteValue("Y").get();
            if (index < 0) continue;
            byte[] blocks = sectionTag.getByteArrayValue("Blocks").orElse(null);
            if (worldVersion < 4) {
                dataArray = new NibbleArray(sectionTag.getByteArrayValue("Data").get());
                if (WorldImporter.isEmpty(blocks)) continue;
                paletteTag = null;
                blockStatesArray = null;
            } else {
                dataArray = null;
                paletteTag = sectionTag.getAsListTag("Palette").orElse(null);
                blockStatesArray = sectionTag.getLongArrayValue("BlockStates").orElse(null);
                if (paletteTag == null || blockStatesArray == null || WorldImporter.isEmpty(blockStatesArray)) continue;
            }
            NibbleArray blockLightArray = sectionTag.getValue().containsKey("BlockLight") ? new NibbleArray(sectionTag.getByteArrayValue("BlockLight").get()) : null;
            NibbleArray skyLightArray = sectionTag.getValue().containsKey("SkyLight") ? new NibbleArray(sectionTag.getByteArrayValue("SkyLight").get()) : null;
            sectionArray[index] = new CraftSlimeChunkSection(blocks, dataArray, paletteTag, blockStatesArray, blockLightArray, skyLightArray);
        }
        for (SlimeChunkSection section : sectionArray) {
            if (section == null) continue;
            return new CraftSlimeChunk(null, chunkX, chunkZ, sectionArray, heightMapsCompound, biomes, (List<CompoundTag>)tileEntities, (List<CompoundTag>)entities);
        }
        return null;
    }

    private static int[] toIntArray(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.BIG_ENDIAN);
        int[] ret = new int[buf.length / 4];
        buffer.asIntBuffer().get(ret);
        return ret;
    }

    private static boolean isEmpty(byte[] array) {
        for (byte b : array) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    private static boolean isEmpty(long[] array) {
        for (long b : array) {
            if (b == 0L) continue;
            return false;
        }
        return true;
    }

    private static class ChunkEntry {
        private final int offset;
        private final int paddedSize;

        public int getOffset() {
            return this.offset;
        }

        public int getPaddedSize() {
            return this.paddedSize;
        }

        public ChunkEntry(int offset, int paddedSize) {
            this.offset = offset;
            this.paddedSize = paddedSize;
        }
    }
}

