/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.upgrade.v1_13;

import com.google.gson.GsonBuilder;
import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.DoubleTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.FloatTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ShortTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.plugin.SWMPlugin;
import com.grinderwolf.swm.plugin.log.Logging;
import com.grinderwolf.swm.plugin.upgrade.Upgrade;
import com.grinderwolf.swm.plugin.upgrade.v1_13.DowngradeData;
import com.grinderwolf.swm.plugin.upgrade.v1_13.deserializers.BlockEntryDeserializer;
import com.grinderwolf.swm.plugin.upgrade.v1_13.deserializers.DowngradeDataDeserializer;
import com.grinderwolf.swm.plugin.upgrade.v1_13.deserializers.SetActionDeserializer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.bukkit.ChatColor;

public class v1_13WorldUpgrade
implements Upgrade {
    private DowngradeData downgradeData;

    @Override
    public void upgrade(CraftSlimeWorld world) {
        Logging.warning("Updating world to the 1.13 format. This may take a while.");
        ArrayList<SlimeChunk> chunks = new ArrayList<SlimeChunk>(world.getChunks().values());
        long lastMessage = -1L;
        for (int i = 0; i < chunks.size(); ++i) {
            SlimeChunk chunk = (SlimeChunk)chunks.get(i);
            CompoundTag globalTag = new CompoundTag("", new CompoundMap());
            globalTag.getValue().put("DataVersion", new IntTag("DataVersion", 1343));
            CompoundTag chunkTag = new CompoundTag("Level", new CompoundMap());
            chunkTag.getValue().put("xPos", new IntTag("xPos", chunk.getX()));
            chunkTag.getValue().put("zPos", new IntTag("zPos", chunk.getZ()));
            chunkTag.getValue().put("Sections", (Tag<?>)this.serializeSections(chunk.getSections()));
            chunkTag.getValue().put("Entities", (Tag<?>)new ListTag<CompoundTag>("Entities", TagType.TAG_COMPOUND, chunk.getEntities()));
            chunkTag.getValue().put("TileEntities", (Tag<?>)new ListTag<CompoundTag>("TileEntities", TagType.TAG_COMPOUND, chunk.getTileEntities()));
            chunkTag.getValue().put("TileTicks", new ListTag("TileTicks", TagType.TAG_COMPOUND, new ArrayList()));
            chunkTag.getValue().put("TerrainPopulated", new ByteTag("TerrainPopulated", 1));
            chunkTag.getValue().put("LightPopulated", new ByteTag("LightPopulated", 1));
            globalTag.getValue().put("Level", chunkTag);
            globalTag = SWMPlugin.getInstance().getNms().convertChunk(globalTag);
            chunkTag = globalTag.getAsCompoundTag("Level").get();
            SlimeChunkSection[] newSections = new SlimeChunkSection[16];
            ListTag<?> serializedSections = chunkTag.getAsListTag("Sections").get();
            Iterator iterator = serializedSections.getValue().iterator();
            while (iterator.hasNext()) {
                CompoundTag sectionTag = (CompoundTag)iterator.next();
                ListTag<CompoundTag> palette = sectionTag.getAsListTag("Palette").get();
                long[] blockStates = sectionTag.getLongArrayValue("BlockStates").get();
                NibbleArray blockLight = new NibbleArray(sectionTag.getByteArrayValue("BlockLight").get());
                NibbleArray skyLight = new NibbleArray(sectionTag.getByteArrayValue("SkyLight").get());
                int index = sectionTag.getIntValue("Y").get();
                CraftSlimeChunkSection section = new CraftSlimeChunkSection(null, null, palette, blockStates, blockLight, skyLight);
                newSections[index] = section;
            }
            int[] newBiomes = new int[256];
            for (int index = 0; index < chunk.getBiomes().length; ++index) {
                newBiomes[index] = chunk.getBiomes()[index] & 0xFF;
            }
            CompoundTag upgradeData = chunkTag.getAsCompoundTag("UpgradeData").orElse(null);
            CraftSlimeChunk newChunk = new CraftSlimeChunk(world.getName(), chunk.getX(), chunk.getZ(), newSections, new CompoundTag("", new CompoundMap()), newBiomes, chunk.getTileEntities(), chunk.getEntities(), upgradeData);
            world.updateChunk(newChunk);
            int done = i + 1;
            if (done == chunks.size()) {
                Logging.info(ChatColor.GREEN + "World successfully converted to the 1.13 format!");
                continue;
            }
            if (System.currentTimeMillis() - lastMessage <= 1000L) continue;
            int percentage = done * 100 / chunks.size();
            Logging.info("Converting world... " + percentage + "%");
            lastMessage = System.currentTimeMillis();
        }
    }

    private ListTag<CompoundTag> serializeSections(SlimeChunkSection[] sections) {
        ListTag<CompoundTag> sectionList = new ListTag<CompoundTag>("Sections", TagType.TAG_COMPOUND, new ArrayList());
        for (int i = 0; i < sections.length; ++i) {
            SlimeChunkSection section = sections[i];
            if (section == null) continue;
            CompoundTag sectionTag = new CompoundTag(i + "", new CompoundMap());
            sectionTag.getValue().put("Y", new IntTag("Y", i));
            sectionTag.getValue().put("Blocks", new ByteArrayTag("Blocks", section.getBlocks()));
            sectionTag.getValue().put("Data", new ByteArrayTag("Data", section.getData().getBacking()));
            sectionTag.getValue().put("BlockLight", new ByteArrayTag("Data", section.getBlockLight().getBacking()));
            sectionTag.getValue().put("SkyLight", new ByteArrayTag("Data", section.getSkyLight().getBacking()));
            sectionList.getValue().add(sectionTag);
        }
        return sectionList;
    }

    @Override
    public void downgrade(CraftSlimeWorld world) {
        if (this.downgradeData == null) {
            try {
                this.loadDowngradeData();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        Logging.warning("Downgrading world to the 1.12 format. This may take a while.");
        ArrayList<SlimeChunk> chunks = new ArrayList<SlimeChunk>(world.getChunks().values());
        chunks.sort(Comparator.comparingLong(chunk -> (long)chunk.getZ() * Integer.MAX_VALUE + (long)chunk.getX()));
        long lastMessage = -1L;
        for (int i = 0; i < chunks.size(); ++i) {
            SlimeChunk chunk2 = (SlimeChunk)chunks.get(i);
            SlimeChunkSection[] newSections = new SlimeChunkSection[16];
            for (int sectionIndex = 0; sectionIndex < 16; ++sectionIndex) {
                SlimeChunkSection section = chunk2.getSections()[sectionIndex];
                if (section != null) {
                    Object palette = section.getPalette().getValue();
                    long[] blockData = section.getBlockStates();
                    byte[] blockArray = new byte[4096];
                    NibbleArray dataArray = new NibbleArray(4096);
                    int bitsPerBlock = Math.max(4, blockData.length * 64 / 4096);
                    long maxEntryValue = (1L << bitsPerBlock) - 1L;
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            for (int x = 0; x < 16; ++x) {
                                int val;
                                int arrayIndex = y << 8 | z << 4 | x;
                                int bitIndex = arrayIndex * bitsPerBlock;
                                int startIndex = bitIndex / 64;
                                int endIndex = ((arrayIndex + 1) * bitsPerBlock - 1) / 64;
                                int startBitSubIndex = bitIndex % 64;
                                if (startIndex == endIndex) {
                                    val = (int)(blockData[startIndex] >>> startBitSubIndex & maxEntryValue);
                                } else {
                                    int endBitSubIndex = 64 - startBitSubIndex;
                                    val = (int)((blockData[startIndex] >>> startBitSubIndex | blockData[endIndex] << endBitSubIndex) & maxEntryValue);
                                }
                                int id = 0;
                                byte data = 0;
                                CompoundTag blockTag = (CompoundTag)palette.get(val);
                                String name = blockTag.getStringValue("Name").get().substring(10);
                                DowngradeData.BlockEntry blockEntry = this.downgradeData.getBlocks().get(name);
                                if (blockEntry != null) {
                                    DowngradeData.TileEntityData tileEntityData;
                                    id = blockEntry.getId();
                                    data = (byte)blockEntry.getData();
                                    Optional<CompoundTag> propertiesTag = blockTag.getAsCompoundTag("Properties");
                                    Map<String, String> properties = null;
                                    if (propertiesTag.isPresent()) {
                                        properties = propertiesTag.get().getValue().values().stream().map(Tag::getAsStringTag).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toMap(Tag::getName, StringTag::getValue));
                                        if (blockEntry.getProperties() != null) {
                                            block23: for (DowngradeData.BlockProperty property : blockEntry.getProperties()) {
                                                for (Map.Entry<String, String> conditionEntry : property.getConditions().entrySet()) {
                                                    String propertyName = conditionEntry.getKey();
                                                    String propertyValue = conditionEntry.getValue();
                                                    boolean inverted = propertyName.startsWith("!");
                                                    if ((!inverted || !propertyValue.equals(properties.get(propertyName.substring(1)))) && (inverted || propertyValue.equals(properties.get(propertyName)))) continue;
                                                    continue block23;
                                                }
                                                if (property.getId() != -1) {
                                                    id = property.getId();
                                                }
                                                if (property.getData() == -1) continue;
                                                if (property.getOperation() == DowngradeData.Operation.OR) {
                                                    data = (byte)(data | property.getData());
                                                    continue;
                                                }
                                                data = (byte)property.getData();
                                            }
                                        }
                                    }
                                    if ((tileEntityData = blockEntry.getTileEntityData()) != null) {
                                        DowngradeData.TileSetAction setAction;
                                        CompoundTag tileEntityTag = null;
                                        int blockX = x + chunk2.getX() * 16;
                                        int blockY = y + sectionIndex * 16;
                                        int blockZ = z + chunk2.getZ() * 16;
                                        for (CompoundTag tileTag : chunk2.getTileEntities()) {
                                            int tileX = tileTag.getIntValue("x").get();
                                            int tileY = tileTag.getIntValue("y").get();
                                            int tileZ = tileTag.getIntValue("z").get();
                                            if (tileX != blockX || tileY != blockY || tileZ != blockZ) continue;
                                            tileEntityTag = tileTag;
                                            break;
                                        }
                                        DowngradeData.TileCreateAction createAction = tileEntityData.getCreateAction();
                                        if (tileEntityTag == null) {
                                            if (createAction == null) {
                                                throw new IllegalStateException("No create action was specified for block " + name + " but no tile entity was found");
                                            }
                                            Objects.requireNonNull(createAction.getName(), "Tile entity type cannot be null (" + name + ")");
                                            CompoundMap tileMap = new CompoundMap();
                                            tileMap.put("id", new StringTag("id", "minecraft:" + createAction.getName()));
                                            tileMap.put("x", new IntTag("x", blockX));
                                            tileMap.put("y", new IntTag("y", blockY));
                                            tileMap.put("z", new IntTag("z", blockZ));
                                            tileEntityTag = new CompoundTag("", tileMap);
                                        }
                                        if ((setAction = tileEntityData.getSetAction()) != null) {
                                            Map<String, DowngradeData.TileSetEntry> entries = setAction.getEntries();
                                            for (Map.Entry<String, DowngradeData.TileSetEntry> entry : entries.entrySet()) {
                                                Tag nbtTag;
                                                String key = entry.getKey();
                                                DowngradeData.TileSetEntry value = entry.getValue();
                                                String nbtValue = value.getValue();
                                                if (nbtValue.startsWith("@prop:")) {
                                                    if (properties == null) continue;
                                                    String propName = nbtValue.substring(6);
                                                    if ((nbtValue = properties.get(propName)) == null) {
                                                        throw new IllegalStateException("Block " + name + " doesn't have a property called " + propName);
                                                    }
                                                }
                                                switch (value.getType().toLowerCase()) {
                                                    case "byte": {
                                                        nbtTag = new ByteTag(key, Byte.valueOf(nbtValue));
                                                        break;
                                                    }
                                                    case "short": {
                                                        nbtTag = new ShortTag(key, Short.valueOf(nbtValue));
                                                        break;
                                                    }
                                                    case "int": {
                                                        nbtTag = new IntTag(key, Integer.valueOf(nbtValue));
                                                        break;
                                                    }
                                                    case "long": {
                                                        nbtTag = new LongTag(key, Long.valueOf(nbtValue));
                                                        break;
                                                    }
                                                    case "float": {
                                                        nbtTag = new FloatTag(key, Float.valueOf(nbtValue).floatValue());
                                                        break;
                                                    }
                                                    case "double": {
                                                        nbtTag = new DoubleTag(key, Double.valueOf(nbtValue));
                                                        break;
                                                    }
                                                    default: {
                                                        nbtTag = new StringTag(key, nbtValue);
                                                    }
                                                }
                                                tileEntityTag.getValue().put(key, nbtTag);
                                            }
                                        }
                                    }
                                }
                                blockArray[arrayIndex] = (byte)id;
                                dataArray.set(arrayIndex, data);
                            }
                        }
                    }
                    newSections[sectionIndex] = new CraftSlimeChunkSection(blockArray, dataArray, null, null, section.getBlockLight(), section.getSkyLight());
                }
                CompoundMap heightMap = new CompoundMap();
                heightMap.put("heightMap", new IntArrayTag("heightMap", new int[256]));
                CraftSlimeChunk newChunk = new CraftSlimeChunk(world.getName(), chunk2.getX(), chunk2.getZ(), newSections, new CompoundTag("", heightMap), new int[64], chunk2.getTileEntities(), chunk2.getEntities());
                world.updateChunk(newChunk);
            }
            int done = i + 1;
            if (done == chunks.size()) {
                Logging.info(ChatColor.GREEN + "World successfully converted to the 1.12 format!");
                continue;
            }
            if (System.currentTimeMillis() - lastMessage <= 1000L) continue;
            int percentage = done * 100 / chunks.size();
            Logging.info("Converting world... " + percentage + "%");
            lastMessage = System.currentTimeMillis();
        }
    }

    private void loadDowngradeData() throws IOException {
        Logging.info("Loading downgrade data...");
        GsonBuilder builder = new GsonBuilder();
        builder.registerTypeAdapter(DowngradeData.class, (Object)new DowngradeDataDeserializer());
        builder.registerTypeAdapter(DowngradeData.BlockEntry.class, (Object)new BlockEntryDeserializer());
        builder.registerTypeAdapter(DowngradeData.TileSetAction.class, (Object)new SetActionDeserializer());
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(SWMPlugin.getInstance().getResource("1_13to1_12_blocks.json"), StandardCharsets.UTF_8));){
            this.downgradeData = (DowngradeData)builder.create().fromJson((Reader)reader, DowngradeData.class);
        }
    }
}

