/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.upgrade.v1_11;

import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.plugin.upgrade.Upgrade;
import java.util.HashMap;
import java.util.Map;

public class v1_11WorldUpgrade
implements Upgrade {
    private static Map<String, String> oldToNewMap = new HashMap<String, String>();
    private static Map<String, String> newToOldMap = new HashMap<String, String>();

    private static void rename(String oldName, String newName) {
        if (oldName != null) {
            oldToNewMap.put(oldName, newName);
        }
        newToOldMap.put(newName, oldName);
    }

    @Override
    public void upgrade(CraftSlimeWorld world) {
        for (SlimeChunk chunk : world.getChunks().values()) {
            for (CompoundTag entityTag : chunk.getTileEntities()) {
                String oldType = entityTag.getAsStringTag("id").get().getValue();
                String newType = oldToNewMap.get(oldType);
                if (newType == null) {
                    if (newToOldMap.containsKey(oldType)) continue;
                    throw new IllegalStateException("Failed to find 1.11 upgrade for tile entity " + oldType);
                }
                entityTag.getValue().put("id", new StringTag("id", newType));
            }
        }
    }

    @Override
    public void downgrade(CraftSlimeWorld world) {
        for (SlimeChunk chunk : world.getChunks().values()) {
            for (CompoundTag entityTag : chunk.getTileEntities()) {
                String oldType = entityTag.getAsStringTag("id").get().getValue();
                String newType = newToOldMap.get(oldType);
                if (newType == null) continue;
                entityTag.getValue().put("id", new StringTag("id", newType));
            }
        }
    }

    static {
        v1_11WorldUpgrade.rename("Furnace", "minecraft:furnace");
        v1_11WorldUpgrade.rename("Chest", "minecraft:chest");
        v1_11WorldUpgrade.rename("EnderChest", "minecraft:ender_chest");
        v1_11WorldUpgrade.rename("RecordPlayer", "minecraft:jukebox");
        v1_11WorldUpgrade.rename("Trap", "minecraft:dispenser");
        v1_11WorldUpgrade.rename("Dropper", "minecraft:dropper");
        v1_11WorldUpgrade.rename("Sign", "minecraft:sign");
        v1_11WorldUpgrade.rename("MobSpawner", "minecraft:mob_spawner");
        v1_11WorldUpgrade.rename("Music", "minecraft:noteblock");
        v1_11WorldUpgrade.rename("Piston", "minecraft:piston");
        v1_11WorldUpgrade.rename("Cauldron", "minecraft:brewing_stand");
        v1_11WorldUpgrade.rename("EnchantTable", "minecraft:enchanting_table");
        v1_11WorldUpgrade.rename("Airportal", "minecraft:end_portal");
        v1_11WorldUpgrade.rename("Beacon", "minecraft:beacon");
        v1_11WorldUpgrade.rename("Skull", "minecraft:skull");
        v1_11WorldUpgrade.rename("DLDetector", "minecraft:daylight_detector");
        v1_11WorldUpgrade.rename("Hopper", "minecraft:hopper");
        v1_11WorldUpgrade.rename("Comparator", "minecraft:comparator");
        v1_11WorldUpgrade.rename("FlowerPot", "minecraft:flower_pot");
        v1_11WorldUpgrade.rename("Banner", "minecraft:banner");
        v1_11WorldUpgrade.rename("Structure", "minecraft:structure_block");
        v1_11WorldUpgrade.rename("EndGateway", "minecraft:end_gateway");
        v1_11WorldUpgrade.rename("Control", "minecraft:command_block");
        v1_11WorldUpgrade.rename(null, "minecraft:bed");
    }
}

