/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.loaders.mysql;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import com.grinderwolf.swm.api.exceptions.WorldInUseException;
import com.grinderwolf.swm.internal.com.zaxxer.hikari.HikariConfig;
import com.grinderwolf.swm.internal.com.zaxxer.hikari.HikariDataSource;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.loaders.UpdatableLoader;
import com.grinderwolf.swm.plugin.log.Logging;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MysqlLoader
extends UpdatableLoader {
    private static final ScheduledExecutorService SERVICE = Executors.newScheduledThreadPool(2, new ThreadFactoryBuilder().setNameFormat("SWM MySQL Lock Pool Thread #%1$d").build());
    private static final int CURRENT_DB_VERSION = 1;
    private static final String CREATE_VERSIONING_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `database_version` (`id` INT NOT NULL AUTO_INCREMENT, `version` INT(11), PRIMARY KEY(id));";
    private static final String INSERT_VERSION_QUERY = "INSERT INTO `database_version` (`id`, `version`) VALUES (1, ?) ON DUPLICATE KEY UPDATE `id` = ?;";
    private static final String GET_VERSION_QUERY = "SELECT `version` FROM `database_version` WHERE `id` = 1;";
    private static final String ALTER_LOCKED_COLUMN_QUERY = "ALTER TABLE `worlds` CHANGE COLUMN `locked` `locked` BIGINT NOT NULL DEFAULT 0;";
    private static final String CREATE_WORLDS_TABLE_QUERY = "CREATE TABLE IF NOT EXISTS `worlds` (`id` INT NOT NULL AUTO_INCREMENT, `name` VARCHAR(255) UNIQUE, `world` MEDIUMBLOB, `locked` BIGINT, PRIMARY KEY(id));";
    private static final String SELECT_WORLD_QUERY = "SELECT `world`, `locked` FROM `worlds` WHERE `name` = ?;";
    private static final String UPDATE_WORLD_QUERY = "INSERT INTO `worlds` (`name`, `world`, `locked`) VALUES (?, ?, 1) ON DUPLICATE KEY UPDATE `world` = ?;";
    private static final String UPDATE_LOCK_QUERY = "UPDATE `worlds` SET `locked` = ? WHERE `name` = ?;";
    private static final String DELETE_WORLD_QUERY = "DELETE FROM `worlds` WHERE `name` = ?;";
    private static final String LIST_WORLDS_QUERY = "SELECT `name` FROM `worlds`;";
    private final Map<String, ScheduledFuture> lockedWorlds = new HashMap<String, ScheduledFuture>();
    private final HikariDataSource source;

    public MysqlLoader(DatasourcesConfig.MysqlConfig config) throws SQLException {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setJdbcUrl("jdbc:mysql://" + config.getHost() + ":" + config.getPort() + "/" + config.getDatabase() + "?autoReconnect=true&allowMultiQueries=true");
        hikariConfig.setUsername(config.getUsername());
        hikariConfig.setPassword(config.getPassword());
        hikariConfig.addDataSourceProperty("cachePrepStmts", "true");
        hikariConfig.addDataSourceProperty("prepStmtCacheSize", "250");
        hikariConfig.addDataSourceProperty("prepStmtCacheSqlLimit", "2048");
        hikariConfig.addDataSourceProperty("useServerPrepStmts", "true");
        hikariConfig.addDataSourceProperty("useLocalSessionState", "true");
        hikariConfig.addDataSourceProperty("rewriteBatchedStatements", "true");
        hikariConfig.addDataSourceProperty("cacheResultSetMetadata", "true");
        hikariConfig.addDataSourceProperty("cacheServerConfiguration", "true");
        hikariConfig.addDataSourceProperty("elideSetAutoCommits", "true");
        hikariConfig.addDataSourceProperty("maintainTimeStats", "false");
        this.source = new HikariDataSource(hikariConfig);
        try (Connection con = this.source.getConnection();){
            try (PreparedStatement statement = con.prepareStatement(CREATE_WORLDS_TABLE_QUERY);){
                statement.execute();
            }
            statement = con.prepareStatement(CREATE_VERSIONING_TABLE_QUERY);
            var6_8 = null;
            try {
                statement.execute();
            }
            catch (Throwable throwable) {
                var6_8 = throwable;
                throw throwable;
            }
            finally {
                if (statement != null) {
                    if (var6_8 != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable) {
                            var6_8.addSuppressed(throwable);
                        }
                    } else {
                        statement.close();
                    }
                }
            }
        }
    }

    @Override
    public void update() throws IOException, UpdatableLoader.NewerDatabaseException {
        block66: {
            try (Connection con = this.source.getConnection();){
                int version;
                try (PreparedStatement statement2 = con.prepareStatement(GET_VERSION_QUERY);
                     ResultSet set = statement2.executeQuery();){
                    version = set.next() ? set.getInt(1) : -1;
                }
                if (version > 1) {
                    throw new UpdatableLoader.NewerDatabaseException(1, version);
                }
                if (version >= 1) break block66;
                Logging.warning("Your SWM MySQL database is outdated. The update process will start in 10 seconds.");
                Logging.warning("Note that this update might make your database incompatible with older SWM versions.");
                Logging.warning("Make sure no other servers with older SWM versions are using this database.");
                Logging.warning("Shut down the server to prevent your database from being updated.");
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException statement2) {
                    // empty catch block
                }
                statement2 = con.prepareStatement(ALTER_LOCKED_COLUMN_QUERY);
                var4_6 = null;
                try {
                    statement2.executeUpdate();
                }
                catch (Throwable throwable) {
                    var4_6 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement2 != null) {
                        if (var4_6 != null) {
                            try {
                                statement2.close();
                            }
                            catch (Throwable throwable) {
                                var4_6.addSuppressed(throwable);
                            }
                        } else {
                            statement2.close();
                        }
                    }
                }
                statement2 = con.prepareStatement(INSERT_VERSION_QUERY);
                var4_6 = null;
                try {
                    statement2.setInt(1, 1);
                    statement2.setInt(2, 1);
                    statement2.executeUpdate();
                }
                catch (Throwable throwable) {
                    var4_6 = throwable;
                    throw throwable;
                }
                finally {
                    if (statement2 != null) {
                        if (var4_6 != null) {
                            try {
                                statement2.close();
                            }
                            catch (Throwable throwable) {
                                var4_6.addSuppressed(throwable);
                            }
                        } else {
                            statement2.close();
                        }
                    }
                }
            }
            catch (SQLException ex) {
                throw new IOException(ex);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] loadWorld(String worldName, boolean readOnly) throws UnknownWorldException, IOException, WorldInUseException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void updateLock(String worldName, boolean forceSchedule) {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_LOCK_QUERY);){
            statement.setLong(1, System.currentTimeMillis());
            statement.setString(2, worldName);
            statement.executeUpdate();
        }
        catch (SQLException ex) {
            Logging.error("Failed to update the lock for world " + worldName + ":");
            ex.printStackTrace();
        }
        if (forceSchedule || this.lockedWorlds.containsKey(worldName)) {
            this.lockedWorlds.put(worldName, SERVICE.schedule(() -> this.updateLock(worldName, false), 60000L, TimeUnit.MILLISECONDS));
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean worldExists(String worldName) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public List<String> listWorlds() throws IOException {
        ArrayList<String> worldList = new ArrayList<String>();
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(LIST_WORLDS_QUERY);){
            ResultSet set = statement.executeQuery();
            while (set.next()) {
                worldList.add(set.getString("name"));
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
        return worldList;
    }

    @Override
    public void saveWorld(String worldName, byte[] serializedWorld, boolean lock) throws IOException {
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_WORLD_QUERY);){
            statement.setString(1, worldName);
            statement.setBytes(2, serializedWorld);
            statement.setBytes(3, serializedWorld);
            statement.executeUpdate();
            if (lock) {
                this.updateLock(worldName, true);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    @Override
    public void unlockWorld(String worldName) throws IOException, UnknownWorldException {
        ScheduledFuture future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(UPDATE_LOCK_QUERY);){
            statement.setLong(1, 0L);
            statement.setString(2, worldName);
            if (statement.executeUpdate() == 0) {
                throw new UnknownWorldException(worldName);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public boolean isWorldLocked(String worldName) throws IOException, UnknownWorldException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void deleteWorld(String worldName) throws IOException, UnknownWorldException {
        ScheduledFuture future = this.lockedWorlds.remove(worldName);
        if (future != null) {
            future.cancel(false);
        }
        try (Connection con = this.source.getConnection();
             PreparedStatement statement = con.prepareStatement(DELETE_WORLD_QUERY);){
            statement.setString(1, worldName);
            if (statement.executeUpdate() == 0) {
                throw new UnknownWorldException(worldName);
            }
        }
        catch (SQLException ex) {
            throw new IOException(ex);
        }
    }
}

