/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.config;

import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.Setting;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import org.bukkit.Difficulty;
import org.bukkit.World;

@ConfigSerializable
public class WorldData {
    @Setting(value="source")
    private String dataSource = "file";
    @Setting(value="spawn")
    private String spawn = "0, 255, 0";
    @Setting(value="difficulty")
    private String difficulty = "peaceful";
    @Setting(value="allowMonsters")
    private boolean allowMonsters = true;
    @Setting(value="allowAnimals")
    private boolean allowAnimals = true;
    @Setting(value="pvp")
    private boolean pvp = true;
    @Setting(value="environment")
    private String environment = "NORMAL";
    @Setting(value="worldType")
    private String worldType = "DEFAULT";
    @Setting(value="loadOnStartup")
    private boolean loadOnStartup = true;
    @Setting(value="readOnly")
    private boolean readOnly = false;

    public SlimePropertyMap toPropertyMap() {
        double spawnZ;
        double spawnY;
        double spawnX;
        try {
            Enum.valueOf(Difficulty.class, this.difficulty.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("unknown difficulty '" + this.difficulty + "'");
        }
        String[] spawnLocationSplit = this.spawn.split(", ");
        try {
            spawnX = Double.parseDouble(spawnLocationSplit[0]);
            spawnY = Double.parseDouble(spawnLocationSplit[1]);
            spawnZ = Double.parseDouble(spawnLocationSplit[2]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException ex) {
            throw new IllegalArgumentException("invalid spawn location '" + this.spawn + "'");
        }
        String environment = this.environment;
        try {
            Enum.valueOf(World.Environment.class, environment.toUpperCase());
        }
        catch (IllegalArgumentException ex) {
            try {
                int envId = Integer.parseInt(environment);
                if (envId < -1 || envId > 1) {
                    throw new NumberFormatException(environment);
                }
                environment = World.Environment.getEnvironment((int)envId).name();
            }
            catch (NumberFormatException ex2) {
                throw new IllegalArgumentException("unknown environment '" + this.environment + "'");
            }
        }
        SlimePropertyMap propertyMap = new SlimePropertyMap();
        propertyMap.setInt(SlimeProperties.SPAWN_X, (int)spawnX);
        propertyMap.setInt(SlimeProperties.SPAWN_Y, (int)spawnY);
        propertyMap.setInt(SlimeProperties.SPAWN_Z, (int)spawnZ);
        propertyMap.setString(SlimeProperties.DIFFICULTY, this.difficulty);
        propertyMap.setBoolean(SlimeProperties.ALLOW_MONSTERS, this.allowMonsters);
        propertyMap.setBoolean(SlimeProperties.ALLOW_ANIMALS, this.allowAnimals);
        propertyMap.setBoolean(SlimeProperties.PVP, this.pvp);
        propertyMap.setString(SlimeProperties.ENVIRONMENT, environment);
        propertyMap.setString(SlimeProperties.WORLD_TYPE, this.worldType);
        return propertyMap;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public String getSpawn() {
        return this.spawn;
    }

    public String getDifficulty() {
        return this.difficulty;
    }

    public boolean isAllowMonsters() {
        return this.allowMonsters;
    }

    public boolean isAllowAnimals() {
        return this.allowAnimals;
    }

    public boolean isPvp() {
        return this.pvp;
    }

    public String getEnvironment() {
        return this.environment;
    }

    public String getWorldType() {
        return this.worldType;
    }

    public boolean isLoadOnStartup() {
        return this.loadOnStartup;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setDataSource(String dataSource) {
        this.dataSource = dataSource;
    }

    public void setSpawn(String spawn) {
        this.spawn = spawn;
    }

    public void setDifficulty(String difficulty) {
        this.difficulty = difficulty;
    }

    public void setAllowMonsters(boolean allowMonsters) {
        this.allowMonsters = allowMonsters;
    }

    public void setAllowAnimals(boolean allowAnimals) {
        this.allowAnimals = allowAnimals;
    }

    public void setPvp(boolean pvp) {
        this.pvp = pvp;
    }

    public void setEnvironment(String environment) {
        this.environment = environment;
    }

    public void setWorldType(String worldType) {
        this.worldType = worldType;
    }

    public void setLoadOnStartup(boolean loadOnStartup) {
        this.loadOnStartup = loadOnStartup;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WorldData)) {
            return false;
        }
        WorldData other = (WorldData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$dataSource = this.getDataSource();
        String other$dataSource = other.getDataSource();
        if (this$dataSource == null ? other$dataSource != null : !this$dataSource.equals(other$dataSource)) {
            return false;
        }
        String this$spawn = this.getSpawn();
        String other$spawn = other.getSpawn();
        if (this$spawn == null ? other$spawn != null : !this$spawn.equals(other$spawn)) {
            return false;
        }
        String this$difficulty = this.getDifficulty();
        String other$difficulty = other.getDifficulty();
        if (this$difficulty == null ? other$difficulty != null : !this$difficulty.equals(other$difficulty)) {
            return false;
        }
        if (this.isAllowMonsters() != other.isAllowMonsters()) {
            return false;
        }
        if (this.isAllowAnimals() != other.isAllowAnimals()) {
            return false;
        }
        if (this.isPvp() != other.isPvp()) {
            return false;
        }
        String this$environment = this.getEnvironment();
        String other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !this$environment.equals(other$environment)) {
            return false;
        }
        String this$worldType = this.getWorldType();
        String other$worldType = other.getWorldType();
        if (this$worldType == null ? other$worldType != null : !this$worldType.equals(other$worldType)) {
            return false;
        }
        if (this.isLoadOnStartup() != other.isLoadOnStartup()) {
            return false;
        }
        return this.isReadOnly() == other.isReadOnly();
    }

    protected boolean canEqual(Object other) {
        return other instanceof WorldData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $dataSource = this.getDataSource();
        result = result * 59 + ($dataSource == null ? 43 : $dataSource.hashCode());
        String $spawn = this.getSpawn();
        result = result * 59 + ($spawn == null ? 43 : $spawn.hashCode());
        String $difficulty = this.getDifficulty();
        result = result * 59 + ($difficulty == null ? 43 : $difficulty.hashCode());
        result = result * 59 + (this.isAllowMonsters() ? 79 : 97);
        result = result * 59 + (this.isAllowAnimals() ? 79 : 97);
        result = result * 59 + (this.isPvp() ? 79 : 97);
        String $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : $environment.hashCode());
        String $worldType = this.getWorldType();
        result = result * 59 + ($worldType == null ? 43 : $worldType.hashCode());
        result = result * 59 + (this.isLoadOnStartup() ? 79 : 97);
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "WorldData(dataSource=" + this.getDataSource() + ", spawn=" + this.getSpawn() + ", difficulty=" + this.getDifficulty() + ", allowMonsters=" + this.isAllowMonsters() + ", allowAnimals=" + this.isAllowAnimals() + ", pvp=" + this.isPvp() + ", environment=" + this.getEnvironment() + ", worldType=" + this.getWorldType() + ", loadOnStartup=" + this.isLoadOnStartup() + ", readOnly=" + this.isReadOnly() + ")";
    }
}

