/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.config;

import com.google.common.reflect.TypeToken;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.Setting;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.serialize.ConfigSerializable;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.log.Logging;
import java.io.IOException;

@ConfigSerializable
public class MainConfig {
    @Setting(value="enable_async_world_gen", comment="Only enable this if you don't have any other plugins that generate worlds.")
    private boolean asyncWorldGenerate = false;
    @Setting(value="updater")
    private UpdaterOptions updaterOptions = new UpdaterOptions();

    public void save() {
        try {
            ConfigManager.getMainConfigLoader().save(ConfigManager.getMainConfigLoader().createEmptyNode().setValue(TypeToken.of(MainConfig.class), (MainConfig)this));
        }
        catch (ObjectMappingException | IOException ex) {
            Logging.error("Failed to save worlds config file:");
            ex.printStackTrace();
        }
    }

    public boolean isAsyncWorldGenerate() {
        return this.asyncWorldGenerate;
    }

    public UpdaterOptions getUpdaterOptions() {
        return this.updaterOptions;
    }

    public void setAsyncWorldGenerate(boolean asyncWorldGenerate) {
        this.asyncWorldGenerate = asyncWorldGenerate;
    }

    public void setUpdaterOptions(UpdaterOptions updaterOptions) {
        this.updaterOptions = updaterOptions;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MainConfig)) {
            return false;
        }
        MainConfig other = (MainConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isAsyncWorldGenerate() != other.isAsyncWorldGenerate()) {
            return false;
        }
        UpdaterOptions this$updaterOptions = this.getUpdaterOptions();
        UpdaterOptions other$updaterOptions = other.getUpdaterOptions();
        return !(this$updaterOptions == null ? other$updaterOptions != null : !this$updaterOptions.equals(other$updaterOptions));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MainConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isAsyncWorldGenerate() ? 79 : 97);
        UpdaterOptions $updaterOptions = this.getUpdaterOptions();
        result = result * 59 + ($updaterOptions == null ? 43 : $updaterOptions.hashCode());
        return result;
    }

    public String toString() {
        return "MainConfig(asyncWorldGenerate=" + this.isAsyncWorldGenerate() + ", updaterOptions=" + this.getUpdaterOptions() + ")";
    }

    @ConfigSerializable
    public static class UpdaterOptions {
        @Setting(value="enabled")
        private boolean enabled = true;
        @Setting(value="onjoinmessage")
        private boolean messageEnabled = true;

        public boolean isEnabled() {
            return this.enabled;
        }

        public boolean isMessageEnabled() {
            return this.messageEnabled;
        }
    }
}

