/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.config;

import com.google.common.reflect.TypeToken;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.loader.HeaderMode;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.objectmapping.ObjectMappingException;
import com.grinderwolf.swm.internal.ninja.leaping.configurate.yaml.YAMLConfigurationLoader;
import com.grinderwolf.swm.plugin.SWMPlugin;
import com.grinderwolf.swm.plugin.config.DatasourcesConfig;
import com.grinderwolf.swm.plugin.config.MainConfig;
import com.grinderwolf.swm.plugin.config.WorldsConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.yaml.snakeyaml.DumperOptions;

public class ConfigManager {
    private static final File PLUGIN_DIR = new File("plugins", "SlimeWorldManager");
    private static final File MAIN_FILE = new File(PLUGIN_DIR, "main.yml");
    private static final File WORLDS_FILE = new File(PLUGIN_DIR, "worlds.yml");
    private static final File SOURCES_FILE = new File(PLUGIN_DIR, "sources.yml");
    private static MainConfig mainConfig;
    private static YAMLConfigurationLoader mainConfigLoader;
    private static WorldsConfig worldConfig;
    private static YAMLConfigurationLoader worldConfigLoader;
    private static DatasourcesConfig datasourcesConfig;

    public static void initialize() throws IOException, ObjectMappingException {
        ConfigManager.copyDefaultConfigs();
        mainConfigLoader = ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(MAIN_FILE.toPath())).setFlowStyle(DumperOptions.FlowStyle.BLOCK).setHeaderMode(HeaderMode.PRESERVE)).build();
        mainConfig = mainConfigLoader.load().getValue(TypeToken.of(MainConfig.class));
        worldConfigLoader = ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(WORLDS_FILE.toPath())).setFlowStyle(DumperOptions.FlowStyle.BLOCK).setHeaderMode(HeaderMode.PRESERVE)).build();
        worldConfig = worldConfigLoader.load().getValue(TypeToken.of(WorldsConfig.class));
        YAMLConfigurationLoader datasourcesConfigLoader = ((YAMLConfigurationLoader.Builder)((YAMLConfigurationLoader.Builder)YAMLConfigurationLoader.builder().setPath(SOURCES_FILE.toPath())).setFlowStyle(DumperOptions.FlowStyle.BLOCK).setHeaderMode(HeaderMode.PRESERVE)).build();
        datasourcesConfig = datasourcesConfigLoader.load().getValue(TypeToken.of(DatasourcesConfig.class));
        mainConfigLoader.save(mainConfigLoader.createEmptyNode().setValue(TypeToken.of(MainConfig.class), (MainConfig)mainConfig));
        worldConfig.save();
        datasourcesConfigLoader.save(datasourcesConfigLoader.createEmptyNode().setValue(TypeToken.of(DatasourcesConfig.class), (DatasourcesConfig)datasourcesConfig));
    }

    private static void copyDefaultConfigs() throws IOException {
        PLUGIN_DIR.mkdirs();
        if (!MAIN_FILE.exists()) {
            Files.copy(SWMPlugin.getInstance().getResource("main.yml"), MAIN_FILE.toPath(), new CopyOption[0]);
        }
        if (!WORLDS_FILE.exists()) {
            Files.copy(SWMPlugin.getInstance().getResource("worlds.yml"), WORLDS_FILE.toPath(), new CopyOption[0]);
        }
        if (!SOURCES_FILE.exists()) {
            Files.copy(SWMPlugin.getInstance().getResource("worlds.yml"), SOURCES_FILE.toPath(), new CopyOption[0]);
        }
    }

    public static MainConfig getMainConfig() {
        return mainConfig;
    }

    static YAMLConfigurationLoader getMainConfigLoader() {
        return mainConfigLoader;
    }

    public static WorldsConfig getWorldConfig() {
        return worldConfig;
    }

    static YAMLConfigurationLoader getWorldConfigLoader() {
        return worldConfigLoader;
    }

    public static DatasourcesConfig getDatasourcesConfig() {
        return datasourcesConfig;
    }
}

