/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.commands.sub;

import com.grinderwolf.swm.plugin.SWMPlugin;
import com.grinderwolf.swm.plugin.commands.sub.Subcommand;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.log.Logging;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;

public class WorldListCmd
implements Subcommand {
    private static final int MAX_ITEMS_PER_PAGE = 5;
    private final String usage = "list [slime] [page]";
    private final String description = "List all worlds. To only list slime worlds, use the 'slime' argument.";
    private final String permission = "swm.worldlist";

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        int page;
        boolean onlySlime;
        Map<String, Boolean> loadedWorlds = Bukkit.getWorlds().stream().collect(Collectors.toMap(World::getName, world -> SWMPlugin.getInstance().getNms().getSlimeWorld((World)world) != null));
        boolean bl = onlySlime = args.length > 0 && args[0].equalsIgnoreCase("slime");
        if (onlySlime) {
            loadedWorlds.entrySet().removeIf(entry -> (Boolean)entry.getValue() == false);
        }
        if (args.length == 0 || args.length == 1 && args[0].equalsIgnoreCase("slime")) {
            page = 1;
        } else {
            String pageString = args[args.length - 1];
            try {
                page = Integer.parseInt(pageString);
                if (page < 1) {
                    throw new NumberFormatException();
                }
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "'" + pageString + "' is not a valid number.");
                return true;
            }
        }
        ArrayList<String> worldsList = new ArrayList<String>(loadedWorlds.keySet());
        ConfigManager.getWorldConfig().getWorlds().keySet().stream().filter(world -> !worldsList.contains(world)).forEach(worldsList::add);
        if (worldsList.isEmpty()) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "There are no worlds configured.");
            return true;
        }
        int offset = (page - 1) * 5;
        double d = (double)worldsList.size() / 5.0;
        int maxPages = (int)d + (d > (double)((int)d) ? 1 : 0);
        if (offset >= worldsList.size()) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "There " + (maxPages == 1 ? "is" : "are") + " only " + maxPages + " page" + (maxPages == 1 ? "" : "s") + "!");
            return true;
        }
        worldsList.sort(String::compareTo);
        sender.sendMessage(Logging.COMMAND_PREFIX + "World list " + ChatColor.YELLOW + "[" + page + "/" + maxPages + "]" + ChatColor.GRAY + ":");
        for (int i = offset; i - offset < 5 && i < worldsList.size(); ++i) {
            String world2 = (String)worldsList.get(i);
            if (loadedWorlds.containsKey(world2)) {
                sender.sendMessage(ChatColor.GRAY + " - " + ChatColor.GREEN + world2 + " " + (loadedWorlds.get(world2) != false ? "" : ChatColor.BLUE + ChatColor.ITALIC.toString() + ChatColor.UNDERLINE + "(not in SRF)"));
                continue;
            }
            sender.sendMessage(ChatColor.GRAY + " - " + ChatColor.RED + world2);
        }
        return true;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }
}

