/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.commands.sub;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import com.grinderwolf.swm.api.loaders.SlimeLoader;
import com.grinderwolf.swm.plugin.SWMPlugin;
import com.grinderwolf.swm.plugin.commands.CommandManager;
import com.grinderwolf.swm.plugin.commands.sub.Subcommand;
import com.grinderwolf.swm.plugin.config.ConfigManager;
import com.grinderwolf.swm.plugin.config.WorldData;
import com.grinderwolf.swm.plugin.config.WorldsConfig;
import com.grinderwolf.swm.plugin.loaders.LoaderUtils;
import com.grinderwolf.swm.plugin.log.Logging;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.plugin.Plugin;

public class DeleteWorldCmd
implements Subcommand {
    private final String usage = "delete <world> [data-source]";
    private final String description = "Delete a world.";
    private final String permission = "swm.deleteworld";
    private final Cache<String, String[]> deleteCache = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.MINUTES).build();

    @Override
    public boolean onCommand(CommandSender sender, String[] args) {
        if (args.length > 0) {
            String source;
            String worldName = args[0];
            World world = Bukkit.getWorld((String)worldName);
            if (world != null) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "World " + worldName + " is loaded on this server! Unload it by running the command " + ChatColor.GRAY + "/swm unload " + worldName + ChatColor.RED + ".");
                return true;
            }
            if (args.length > 1) {
                source = args[1];
            } else {
                WorldsConfig config = ConfigManager.getWorldConfig();
                WorldData worldData = config.getWorlds().get(worldName);
                if (worldData == null) {
                    sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Unknown world " + worldName + "! Are you sure you've typed it correctly?");
                    return true;
                }
                source = worldData.getDataSource();
            }
            SlimeLoader loader = LoaderUtils.getLoader(source);
            if (loader == null) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Unknown data source " + source + "!  Are you sure you've typed it correctly?");
                return true;
            }
            if (CommandManager.getInstance().getWorldsInUse().contains(worldName)) {
                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "World " + worldName + " is already being used on another command! Wait some time and try again.");
                return true;
            }
            Object[] oldArgs = this.deleteCache.getIfPresent(sender.getName());
            if (oldArgs != null) {
                this.deleteCache.invalidate(sender.getName());
                if (Arrays.equals(args, oldArgs)) {
                    sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.GRAY + "Deleting world " + ChatColor.YELLOW + worldName + ChatColor.GRAY + "...");
                    CommandManager.getInstance().getWorldsInUse().add(worldName);
                    Bukkit.getScheduler().runTaskAsynchronously((Plugin)SWMPlugin.getInstance(), () -> {
                        try {
                            if (loader.isWorldLocked(worldName)) {
                                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "World " + worldName + "is being used on another server.");
                                return;
                            }
                            long start = System.currentTimeMillis();
                            loader.deleteWorld(worldName);
                            WorldsConfig config = ConfigManager.getWorldConfig();
                            config.getWorlds().remove(worldName);
                            config.save();
                            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.GREEN + "World " + ChatColor.YELLOW + worldName + ChatColor.GREEN + " deleted in " + (System.currentTimeMillis() - start) + "ms!");
                        }
                        catch (IOException ex) {
                            if (!(sender instanceof ConsoleCommandSender)) {
                                sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Failed to delete world " + worldName + ". Take a look at the server console for more information.");
                            }
                            Logging.error("Failed to delete world " + worldName + ". Stack trace:");
                            ex.printStackTrace();
                        }
                        catch (UnknownWorldException ex) {
                            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Data source " + source + " does not contain any world called " + worldName + ".");
                        }
                        finally {
                            CommandManager.getInstance().getWorldsInUse().remove(worldName);
                        }
                    });
                    return true;
                }
            }
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + ChatColor.BOLD + "WARNING: " + ChatColor.GRAY + "You're about to delete world " + ChatColor.YELLOW + worldName + ChatColor.GRAY + ". This action cannot be undone.");
            sender.sendMessage(" ");
            sender.sendMessage(ChatColor.GRAY + "If you are sure you want to continue, type again this command.");
            this.deleteCache.put(sender.getName(), args);
            return true;
        }
        return false;
    }

    @Override
    public String getUsage() {
        return this.usage;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getPermission() {
        return this.permission;
    }

    public Cache<String, String[]> getDeleteCache() {
        return this.deleteCache;
    }
}

