/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.plugin.commands;

import com.grinderwolf.swm.plugin.commands.sub.CloneWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.CreateWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.DSListCmd;
import com.grinderwolf.swm.plugin.commands.sub.DeleteWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.GotoCmd;
import com.grinderwolf.swm.plugin.commands.sub.HelpCmd;
import com.grinderwolf.swm.plugin.commands.sub.ImportWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.LoadTemplateWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.LoadWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.MigrateWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.ReloadConfigCmd;
import com.grinderwolf.swm.plugin.commands.sub.Subcommand;
import com.grinderwolf.swm.plugin.commands.sub.UnloadWorldCmd;
import com.grinderwolf.swm.plugin.commands.sub.VersionCmd;
import com.grinderwolf.swm.plugin.commands.sub.WorldListCmd;
import com.grinderwolf.swm.plugin.log.Logging;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandManager
implements CommandExecutor {
    private static CommandManager instance;
    private Map<String, Subcommand> commands = new HashMap<String, Subcommand>();
    private final Set<String> worldsInUse = new HashSet<String>();

    public CommandManager() {
        instance = this;
        this.commands.put("help", new HelpCmd());
        this.commands.put("version", new VersionCmd());
        this.commands.put("goto", new GotoCmd());
        this.commands.put("load", new LoadWorldCmd());
        this.commands.put("load-template", new LoadTemplateWorldCmd());
        this.commands.put("clone-world", new CloneWorldCmd());
        this.commands.put("unload", new UnloadWorldCmd());
        this.commands.put("list", new WorldListCmd());
        this.commands.put("dslist", new DSListCmd());
        this.commands.put("migrate", new MigrateWorldCmd());
        this.commands.put("delete", new DeleteWorldCmd());
        this.commands.put("import", new ImportWorldCmd());
        this.commands.put("reload", new ReloadConfigCmd());
        this.commands.put("create", new CreateWorldCmd());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.AQUA + "Slime World Manager" + ChatColor.GRAY + " is a plugin that implements the Slime Region Format, designed by the Hypixel Dev Team to load and save worlds more efficiently. To check out the help page, type " + ChatColor.YELLOW + "/swm help" + ChatColor.GRAY + ".");
            return true;
        }
        Subcommand command = this.commands.get(args[0]);
        if (command == null) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Unknown command. To check out the help page, type " + ChatColor.GRAY + "/swm help" + ChatColor.RED + ".");
            return true;
        }
        if (command.inGameOnly() && !(sender instanceof Player)) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "This command can only be run in-game.");
            return true;
        }
        if (!(command.getPermission().equals("") || sender.hasPermission(command.getPermission()) || sender.hasPermission("swm.*"))) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "You do not have permission to perform this command.");
            return true;
        }
        String[] subCmdArgs = new String[args.length - 1];
        System.arraycopy(args, 1, subCmdArgs, 0, subCmdArgs.length);
        if (!command.onCommand(sender, subCmdArgs)) {
            sender.sendMessage(Logging.COMMAND_PREFIX + ChatColor.RED + "Command usage: /swm " + ChatColor.GRAY + command.getUsage() + ChatColor.RED + ".");
        }
        return true;
    }

    public Collection<Subcommand> getCommands() {
        return this.commands.values();
    }

    public static CommandManager getInstance() {
        return instance;
    }

    public Set<String> getWorldsInUse() {
        return this.worldsInUse;
    }
}

