/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_8_R3;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.v1_8_R3.Converter;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_8_R3.Chunk;
import net.minecraft.server.v1_8_R3.ChunkSection;
import net.minecraft.server.v1_8_R3.Entity;
import net.minecraft.server.v1_8_R3.NBTBase;
import net.minecraft.server.v1_8_R3.NBTTagCompound;
import net.minecraft.server.v1_8_R3.TileEntity;

public class NMSSlimeChunk
implements SlimeChunk {
    private Chunk chunk;

    @Override
    public String getWorldName() {
        return this.chunk.getWorld().getWorldData().getName();
    }

    @Override
    public int getX() {
        return this.chunk.locX;
    }

    @Override
    public int getZ() {
        return this.chunk.locZ;
    }

    @Override
    public SlimeChunkSection[] getSections() {
        SlimeChunkSection[] sections = new SlimeChunkSection[16];
        for (int sectionId = 0; sectionId < this.chunk.getSections().length; ++sectionId) {
            ChunkSection section = this.chunk.getSections()[sectionId];
            if (section == null) continue;
            section.recalcBlockCounts();
            if (section.a()) continue;
            NibbleArray blockLightArray = Converter.convertArray(section.getEmittedLightArray());
            NibbleArray skyLightArray = Converter.convertArray(section.getSkyLightArray());
            byte[] blocks = new byte[4096];
            NibbleArray blockDataArray = new NibbleArray(4096);
            for (int i = 0; i < section.getIdArray().length; ++i) {
                char packed = section.getIdArray()[i];
                blocks[i] = (byte)(packed >> 4 & 0xFF);
                blockDataArray.set(i, packed & 0xF);
            }
            sections[sectionId] = new CraftSlimeChunkSection(blocks, blockDataArray, null, null, blockLightArray, skyLightArray);
        }
        return sections;
    }

    @Override
    public CompoundTag getHeightMaps() {
        CompoundTag heightMapsCompound = new CompoundTag("", new CompoundMap());
        heightMapsCompound.getValue().put("heightMap", new IntArrayTag("heightMap", this.chunk.heightMap));
        return heightMapsCompound;
    }

    @Override
    public int[] getBiomes() {
        return NMSSlimeChunk.toIntArray(this.chunk.getBiomeIndex());
    }

    @Override
    public List<CompoundTag> getTileEntities() {
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (TileEntity entity : this.chunk.getTileEntities().values()) {
            NBTTagCompound entityNbt = new NBTTagCompound();
            entity.b(entityNbt);
            tileEntities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
        }
        return tileEntities;
    }

    @Override
    public List<CompoundTag> getEntities() {
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (int i = 0; i < this.chunk.getEntitySlices().length; ++i) {
            for (Entity entity : this.chunk.getEntitySlices()[i]) {
                NBTTagCompound entityNbt;
                if (!entity.d(entityNbt = new NBTTagCompound())) continue;
                this.chunk.g(true);
                entities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
            }
        }
        return entities;
    }

    private static int[] toIntArray(byte[] buf) {
        ByteBuffer buffer = ByteBuffer.wrap(buf).order(ByteOrder.BIG_ENDIAN);
        int[] ret = new int[buf.length / 4];
        buffer.asIntBuffer().get(ret);
        return ret;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NMSSlimeChunk)) {
            return false;
        }
        NMSSlimeChunk other = (NMSSlimeChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Chunk this$chunk = this.getChunk();
        Chunk other$chunk = other.getChunk();
        return !(this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NMSSlimeChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Chunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        return result;
    }

    public String toString() {
        return "NMSSlimeChunk(chunk=" + this.getChunk() + ")";
    }

    public NMSSlimeChunk(Chunk chunk) {
        this.chunk = chunk;
    }
}

