/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_15_R1;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.grinderwolf.swm.api.exceptions.UnknownWorldException;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.api.world.properties.SlimePropertyMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.v1_15_R1.Converter;
import com.grinderwolf.swm.nms.v1_15_R1.NMSSlimeChunk;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.server.v1_15_R1.BiomeStorage;
import net.minecraft.server.v1_15_R1.BlockPosition;
import net.minecraft.server.v1_15_R1.Chunk;
import net.minecraft.server.v1_15_R1.ChunkConverter;
import net.minecraft.server.v1_15_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_15_R1.ChunkSection;
import net.minecraft.server.v1_15_R1.DimensionManager;
import net.minecraft.server.v1_15_R1.EntityTypes;
import net.minecraft.server.v1_15_R1.EnumDifficulty;
import net.minecraft.server.v1_15_R1.EnumSkyBlock;
import net.minecraft.server.v1_15_R1.GameProfilerFiller;
import net.minecraft.server.v1_15_R1.HeightMap;
import net.minecraft.server.v1_15_R1.IChunkAccess;
import net.minecraft.server.v1_15_R1.IProgressUpdate;
import net.minecraft.server.v1_15_R1.IRegistry;
import net.minecraft.server.v1_15_R1.LightEngineThreaded;
import net.minecraft.server.v1_15_R1.MinecraftServer;
import net.minecraft.server.v1_15_R1.NBTBase;
import net.minecraft.server.v1_15_R1.NBTTagCompound;
import net.minecraft.server.v1_15_R1.NBTTagList;
import net.minecraft.server.v1_15_R1.ProtoChunkExtension;
import net.minecraft.server.v1_15_R1.RegistryBlocks;
import net.minecraft.server.v1_15_R1.SectionPosition;
import net.minecraft.server.v1_15_R1.TickList;
import net.minecraft.server.v1_15_R1.TickListChunk;
import net.minecraft.server.v1_15_R1.TileEntity;
import net.minecraft.server.v1_15_R1.World;
import net.minecraft.server.v1_15_R1.WorldMap;
import net.minecraft.server.v1_15_R1.WorldNBTStorage;
import net.minecraft.server.v1_15_R1.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldSaveEvent;

public class CustomWorldServer
extends WorldServer {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM World");
    private static final ExecutorService WORLD_SAVER_SERVICE = Executors.newFixedThreadPool(4, new ThreadFactoryBuilder().setNameFormat("SWM Pool Thread #%1$d").build());
    private final CraftSlimeWorld slimeWorld;
    private final Object saveLock = new Object();
    private final List<WorldMap> maps = new ArrayList<WorldMap>();
    private boolean ready = false;

    CustomWorldServer(CraftSlimeWorld world, WorldNBTStorage nbtStorage, DimensionManager dimensionManager, World.Environment env) {
        super(MinecraftServer.getServer(), MinecraftServer.getServer().executorService, nbtStorage, nbtStorage.getWorldData(), dimensionManager, (GameProfilerFiller)MinecraftServer.getServer().getMethodProfiler(), MinecraftServer.getServer().worldLoadListenerFactory.create(11), env, null);
        this.slimeWorld = world;
        SlimePropertyMap propertyMap = world.getPropertyMap();
        this.worldData.setDifficulty(EnumDifficulty.valueOf((String)propertyMap.getString(SlimeProperties.DIFFICULTY).toUpperCase()));
        this.worldData.setSpawn(new BlockPosition(propertyMap.getInt(SlimeProperties.SPAWN_X), propertyMap.getInt(SlimeProperties.SPAWN_Y), propertyMap.getInt(SlimeProperties.SPAWN_Z)));
        super.setSpawnFlags(propertyMap.getBoolean(SlimeProperties.ALLOW_MONSTERS).booleanValue(), propertyMap.getBoolean(SlimeProperties.ALLOW_ANIMALS).booleanValue());
        this.pvpMode = propertyMap.getBoolean(SlimeProperties.PVP);
        new File(nbtStorage.getDirectory(), "session.lock").delete();
        new File(nbtStorage.getDirectory(), "data").delete();
        nbtStorage.getDirectory().delete();
        nbtStorage.getDirectory().getParentFile().delete();
        for (CompoundTag mapTag : world.getWorldMaps()) {
            int id = mapTag.getIntValue("id").get();
            WorldMap map = new WorldMap("map_" + id);
            map.a((NBTTagCompound)Converter.convertTag(mapTag));
            this.a(map);
        }
    }

    public void save(IProgressUpdate progressUpdate, boolean forceSave, boolean flag1) {
        if (!this.slimeWorld.isReadOnly()) {
            Bukkit.getPluginManager().callEvent((Event)new WorldSaveEvent((org.bukkit.World)this.getWorld()));
            this.getChunkProvider().save(forceSave);
            this.getDataManager().saveWorldData(this.worldData, null);
            this.slimeWorld.getWorldMaps().clear();
            for (WorldMap map : this.maps) {
                NBTTagCompound compound = map.b(new NBTTagCompound());
                int id = Integer.parseInt(map.getId().substring(4));
                compound.setInt("id", id);
                this.slimeWorld.getWorldMaps().add((CompoundTag)Converter.convertTag("", (NBTBase)compound));
            }
            if (MinecraftServer.getServer().isStopped()) {
                this.save();
                try {
                    this.slimeWorld.getLoader().unlockWorld(this.slimeWorld.getName());
                }
                catch (IOException ex) {
                    LOGGER.error("Failed to unlock the world " + this.slimeWorld.getName() + ". Please unlock it manually by using the command /swm manualunlock. Stack trace:");
                    ex.printStackTrace();
                }
                catch (UnknownWorldException unknownWorldException) {}
            } else {
                WORLD_SAVER_SERVICE.execute(this::save);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void save() {
        Object object = this.saveLock;
        synchronized (object) {
            try {
                LOGGER.info("Saving world " + this.slimeWorld.getName() + "...");
                long start = System.currentTimeMillis();
                byte[] serializedWorld = this.slimeWorld.serialize();
                this.slimeWorld.getLoader().saveWorld(this.slimeWorld.getName(), serializedWorld, false);
                LOGGER.info("World " + this.slimeWorld.getName() + " saved in " + (System.currentTimeMillis() - start) + "ms.");
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    ProtoChunkExtension getChunk(int x, int z) {
        Chunk chunk;
        SlimeChunk slimeChunk = this.slimeWorld.getChunk(x, z);
        if (slimeChunk == null) {
            ChunkCoordIntPair pos = new ChunkCoordIntPair(x, z);
            BiomeStorage biomeStorage = new BiomeStorage(pos, this.getChunkProvider().getChunkGenerator().getWorldChunkManager(), null);
            TickListChunk airChunkTickList = new TickListChunk(arg_0 -> ((RegistryBlocks)IRegistry.BLOCK).getKey(arg_0), new ArrayList());
            TickListChunk fluidChunkTickList = new TickListChunk(arg_0 -> ((RegistryBlocks)IRegistry.FLUID).getKey(arg_0), new ArrayList());
            chunk = new Chunk((World)this, pos, biomeStorage, ChunkConverter.a, (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L, null, null);
            HeightMap.a((IChunkAccess)chunk, (Set)chunk.getChunkStatus().h());
            this.getChunkProvider().getLightEngine().b(pos, true);
        } else if (slimeChunk instanceof NMSSlimeChunk) {
            chunk = ((NMSSlimeChunk)slimeChunk).getChunk();
        } else {
            chunk = this.createChunk(slimeChunk);
            this.slimeWorld.updateChunk(new NMSSlimeChunk(chunk));
        }
        return new ProtoChunkExtension(chunk);
    }

    private Chunk createChunk(SlimeChunk chunk) {
        int x = chunk.getX();
        int z = chunk.getZ();
        LOGGER.debug("Loading chunk (" + x + ", " + z + ") on world " + this.slimeWorld.getName());
        ChunkCoordIntPair pos = new ChunkCoordIntPair(x, z);
        int[] biomeIntArray = chunk.getBiomes();
        BiomeStorage biomeStorage = new BiomeStorage(pos, this.getChunkProvider().getChunkGenerator().getWorldChunkManager(), biomeIntArray);
        TickListChunk airChunkTickList = new TickListChunk(arg_0 -> ((RegistryBlocks)IRegistry.BLOCK).getKey(arg_0), new ArrayList());
        TickListChunk fluidChunkTickList = new TickListChunk(arg_0 -> ((RegistryBlocks)IRegistry.FLUID).getKey(arg_0), new ArrayList());
        LOGGER.debug("Loading chunk sections for chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
        ChunkSection[] sections = new ChunkSection[16];
        LightEngineThreaded lightEngine = this.getChunkProvider().getLightEngine();
        lightEngine.b(pos, true);
        for (int sectionId = 0; sectionId < chunk.getSections().length; ++sectionId) {
            SlimeChunkSection slimeSection = chunk.getSections()[sectionId];
            if (slimeSection == null) continue;
            ChunkSection section = new ChunkSection(sectionId << 4);
            LOGGER.debug("ChunkSection #" + sectionId + " - Chunk (" + pos.x + ", " + pos.z + ") - World " + this.slimeWorld.getName() + ":");
            LOGGER.debug("Block palette:");
            LOGGER.debug(slimeSection.getPalette().toString());
            LOGGER.debug("Block states array:");
            LOGGER.debug((Object)slimeSection.getBlockStates());
            LOGGER.debug("Block light array:");
            LOGGER.debug(slimeSection.getBlockLight() != null ? (Object)slimeSection.getBlockLight().getBacking() : "Not present");
            LOGGER.debug("Sky light array:");
            LOGGER.debug(slimeSection.getSkyLight() != null ? (Object)slimeSection.getSkyLight().getBacking() : "Not present");
            section.getBlocks().a((NBTTagList)Converter.convertTag(slimeSection.getPalette()), slimeSection.getBlockStates());
            if (slimeSection.getBlockLight() != null) {
                lightEngine.a(EnumSkyBlock.BLOCK, SectionPosition.a((ChunkCoordIntPair)pos, (int)sectionId), Converter.convertArray(slimeSection.getBlockLight()));
            }
            if (slimeSection.getSkyLight() != null) {
                lightEngine.a(EnumSkyBlock.SKY, SectionPosition.a((ChunkCoordIntPair)pos, (int)sectionId), Converter.convertArray(slimeSection.getSkyLight()));
            }
            section.recalcBlockCounts();
            sections[sectionId] = section;
        }
        Consumer<Chunk> loadEntities = nmsChunk -> {
            LOGGER.debug("Loading tile entities for chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
            List<CompoundTag> tileEntities = chunk.getTileEntities();
            int loadedEntities = 0;
            if (tileEntities != null) {
                for (CompoundTag tag : tileEntities) {
                    TileEntity entity2;
                    Optional<String> type = tag.getStringValue("id");
                    if (!type.isPresent() || (entity2 = TileEntity.create((NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)))) == null) continue;
                    nmsChunk.a(entity2);
                    ++loadedEntities;
                }
            }
            LOGGER.debug("Loaded " + loadedEntities + " tile entities for chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
            LOGGER.debug("Loading entities for chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
            List<CompoundTag> entities = chunk.getEntities();
            loadedEntities = 0;
            if (entities != null) {
                for (CompoundTag tag : entities) {
                    EntityTypes.a((NBTTagCompound)((NBTTagCompound)Converter.convertTag(tag)), (World)nmsChunk.world, entity -> {
                        nmsChunk.a(entity);
                        return entity;
                    });
                    nmsChunk.d(true);
                    ++loadedEntities;
                }
            }
            LOGGER.debug("Loaded " + loadedEntities + " entities for chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
        };
        CompoundTag upgradeDataTag = ((CraftSlimeChunk)chunk).getUpgradeData();
        Chunk nmsChunk2 = new Chunk((World)this, pos, biomeStorage, upgradeDataTag == null ? ChunkConverter.a : new ChunkConverter((NBTTagCompound)Converter.convertTag(upgradeDataTag)), (TickList)airChunkTickList, (TickList)fluidChunkTickList, 0L, sections, loadEntities);
        EnumSet heightMapTypes = nmsChunk2.getChunkStatus().h();
        CompoundMap heightMaps = chunk.getHeightMaps().getValue();
        EnumSet<HeightMap.Type> unsetHeightMaps = EnumSet.noneOf(HeightMap.Type.class);
        for (HeightMap.Type type : heightMapTypes) {
            String name = type.a();
            if (heightMaps.containsKey(name)) {
                LongArrayTag heightMap = (LongArrayTag)heightMaps.get(name);
                nmsChunk2.a(type, heightMap.getValue());
                continue;
            }
            unsetHeightMaps.add(type);
        }
        HeightMap.a((IChunkAccess)nmsChunk2, unsetHeightMaps);
        LOGGER.debug("Loaded chunk (" + pos.x + ", " + pos.z + ") on world " + this.slimeWorld.getName());
        return nmsChunk2;
    }

    void saveChunk(Chunk chunk) {
        SlimeChunk slimeChunk = this.slimeWorld.getChunk(chunk.getPos().x, chunk.getPos().z);
        if (slimeChunk instanceof NMSSlimeChunk) {
            ((NMSSlimeChunk)slimeChunk).setChunk(chunk);
        } else {
            this.slimeWorld.updateChunk(new NMSSlimeChunk(chunk));
        }
    }

    public WorldMap a(String name) {
        int id = Integer.parseInt(name.substring(4));
        if (id >= this.maps.size()) {
            return null;
        }
        return this.maps.get(id);
    }

    public void a(WorldMap map) {
        int id = Integer.parseInt(map.getId().substring(4));
        if (this.maps.size() > id) {
            this.maps.set(id, map);
        } else {
            while (this.maps.size() < id) {
                this.maps.add(null);
            }
            this.maps.add(id, map);
        }
    }

    public int getWorldMapCount() {
        return this.maps.size();
    }

    public CraftSlimeWorld getSlimeWorld() {
        return this.slimeWorld;
    }

    public boolean isReady() {
        return this.ready;
    }

    public void setReady(boolean ready) {
        this.ready = ready;
    }
}

