/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_14_R1;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import com.grinderwolf.swm.nms.v1_14_R1.Converter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.v1_14_R1.BiomeBase;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.ChunkCoordIntPair;
import net.minecraft.server.v1_14_R1.ChunkSection;
import net.minecraft.server.v1_14_R1.DataPaletteBlock;
import net.minecraft.server.v1_14_R1.Entity;
import net.minecraft.server.v1_14_R1.EnumSkyBlock;
import net.minecraft.server.v1_14_R1.HeightMap;
import net.minecraft.server.v1_14_R1.IRegistry;
import net.minecraft.server.v1_14_R1.LightEngine;
import net.minecraft.server.v1_14_R1.NBTBase;
import net.minecraft.server.v1_14_R1.NBTTagCompound;
import net.minecraft.server.v1_14_R1.NBTTagList;
import net.minecraft.server.v1_14_R1.SectionPosition;
import net.minecraft.server.v1_14_R1.TileEntity;

public class NMSSlimeChunk
implements SlimeChunk {
    private Chunk chunk;

    @Override
    public String getWorldName() {
        return this.chunk.getWorld().getWorldData().getName();
    }

    @Override
    public int getX() {
        return this.chunk.getPos().x;
    }

    @Override
    public int getZ() {
        return this.chunk.getPos().z;
    }

    @Override
    public SlimeChunkSection[] getSections() {
        SlimeChunkSection[] sections = new SlimeChunkSection[16];
        LightEngine lightEngine = this.chunk.world.getChunkProvider().getLightEngine();
        for (int sectionId = 0; sectionId < this.chunk.getSections().length; ++sectionId) {
            ChunkSection section = this.chunk.getSections()[sectionId];
            if (section == null) continue;
            section.recalcBlockCounts();
            if (section.c()) continue;
            NibbleArray blockLightArray = Converter.convertArray(lightEngine.a(EnumSkyBlock.BLOCK).a(SectionPosition.a((ChunkCoordIntPair)this.chunk.getPos(), (int)sectionId)));
            NibbleArray skyLightArray = Converter.convertArray(lightEngine.a(EnumSkyBlock.SKY).a(SectionPosition.a((ChunkCoordIntPair)this.chunk.getPos(), (int)sectionId)));
            DataPaletteBlock dataPaletteBlock = section.getBlocks();
            NBTTagCompound blocksCompound = new NBTTagCompound();
            dataPaletteBlock.a(blocksCompound, "Palette", "BlockStates");
            NBTTagList paletteList = blocksCompound.getList("Palette", 10);
            ListTag palette = (ListTag)Converter.convertTag("", (NBTBase)paletteList);
            long[] blockStates = blocksCompound.getLongArray("BlockStates");
            sections[sectionId] = new CraftSlimeChunkSection(null, null, palette, blockStates, blockLightArray, skyLightArray);
        }
        return sections;
    }

    @Override
    public CompoundTag getHeightMaps() {
        CompoundMap heightMaps = new CompoundMap();
        for (HeightMap.Type type : this.chunk.heightMap.keySet()) {
            heightMaps.put(type.a(), new LongArrayTag(type.a(), this.chunk.b(type).a()));
        }
        return new CompoundTag("", heightMaps);
    }

    @Override
    public int[] getBiomes() {
        BiomeBase[] biomeBases = this.chunk.getBiomeIndex();
        int[] biomes = new int[biomeBases.length];
        for (int i = 0; i < biomeBases.length; ++i) {
            biomes[i] = IRegistry.BIOME.a((Object)biomeBases[i]);
        }
        return biomes;
    }

    @Override
    public List<CompoundTag> getTileEntities() {
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (TileEntity entity : this.chunk.getTileEntities().values()) {
            NBTTagCompound entityNbt = new NBTTagCompound();
            entity.save(entityNbt);
            tileEntities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
        }
        return tileEntities;
    }

    @Override
    public List<CompoundTag> getEntities() {
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (int i = 0; i < this.chunk.getEntitySlices().length; ++i) {
            for (Entity entity : this.chunk.getEntitySlices()[i]) {
                NBTTagCompound entityNbt;
                if (!entity.d(entityNbt = new NBTTagCompound())) continue;
                this.chunk.d(true);
                entities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
            }
        }
        return entities;
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public void setChunk(Chunk chunk) {
        this.chunk = chunk;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NMSSlimeChunk)) {
            return false;
        }
        NMSSlimeChunk other = (NMSSlimeChunk)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Chunk this$chunk = this.getChunk();
        Chunk other$chunk = other.getChunk();
        return !(this$chunk == null ? other$chunk != null : !this$chunk.equals(other$chunk));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NMSSlimeChunk;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Chunk $chunk = this.getChunk();
        result = result * 59 + ($chunk == null ? 43 : $chunk.hashCode());
        return result;
    }

    public String toString() {
        return "NMSSlimeChunk(chunk=" + this.getChunk() + ")";
    }

    public NMSSlimeChunk(Chunk chunk) {
        this.chunk = chunk;
    }
}

