/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_14_R1;

import com.grinderwolf.swm.clsm.CLSMBridge;
import com.grinderwolf.swm.clsm.ClassModifier;
import com.grinderwolf.swm.nms.v1_14_R1.CustomWorldServer;
import com.grinderwolf.swm.nms.v1_14_R1.v1_14_R1SlimeNMS;
import net.minecraft.server.v1_14_R1.Chunk;
import net.minecraft.server.v1_14_R1.IChunkAccess;
import net.minecraft.server.v1_14_R1.ProtoChunkExtension;
import net.minecraft.server.v1_14_R1.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CraftCLSMBridge
implements CLSMBridge {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Chunk Loader");
    private final v1_14_R1SlimeNMS nmsInstance;

    public Object getChunk(Object worldObject, int x, int z) {
        if (!(worldObject instanceof CustomWorldServer)) {
            return null;
        }
        CustomWorldServer world = (CustomWorldServer)((Object)worldObject);
        return world.getChunk(x, z);
    }

    public boolean saveChunk(Object world, Object chunkAccess) {
        if (!(world instanceof CustomWorldServer)) {
            return false;
        }
        if (!(chunkAccess instanceof ProtoChunkExtension) && !(chunkAccess instanceof Chunk) || !((IChunkAccess)chunkAccess).isNeedsSaving()) {
            return true;
        }
        Chunk chunk = chunkAccess instanceof ProtoChunkExtension ? ((ProtoChunkExtension)chunkAccess).u() : (Chunk)chunkAccess;
        ((CustomWorldServer)((Object)world)).saveChunk(chunk);
        chunk.setNeedsSaving(false);
        return true;
    }

    public Object[] getDefaultWorlds() {
        CustomWorldServer defaultWorld = this.nmsInstance.getDefaultWorld();
        CustomWorldServer netherWorld = this.nmsInstance.getDefaultNetherWorld();
        CustomWorldServer endWorld = this.nmsInstance.getDefaultEndWorld();
        if (defaultWorld != null || netherWorld != null || endWorld != null) {
            return new WorldServer[]{defaultWorld, netherWorld, endWorld};
        }
        return null;
    }

    public boolean isCustomWorld(Object world) {
        return world instanceof CustomWorldServer;
    }

    public boolean skipWorldAdd(Object world) {
        if (!this.isCustomWorld(world) || this.nmsInstance.isLoadingDefaultWorlds()) {
            return false;
        }
        CustomWorldServer worldServer = (CustomWorldServer)((Object)world);
        return !worldServer.isReady();
    }

    static void initialize(v1_14_R1SlimeNMS instance) {
        ClassModifier.setLoader((CLSMBridge)new CraftCLSMBridge(instance));
    }

    private CraftCLSMBridge(v1_14_R1SlimeNMS nmsInstance) {
        this.nmsInstance = nmsInstance;
    }
}

