/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_13_R2;

import com.grinderwolf.swm.api.world.SlimeWorld;
import com.grinderwolf.swm.api.world.properties.SlimeProperties;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.nms.CraftSlimeWorld;
import com.grinderwolf.swm.nms.SlimeNMS;
import com.grinderwolf.swm.nms.v1_13_R2.Converter;
import com.grinderwolf.swm.nms.v1_13_R2.CraftCLSMBridge;
import com.grinderwolf.swm.nms.v1_13_R2.CustomDataManager;
import com.grinderwolf.swm.nms.v1_13_R2.CustomWorldServer;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixTypes;
import com.mojang.datafixers.DataFixer;
import net.minecraft.server.v1_13_R2.DataConverterRegistry;
import net.minecraft.server.v1_13_R2.DimensionManager;
import net.minecraft.server.v1_13_R2.GameProfileSerializer;
import net.minecraft.server.v1_13_R2.IDataManager;
import net.minecraft.server.v1_13_R2.MinecraftServer;
import net.minecraft.server.v1_13_R2.NBTBase;
import net.minecraft.server.v1_13_R2.NBTTagCompound;
import net.minecraft.server.v1_13_R2.WorldServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_13_R2.CraftWorld;
import org.bukkit.event.Event;
import org.bukkit.event.world.WorldInitEvent;
import org.bukkit.event.world.WorldLoadEvent;

public class v1_13_R2SlimeNMS
implements SlimeNMS {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM");
    public static final boolean IS_PAPER;
    private final byte worldVersion = (byte)4;
    private boolean loadingDefaultWorlds = true;
    private WorldServer defaultWorld;
    private WorldServer defaultNetherWorld;
    private WorldServer defaultEndWorld;

    public v1_13_R2SlimeNMS() {
        try {
            CraftCLSMBridge.initialize(this);
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.error("Failed to find ClassModifier classes. Are you sure you installed it correctly?");
            System.exit(1);
        }
    }

    @Override
    public void setDefaultWorlds(SlimeWorld normalWorld, SlimeWorld netherWorld, SlimeWorld endWorld) {
        World.Environment env;
        if (normalWorld != null) {
            env = World.Environment.valueOf((String)normalWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            if (env != World.Environment.NORMAL) {
                LOGGER.warn("The environment for the default world must always be 'NORMAL'.");
            }
            this.defaultWorld = new CustomWorldServer((CraftSlimeWorld)normalWorld, (IDataManager)new CustomDataManager(normalWorld), DimensionManager.OVERWORLD, World.Environment.NORMAL);
        }
        if (netherWorld != null) {
            env = World.Environment.valueOf((String)netherWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            this.defaultNetherWorld = new CustomWorldServer((CraftSlimeWorld)netherWorld, (IDataManager)new CustomDataManager(netherWorld), DimensionManager.a((int)env.getId()), env);
        }
        if (endWorld != null) {
            env = World.Environment.valueOf((String)endWorld.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
            this.defaultEndWorld = new CustomWorldServer((CraftSlimeWorld)endWorld, (IDataManager)new CustomDataManager(endWorld), DimensionManager.a((int)env.getId()), env);
        }
        this.loadingDefaultWorlds = false;
    }

    @Override
    public Object createNMSWorld(SlimeWorld world) {
        CustomDataManager dataManager = new CustomDataManager(world);
        MinecraftServer mcServer = MinecraftServer.getServer();
        int dimension = 10 + mcServer.worldServer.size();
        for (WorldServer server : mcServer.getWorlds()) {
            if (server.dimension.getDimensionID() + 1 != dimension) continue;
            ++dimension;
        }
        String worldName = world.getName();
        World.Environment env = World.Environment.valueOf((String)world.getPropertyMap().getString(SlimeProperties.ENVIRONMENT).toUpperCase());
        DimensionManager dimensionManager = new DimensionManager(dimension, worldName, worldName, () -> DimensionManager.a((int)env.getId()).e());
        return new CustomWorldServer((CraftSlimeWorld)world, (IDataManager)dataManager, dimensionManager, env);
    }

    @Override
    public void generateWorld(SlimeWorld world) {
        this.addWorldToServerList(this.createNMSWorld(world));
    }

    @Override
    public void addWorldToServerList(Object worldObject) {
        if (!(worldObject instanceof WorldServer)) {
            throw new IllegalArgumentException("World object must be an instance of WorldServer!");
        }
        CustomWorldServer server = (CustomWorldServer)((Object)worldObject);
        String worldName = server.getWorldData().getName();
        if (Bukkit.getWorld((String)worldName) != null) {
            throw new IllegalArgumentException("World " + worldName + " already exists! Maybe it's an outdated SlimeWorld object?");
        }
        LOGGER.info("Loading world " + worldName);
        long startTime = System.currentTimeMillis();
        server.setReady(true);
        MinecraftServer mcServer = MinecraftServer.getServer();
        mcServer.server.addWorld((World)server.getWorld());
        MinecraftServer.getServer().worldServer.put(server.dimension, server);
        Bukkit.getPluginManager().callEvent((Event)new WorldInitEvent((World)server.getWorld()));
        Bukkit.getPluginManager().callEvent((Event)new WorldLoadEvent((World)server.getWorld()));
        LOGGER.info("World " + worldName + " loaded in " + (System.currentTimeMillis() - startTime) + "ms.");
    }

    @Override
    public SlimeWorld getSlimeWorld(World world) {
        CraftWorld craftWorld = (CraftWorld)world;
        if (!(craftWorld.getHandle() instanceof CustomWorldServer)) {
            return null;
        }
        CustomWorldServer worldServer = (CustomWorldServer)craftWorld.getHandle();
        return worldServer.getSlimeWorld();
    }

    @Override
    public CompoundTag convertChunk(CompoundTag tag) {
        NBTTagCompound nmsTag = (NBTTagCompound)Converter.convertTag(tag);
        int version = nmsTag.getInt("DataVersion");
        NBTTagCompound newNmsTag = GameProfileSerializer.a((DataFixer)DataConverterRegistry.a(), (DSL.TypeReference)DataFixTypes.CHUNK, (NBTTagCompound)nmsTag, (int)version);
        return (CompoundTag)Converter.convertTag("", (NBTBase)newNmsTag);
    }

    @Override
    public byte getWorldVersion() {
        return this.worldVersion;
    }

    public boolean isLoadingDefaultWorlds() {
        return this.loadingDefaultWorlds;
    }

    public WorldServer getDefaultWorld() {
        return this.defaultWorld;
    }

    public WorldServer getDefaultNetherWorld() {
        return this.defaultNetherWorld;
    }

    public WorldServer getDefaultEndWorld() {
        return this.defaultEndWorld;
    }

    static {
        boolean paper = true;
        try {
            Class.forName("com.destroystokyo.paper.PaperWorldConfig");
        }
        catch (ClassNotFoundException e) {
            paper = false;
        }
        IS_PAPER = paper;
    }
}

