/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.nms.v1_13_R1;

import com.grinderwolf.swm.api.utils.NibbleArray;
import com.grinderwolf.swm.api.world.SlimeChunk;
import com.grinderwolf.swm.api.world.SlimeChunkSection;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ByteTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundMap;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.CompoundTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.DoubleTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.FloatTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.IntTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ListTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongArrayTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.LongTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.ShortTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.StringTag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.Tag;
import com.grinderwolf.swm.internal.com.flowpowered.nbt.TagType;
import com.grinderwolf.swm.nms.CraftSlimeChunk;
import com.grinderwolf.swm.nms.CraftSlimeChunkSection;
import java.util.ArrayList;
import net.minecraft.server.v1_13_R1.BiomeBase;
import net.minecraft.server.v1_13_R1.Chunk;
import net.minecraft.server.v1_13_R1.ChunkSection;
import net.minecraft.server.v1_13_R1.DataPaletteBlock;
import net.minecraft.server.v1_13_R1.Entity;
import net.minecraft.server.v1_13_R1.HeightMap;
import net.minecraft.server.v1_13_R1.NBTBase;
import net.minecraft.server.v1_13_R1.NBTTagByte;
import net.minecraft.server.v1_13_R1.NBTTagByteArray;
import net.minecraft.server.v1_13_R1.NBTTagCompound;
import net.minecraft.server.v1_13_R1.NBTTagDouble;
import net.minecraft.server.v1_13_R1.NBTTagFloat;
import net.minecraft.server.v1_13_R1.NBTTagInt;
import net.minecraft.server.v1_13_R1.NBTTagIntArray;
import net.minecraft.server.v1_13_R1.NBTTagList;
import net.minecraft.server.v1_13_R1.NBTTagLong;
import net.minecraft.server.v1_13_R1.NBTTagLongArray;
import net.minecraft.server.v1_13_R1.NBTTagShort;
import net.minecraft.server.v1_13_R1.NBTTagString;
import net.minecraft.server.v1_13_R1.TileEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Converter {
    private static final Logger LOGGER = LogManager.getLogger((String)"SWM Converter");

    static net.minecraft.server.v1_13_R1.NibbleArray convertArray(NibbleArray array) {
        return new net.minecraft.server.v1_13_R1.NibbleArray(array.getBacking());
    }

    static NibbleArray convertArray(net.minecraft.server.v1_13_R1.NibbleArray array) {
        return new NibbleArray(array.asBytes());
    }

    static NBTBase convertTag(Tag tag) {
        try {
            switch (tag.getType()) {
                case TAG_BYTE: {
                    return new NBTTagByte(((ByteTag)tag).getValue().byteValue());
                }
                case TAG_SHORT: {
                    return new NBTTagShort(((ShortTag)tag).getValue().shortValue());
                }
                case TAG_INT: {
                    return new NBTTagInt(((IntTag)tag).getValue().intValue());
                }
                case TAG_LONG: {
                    return new NBTTagLong(((LongTag)tag).getValue().longValue());
                }
                case TAG_FLOAT: {
                    return new NBTTagFloat(((FloatTag)tag).getValue().floatValue());
                }
                case TAG_DOUBLE: {
                    return new NBTTagDouble(((DoubleTag)tag).getValue().doubleValue());
                }
                case TAG_BYTE_ARRAY: {
                    return new NBTTagByteArray(((ByteArrayTag)tag).getValue());
                }
                case TAG_STRING: {
                    return new NBTTagString(((StringTag)tag).getValue());
                }
                case TAG_LIST: {
                    NBTTagList list = new NBTTagList();
                    ((ListTag)tag).getValue().stream().map(Converter::convertTag).forEach(arg_0 -> ((NBTTagList)list).add(arg_0));
                    return list;
                }
                case TAG_COMPOUND: {
                    NBTTagCompound compound = new NBTTagCompound();
                    ((CompoundTag)tag).getValue().forEach((key, value) -> compound.set(key, Converter.convertTag(value)));
                    return compound;
                }
                case TAG_INT_ARRAY: {
                    return new NBTTagIntArray(((IntArrayTag)tag).getValue());
                }
                case TAG_LONG_ARRAY: {
                    return new NBTTagLongArray(((LongArrayTag)tag).getValue());
                }
            }
            throw new IllegalArgumentException("Invalid tag type " + tag.getType().name());
        }
        catch (Exception ex) {
            LOGGER.error("Failed to convert NBT object:");
            LOGGER.error(tag.toString());
            throw ex;
        }
    }

    static Tag convertTag(String name, NBTBase base) {
        switch (base.getTypeId()) {
            case 1: {
                return new ByteTag(name, ((NBTTagByte)base).g());
            }
            case 2: {
                return new ShortTag(name, ((NBTTagShort)base).f());
            }
            case 3: {
                return new IntTag(name, ((NBTTagInt)base).e());
            }
            case 4: {
                return new LongTag(name, ((NBTTagLong)base).d());
            }
            case 5: {
                return new FloatTag(name, ((NBTTagFloat)base).i());
            }
            case 6: {
                return new DoubleTag(name, ((NBTTagDouble)base).asDouble());
            }
            case 7: {
                return new ByteArrayTag(name, ((NBTTagByteArray)base).c());
            }
            case 8: {
                return new StringTag(name, ((NBTTagString)base).b_());
            }
            case 9: {
                ArrayList<Tag> list = new ArrayList<Tag>();
                NBTTagList originalList = (NBTTagList)base;
                for (NBTBase entry : originalList) {
                    list.add(Converter.convertTag("", entry));
                }
                return new ListTag(name, TagType.getById(originalList.d()), list);
            }
            case 10: {
                NBTTagCompound originalCompound = (NBTTagCompound)base;
                CompoundTag compound = new CompoundTag(name, new CompoundMap());
                for (String key : originalCompound.getKeys()) {
                    compound.getValue().put(key, Converter.convertTag(key, originalCompound.get(key)));
                }
                return compound;
            }
            case 11: {
                return new IntArrayTag("", ((NBTTagIntArray)base).d());
            }
            case 12: {
                return new LongArrayTag("", ((NBTTagLongArray)base).d());
            }
        }
        throw new IllegalArgumentException("Invalid tag type " + base.getTypeId());
    }

    static SlimeChunk convertChunk(Chunk chunk) {
        SlimeChunkSection[] sections = new SlimeChunkSection[16];
        for (int sectionId = 0; sectionId < chunk.getSections().length; ++sectionId) {
            ChunkSection section = chunk.getSections()[sectionId];
            if (section == null) continue;
            section.recalcBlockCounts();
            if (section.a()) continue;
            NibbleArray blockLightArray = Converter.convertArray(section.getEmittedLightArray());
            NibbleArray skyLightArray = Converter.convertArray(section.getSkyLightArray());
            DataPaletteBlock dataPaletteBlock = section.getBlocks();
            NBTTagCompound blocksCompound = new NBTTagCompound();
            dataPaletteBlock.b(blocksCompound, "Palette", "BlockStates");
            NBTTagList paletteList = blocksCompound.getList("Palette", 10);
            ListTag palette = (ListTag)Converter.convertTag("", (NBTBase)paletteList);
            long[] blockStates = blocksCompound.o("BlockStates");
            sections[sectionId] = new CraftSlimeChunkSection(null, null, palette, blockStates, blockLightArray, skyLightArray);
        }
        ArrayList<CompoundTag> tileEntities = new ArrayList<CompoundTag>();
        for (TileEntity entity : chunk.getTileEntities().values()) {
            NBTTagCompound entityNbt = new NBTTagCompound();
            entity.save(entityNbt);
            tileEntities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
        }
        ArrayList<CompoundTag> entities = new ArrayList<CompoundTag>();
        for (int i = 0; i < chunk.getEntitySlices().length; ++i) {
            for (Entity entity : chunk.getEntitySlices()[i]) {
                Object entityNbt;
                if (!entity.d((NBTTagCompound)(entityNbt = new NBTTagCompound()))) continue;
                chunk.f(true);
                entities.add((CompoundTag)Converter.convertTag("", (NBTBase)entityNbt));
            }
        }
        BiomeBase[] biomeBases = chunk.getBiomeIndex();
        int[] biomes = new int[biomeBases.length];
        for (int i = 0; i < biomeBases.length; ++i) {
            biomes[i] = BiomeBase.REGISTRY_ID.a((Object)biomeBases[i]);
        }
        CompoundMap heightMaps = new CompoundMap();
        for (HeightMap.Type type : chunk.heightMap.keySet()) {
            heightMaps.put(type.b(), new LongArrayTag(type.b(), chunk.b(type).b()));
        }
        CompoundTag heightMapCompound = new CompoundTag("", heightMaps);
        return new CraftSlimeChunk(chunk.world.worldData.getName(), chunk.locX, chunk.locZ, sections, heightMapCompound, biomes, tileEntities, entities);
    }
}

