/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.org.bson.codecs;

import com.grinderwolf.swm.internal.org.bson.BsonInvalidOperationException;
import com.grinderwolf.swm.internal.org.bson.BsonReader;
import com.grinderwolf.swm.internal.org.bson.BsonWriter;
import com.grinderwolf.swm.internal.org.bson.codecs.Codec;
import com.grinderwolf.swm.internal.org.bson.codecs.DecoderContext;
import com.grinderwolf.swm.internal.org.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.org.bson.codecs.NumberCodecHelper;

public class ByteCodec
implements Codec<Byte> {
    @Override
    public void encode(BsonWriter writer, Byte value, EncoderContext encoderContext) {
        writer.writeInt32(value.byteValue());
    }

    @Override
    public Byte decode(BsonReader reader, DecoderContext decoderContext) {
        int value = NumberCodecHelper.decodeInt(reader);
        if (value < -128 || value > 127) {
            throw new BsonInvalidOperationException(String.format("%s can not be converted into a Byte.", value));
        }
        return (byte)value;
    }

    @Override
    public Class<Byte> getEncoderClass() {
        return Byte.class;
    }
}

