/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.ninja.leaping.configurate.loader;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.concurrent.Callable;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class AtomicFiles {
    private AtomicFiles() {
    }

    public static @NonNull Callable<BufferedWriter> createAtomicWriterFactory(@NonNull Path path, @NonNull Charset charset) {
        Preconditions.checkNotNull(path, "path");
        return () -> AtomicFiles.createAtomicBufferedWriter(path, charset);
    }

    public static @NonNull BufferedWriter createAtomicBufferedWriter(@NonNull Path path, @NonNull Charset charset) throws IOException {
        path = path.toAbsolutePath();
        Path writePath = AtomicFiles.getTemporaryPath(path.getParent(), path.getFileName().toString());
        if (Files.exists(path, new LinkOption[0])) {
            Files.copy(path, writePath, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
        }
        BufferedWriter output = Files.newBufferedWriter(writePath, charset, new OpenOption[0]);
        return new BufferedWriter(new AtomicFileWriter(writePath, path, output));
    }

    private static @NonNull Path getTemporaryPath(@NonNull Path parent, @NonNull String key) {
        String fileName = System.nanoTime() + Preconditions.checkNotNull(key, "key").replaceAll("\\\\|/|:", "-") + ".tmp";
        return parent.resolve(fileName);
    }

    private static class AtomicFileWriter
    extends FilterWriter {
        private final Path targetPath;
        private final Path writePath;

        protected AtomicFileWriter(Path writePath, Path targetPath, Writer wrapping) {
            super(wrapping);
            this.writePath = writePath;
            this.targetPath = targetPath;
        }

        @Override
        public void close() throws IOException {
            super.close();
            Files.move(this.writePath, this.targetPath, StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
        }
    }
}

