/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb.util;

import com.grinderwolf.swm.internal.com.mongodb.BasicDBList;
import com.grinderwolf.swm.internal.com.mongodb.BasicDBObject;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.DBRef;
import com.grinderwolf.swm.internal.org.bson.BSON;
import com.grinderwolf.swm.internal.org.bson.BSONObject;
import com.grinderwolf.swm.internal.org.bson.BasicBSONCallback;
import com.grinderwolf.swm.internal.org.bson.BsonUndefined;
import com.grinderwolf.swm.internal.org.bson.internal.Base64;
import com.grinderwolf.swm.internal.org.bson.types.BSONTimestamp;
import com.grinderwolf.swm.internal.org.bson.types.Binary;
import com.grinderwolf.swm.internal.org.bson.types.Code;
import com.grinderwolf.swm.internal.org.bson.types.CodeWScope;
import com.grinderwolf.swm.internal.org.bson.types.Decimal128;
import com.grinderwolf.swm.internal.org.bson.types.MaxKey;
import com.grinderwolf.swm.internal.org.bson.types.MinKey;
import com.grinderwolf.swm.internal.org.bson.types.ObjectId;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.SimpleTimeZone;
import java.util.UUID;
import java.util.regex.Pattern;

@Deprecated
public class JSONCallback
extends BasicBSONCallback {
    private boolean _lastArray = false;
    public static final String _msDateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String _secDateFormat = "yyyy-MM-dd'T'HH:mm:ss'Z'";

    @Override
    public BSONObject create() {
        return new BasicDBObject();
    }

    @Override
    protected BSONObject createList() {
        return new BasicDBList();
    }

    @Override
    public void arrayStart(String name) {
        this._lastArray = true;
        super.arrayStart(name);
    }

    @Override
    public void objectStart(String name) {
        this._lastArray = false;
        super.objectStart(name);
    }

    @Override
    public Object objectDone() {
        String name = this.curName();
        Object o = super.objectDone();
        if (this._lastArray) {
            return o;
        }
        BSONObject b2 = (BSONObject)o;
        if (b2.containsField("$oid")) {
            o = new ObjectId((String)b2.get("$oid"));
        } else if (b2.containsField("$date")) {
            if (b2.get("$date") instanceof Number) {
                o = new Date(((Number)b2.get("$date")).longValue());
            } else {
                SimpleDateFormat format = new SimpleDateFormat(_msDateFormat);
                format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                o = format.parse(b2.get("$date").toString(), new ParsePosition(0));
                if (o == null) {
                    format = new SimpleDateFormat(_secDateFormat);
                    format.setCalendar(new GregorianCalendar(new SimpleTimeZone(0, "GMT")));
                    o = format.parse(b2.get("$date").toString(), new ParsePosition(0));
                }
            }
        } else if (b2.containsField("$regex")) {
            o = Pattern.compile((String)b2.get("$regex"), BSON.regexFlags((String)b2.get("$options")));
        } else if (b2.containsField("$ts")) {
            Integer ts = ((Number)b2.get("$ts")).intValue();
            Integer inc = ((Number)b2.get("$inc")).intValue();
            o = new BSONTimestamp(ts, inc);
        } else if (b2.containsField("$timestamp")) {
            BSONObject tsObject = (BSONObject)b2.get("$timestamp");
            Integer ts = ((Number)tsObject.get("t")).intValue();
            Integer inc = ((Number)tsObject.get("i")).intValue();
            o = new BSONTimestamp(ts, inc);
        } else if (b2.containsField("$code")) {
            o = b2.containsField("$scope") ? new CodeWScope((String)b2.get("$code"), (DBObject)b2.get("$scope")) : new Code((String)b2.get("$code"));
        } else if (b2.containsField("$ref")) {
            o = new DBRef((String)b2.get("$ref"), b2.get("$id"));
        } else if (b2.containsField("$minKey")) {
            o = new MinKey();
        } else if (b2.containsField("$maxKey")) {
            o = new MaxKey();
        } else if (b2.containsField("$uuid")) {
            o = UUID.fromString((String)b2.get("$uuid"));
        } else if (b2.containsField("$binary")) {
            int type = b2.get("$type") instanceof String ? Integer.valueOf((String)b2.get("$type"), 16) : (Integer)b2.get("$type");
            byte[] bytes = Base64.decode((String)b2.get("$binary"));
            o = new Binary((byte)type, bytes);
        } else if (b2.containsField("$undefined") && b2.get("$undefined").equals(true)) {
            o = new BsonUndefined();
        } else if (b2.containsField("$numberLong")) {
            o = Long.valueOf((String)b2.get("$numberLong"));
        } else if (b2.containsField("$numberDecimal")) {
            o = Decimal128.parse((String)b2.get("$numberDecimal"));
        }
        if (!this.isStackEmpty()) {
            this._put(name, o);
        } else {
            o = !BSON.hasDecodeHooks() ? o : BSON.applyDecodingHooks(o);
            this.setRoot(o);
        }
        return o;
    }
}

