/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb.internal.event;

import com.grinderwolf.swm.internal.com.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.com.mongodb.diagnostics.logging.Logger;
import com.grinderwolf.swm.internal.com.mongodb.diagnostics.logging.Loggers;
import com.grinderwolf.swm.internal.com.mongodb.event.ServerClosedEvent;
import com.grinderwolf.swm.internal.com.mongodb.event.ServerDescriptionChangedEvent;
import com.grinderwolf.swm.internal.com.mongodb.event.ServerListener;
import com.grinderwolf.swm.internal.com.mongodb.event.ServerOpeningEvent;
import java.util.ArrayList;
import java.util.List;

final class ServerListenerMulticaster
implements ServerListener {
    private static final Logger LOGGER = Loggers.getLogger("cluster.event");
    private final List<ServerListener> serverListeners;

    ServerListenerMulticaster(List<ServerListener> serverListeners) {
        Assertions.isTrue("All ServerListener instances are non-null", !serverListeners.contains(null));
        this.serverListeners = new ArrayList<ServerListener>(serverListeners);
    }

    @Override
    public void serverOpening(ServerOpeningEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverOpening(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverClosed(ServerClosedEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverClosed(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server opening event to listener %s", cur), e);
            }
        }
    }

    @Override
    public void serverDescriptionChanged(ServerDescriptionChangedEvent event) {
        for (ServerListener cur : this.serverListeners) {
            try {
                cur.serverDescriptionChanged(event);
            }
            catch (Exception e) {
                if (!LOGGER.isWarnEnabled()) continue;
                LOGGER.warn(String.format("Exception thrown raising server description changed event to listener %s", cur), e);
            }
        }
    }
}

