/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.internal.com.mongodb;

import com.grinderwolf.swm.internal.com.mongodb.DBEncoder;
import com.grinderwolf.swm.internal.com.mongodb.DBObject;
import com.grinderwolf.swm.internal.com.mongodb.assertions.Assertions;
import com.grinderwolf.swm.internal.org.bson.BsonBinaryReader;
import com.grinderwolf.swm.internal.org.bson.BsonWriter;
import com.grinderwolf.swm.internal.org.bson.ByteBufNIO;
import com.grinderwolf.swm.internal.org.bson.codecs.Encoder;
import com.grinderwolf.swm.internal.org.bson.codecs.EncoderContext;
import com.grinderwolf.swm.internal.org.bson.io.BasicOutputBuffer;
import com.grinderwolf.swm.internal.org.bson.io.ByteBufferBsonInput;
import java.nio.ByteBuffer;

class DBEncoderAdapter
implements Encoder<DBObject> {
    private final DBEncoder encoder;

    DBEncoderAdapter(DBEncoder encoder) {
        this.encoder = Assertions.notNull("encoder", encoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void encode(BsonWriter writer, DBObject document, EncoderContext encoderContext) {
        BasicOutputBuffer buffer = new BasicOutputBuffer();
        try {
            this.encoder.writeObject(buffer, document);
            BsonBinaryReader reader = new BsonBinaryReader(new ByteBufferBsonInput(new ByteBufNIO(ByteBuffer.wrap(buffer.toByteArray()))));
            try {
                writer.pipe(reader);
            }
            finally {
                reader.close();
            }
        }
        finally {
            buffer.close();
        }
    }

    @Override
    public Class<DBObject> getEncoderClass() {
        return DBObject.class;
    }
}

