/*
 * Decompiled with CFR 0.152.
 */
package com.grinderwolf.swm.api.utils;

public class NibbleArray {
    private final int size;
    private final byte[] backing;

    public NibbleArray(int size) {
        this(new byte[size / 2]);
    }

    public NibbleArray(byte[] backing) {
        this.backing = backing;
        this.size = backing.length * 2;
    }

    public int get(int index) {
        byte value = this.backing[index / 2];
        return index % 2 == 0 ? value & 0xF : (value & 0xF0) >> 4;
    }

    public void set(int index, int value) {
        int nibble = value & 0xF;
        int halfIndex = index / 2;
        byte previous = this.backing[halfIndex];
        this.backing[halfIndex] = index % 2 == 0 ? (byte)(previous & 0xF0 | nibble) : (byte)(previous & 0xF | nibble << 4);
    }

    public byte[] getBacking() {
        return this.backing;
    }
}

