/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.eco;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.data.ConfigHandler;
import me.scruffyboy13.Economy.data.YamlData;
import me.scruffyboy13.Economy.eco.Economy;
import me.scruffyboy13.Economy.eco.PlayerBalance;

public class YamlEconomy
implements Economy {
    public YamlEconomy() {
        Path dataDir = Paths.get(String.valueOf(EconomyMain.getPath()) + "/data/", new String[0]);
        if (!Files.exists(dataDir, new LinkOption[0])) {
            try {
                Files.createDirectory(dataDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                EconomyMain.warn("There was an error creating the data directory.");
                return;
            }
        }
    }

    @Override
    public boolean createAccount(UUID uuid) {
        this.set(uuid, ConfigHandler.getStartingBalance());
        return true;
    }

    @Override
    public boolean hasAccount(UUID uuid) {
        for (PlayerBalance pb : this.getPlayers()) {
            if (!pb.getUUID().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(UUID uuid) {
        File islandFile = new File(String.valueOf(EconomyMain.getPath()) + "/data/" + uuid.toString() + ".yml");
        islandFile.delete();
        return true;
    }

    @Override
    public boolean withdraw(UUID uuid, double amount) {
        return this.set(uuid, this.getBalance(uuid).getBalance() - amount);
    }

    @Override
    public boolean deposit(UUID uuid, double amount) {
        return this.set(uuid, this.getBalance(uuid).getBalance() + amount);
    }

    @Override
    public boolean set(UUID uuid, double amount) {
        if (amount < 0.0) {
            return false;
        }
        YamlData data = new YamlData(String.valueOf(uuid.toString()) + ".yml", String.valueOf(EconomyMain.getPath()) + "/data");
        data.getConfig().set("UUID", (Object)uuid.toString());
        data.getConfig().set("Balance", (Object)amount);
        data.saveConfig();
        return true;
    }

    @Override
    public boolean has(UUID uuid, double amount) {
        return this.getBalance(uuid).getBalance() >= amount;
    }

    @Override
    public PlayerBalance getBalance(UUID uuid) {
        try {
            YamlData data = new YamlData(String.valueOf(uuid.toString()) + ".yml", String.valueOf(EconomyMain.getPath()) + "/data");
            double balance = data.getConfig().getDouble("Balance");
            return new PlayerBalance(uuid, balance);
        }
        catch (Exception e) {
            return new PlayerBalance(uuid, 0.0);
        }
    }

    @Override
    public List<PlayerBalance> getPlayers() {
        File[] files;
        ArrayList<PlayerBalance> playerData = new ArrayList<PlayerBalance>();
        File[] fileArray = files = new File(String.valueOf(EconomyMain.getPath()) + "/data").listFiles();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            playerData.add(this.getBalance(UUID.fromString(file.getName().replace(".yml", ""))));
            ++n2;
        }
        return playerData;
    }
}

