/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.eco;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.UUID;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.data.ConfigHandler;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;

public class VaultImpl
implements Economy {
    public boolean isEnabled() {
        return EconomyMain.getInstance() != null;
    }

    public String currencyNamePlural() {
        return ConfigHandler.getCurrencyNamePlural();
    }

    public String currencyNameSingular() {
        return ConfigHandler.getCurrencyNameSingular();
    }

    public String format(double v) {
        BigDecimal bd = new BigDecimal(v).setScale(2, RoundingMode.HALF_EVEN);
        return String.valueOf(bd.doubleValue());
    }

    public int fractionalDigits() {
        return -1;
    }

    public boolean createPlayerAccount(String name) {
        return this.createAccount(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public boolean createPlayerAccount(OfflinePlayer player) {
        return this.createAccount(player.getUniqueId());
    }

    public boolean createPlayerAccount(String name, String world) {
        return this.createAccount(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public boolean createPlayerAccount(OfflinePlayer player, String world) {
        return this.createAccount(player.getUniqueId());
    }

    private boolean createAccount(UUID uuid) {
        return EconomyMain.getEco().createAccount(uuid);
    }

    public EconomyResponse depositPlayer(String name, double amount) {
        return this.deposit(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, double amount) {
        return this.deposit(player.getUniqueId(), amount);
    }

    public EconomyResponse depositPlayer(String name, String world, double amount) {
        return this.deposit(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public EconomyResponse depositPlayer(OfflinePlayer player, String world, double amount) {
        return this.deposit(player.getUniqueId(), amount);
    }

    private EconomyResponse deposit(UUID uuid, double amount) {
        if (!EconomyMain.getEco().deposit(uuid, amount)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Failed to deposit funds.");
        }
        return new EconomyResponse(amount, this.getBalance(uuid), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public double getBalance(String name) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public double getBalance(OfflinePlayer player) {
        return this.getBalance(player.getUniqueId());
    }

    public double getBalance(String name, String world) {
        return this.getBalance(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public double getBalance(OfflinePlayer player, String world) {
        return this.getBalance(player.getUniqueId());
    }

    private double getBalance(UUID uuid) {
        return EconomyMain.getEco().getBalance(uuid).getBalance();
    }

    public String getName() {
        return "Economy";
    }

    public boolean has(String name, double amount) {
        return this.has(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public boolean has(OfflinePlayer player, double amount) {
        return this.has(player.getUniqueId(), amount);
    }

    public boolean has(String name, String world, double amount) {
        return this.has(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public boolean has(OfflinePlayer player, String world, double amount) {
        return this.has(player.getUniqueId(), amount);
    }

    private boolean has(UUID uuid, double amount) {
        return EconomyMain.getEco().has(uuid, amount);
    }

    public boolean hasAccount(String name) {
        return this.hasAccount(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public boolean hasAccount(OfflinePlayer player) {
        return this.hasAccount(player.getUniqueId());
    }

    public boolean hasAccount(String name, String world) {
        return this.hasAccount(Bukkit.getOfflinePlayer((String)name).getUniqueId());
    }

    public boolean hasAccount(OfflinePlayer player, String world) {
        return this.hasAccount(player.getUniqueId());
    }

    private boolean hasAccount(UUID uuid) {
        return EconomyMain.getEco().hasAccount(uuid);
    }

    public EconomyResponse withdrawPlayer(String name, double amount) {
        return this.withdraw(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, double amount) {
        return this.withdraw(player.getUniqueId(), amount);
    }

    public EconomyResponse withdrawPlayer(String name, String world, double amount) {
        return this.withdraw(Bukkit.getOfflinePlayer((String)name).getUniqueId(), amount);
    }

    public EconomyResponse withdrawPlayer(OfflinePlayer player, String world, double amount) {
        return this.withdraw(player.getUniqueId(), amount);
    }

    private EconomyResponse withdraw(UUID uuid, double amount) {
        if (!EconomyMain.getEco().withdraw(uuid, amount)) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Failed to withdraw funds.");
        }
        return new EconomyResponse(amount, this.getBalance(uuid), EconomyResponse.ResponseType.SUCCESS, "");
    }

    public boolean hasBankSupport() {
        return false;
    }

    public List<String> getBanks() {
        return null;
    }

    public EconomyResponse isBankMember(String arg0, String arg1) {
        return null;
    }

    public EconomyResponse isBankMember(String arg0, OfflinePlayer arg1) {
        return null;
    }

    public EconomyResponse isBankOwner(String arg0, String arg1) {
        return null;
    }

    public EconomyResponse isBankOwner(String arg0, OfflinePlayer arg1) {
        return null;
    }

    public EconomyResponse bankBalance(String arg0) {
        return null;
    }

    public EconomyResponse bankDeposit(String arg0, double arg1) {
        return null;
    }

    public EconomyResponse bankHas(String arg0, double arg1) {
        return null;
    }

    public EconomyResponse bankWithdraw(String arg0, double arg1) {
        return null;
    }

    public EconomyResponse createBank(String arg0, String arg1) {
        return null;
    }

    public EconomyResponse createBank(String arg0, OfflinePlayer arg1) {
        return null;
    }

    public EconomyResponse deleteBank(String arg0) {
        return null;
    }
}

