/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.eco;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.data.ConfigHandler;
import me.scruffyboy13.Economy.data.MySQL;
import me.scruffyboy13.Economy.eco.Economy;
import me.scruffyboy13.Economy.eco.PlayerBalance;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class SQLEconomy
implements Economy {
    private MySQL sql = new MySQL(ConfigHandler.getHost(), ConfigHandler.getPort(), ConfigHandler.getDatabase(), ConfigHandler.getUsername(), ConfigHandler.getPassword());

    public SQLEconomy() {
        this.connectToSQL();
        if (this.sql.isConnected()) {
            Statement statement;
            try {
                statement = this.sql.getConnection().createStatement();
                DatabaseMetaData md = this.sql.getConnection().getMetaData();
                statement.execute("CREATE TABLE IF NOT EXISTS Economy (UUID VARCHAR(36) NOT NULL);");
                for (Map.Entry<String, String> column : EconomyMain.getSQLColumns().entrySet()) {
                    if (md.getColumns(null, null, "Economy", column.getKey()).next()) continue;
                    statement.execute("ALTER TABLE Economy ADD " + column.getKey() + " " + column.getValue() + ";");
                }
                statement.close();
            }
            catch (SQLException e) {
                EconomyMain.disable("There was an error with creating the database table.");
                return;
            }
            try {
                statement = this.sql.getConnection().prepareStatement("ALTER TABLE Economy MODIFY COLUMN Balance " + EconomyMain.getSQLColumns().get("Balance"));
                statement.executeUpdate();
                statement.close();
            }
            catch (SQLException e) {
                EconomyMain.disable("There was an error updating the sql balance from 1dp to 2dp.");
                return;
            }
        }
    }

    private void connectToSQL() {
        try {
            this.sql.connect();
            EconomyMain.warn("Successfully connected to mysql database.");
        }
        catch (SQLException e) {
            EconomyMain.warn("There was an error connecting to the database. " + e.getMessage());
            Bukkit.getPluginManager().disablePlugin((Plugin)EconomyMain.getInstance());
            return;
        }
        catch (ClassNotFoundException e) {
            EconomyMain.getInstance().getLogger().warning("The MySQL driver class could not be found.");
            Bukkit.getPluginManager().disablePlugin((Plugin)EconomyMain.getInstance());
            return;
        }
    }

    @Override
    public boolean createAccount(UUID uuid) {
        PlayerBalance playerBalance = new PlayerBalance(uuid, ConfigHandler.getStartingBalance());
        try {
            PreparedStatement statement = this.sql.getConnection().prepareStatement("INSERT INTO Economy (UUID, Balance) VALUES (?, ?);");
            statement.setString(1, playerBalance.getUUID().toString());
            statement.setDouble(2, playerBalance.getBalance());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            EconomyMain.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean hasAccount(UUID uuid) {
        for (PlayerBalance pb : this.getPlayers()) {
            if (!pb.getUUID().equals(uuid)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean delete(UUID uuid) {
        try {
            PreparedStatement statement = this.sql.getConnection().prepareStatement("DELETE FROM Economy WHERE UUID=?");
            statement.setString(1, uuid.toString());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            EconomyMain.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean withdraw(UUID uuid, double amount) {
        return this.set(uuid, this.getBalance(uuid).getBalance() - amount);
    }

    @Override
    public boolean deposit(UUID uuid, double amount) {
        return this.set(uuid, this.getBalance(uuid).getBalance() + amount);
    }

    @Override
    public boolean set(UUID uuid, double amount) {
        if (amount < 0.0) {
            return false;
        }
        try {
            PreparedStatement statement = this.sql.getConnection().prepareStatement("UPDATE Economy SET UUID=?, Balance=? WHERE UUID=?");
            statement.setString(1, uuid.toString());
            statement.setDouble(2, amount);
            statement.setString(3, uuid.toString());
            statement.executeUpdate();
            statement.close();
        }
        catch (SQLException e) {
            EconomyMain.warn(e.getMessage());
            return false;
        }
        return true;
    }

    @Override
    public boolean has(UUID uuid, double amount) {
        return this.getBalance(uuid).getBalance() >= amount;
    }

    @Override
    public PlayerBalance getBalance(UUID uuid) {
        try {
            PreparedStatement statement = this.sql.getConnection().prepareStatement("SELECT * FROM Economy WHERE UUID=?");
            statement.setString(1, uuid.toString());
            ResultSet result = statement.executeQuery();
            result.next();
            double balance = result.getDouble("Balance");
            return new PlayerBalance(uuid, balance);
        }
        catch (SQLException e) {
            return new PlayerBalance(uuid, 0.0);
        }
    }

    @Override
    public List<PlayerBalance> getPlayers() {
        try {
            ArrayList<PlayerBalance> playerData = new ArrayList<PlayerBalance>();
            Statement statement = this.sql.getConnection().createStatement();
            ResultSet result = statement.executeQuery("SELECT * FROM Economy;");
            while (result.next()) {
                UUID uuid = UUID.fromString(result.getString("UUID"));
                double balance = result.getDouble("Balance");
                playerData.add(new PlayerBalance(uuid, balance));
            }
            return playerData;
        }
        catch (SQLException e) {
            EconomyMain.warn(e.getMessage());
            return null;
        }
    }
}

