/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.logging.Level;
import me.scruffyboy13.Economy.EconomyMain;
import org.bukkit.configuration.Configuration;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class YamlData {
    private FileConfiguration dataConfig = null;
    private File configFile = null;
    private String fileName = null;
    private String path = null;

    public YamlData(String fileName, String path) {
        this.fileName = fileName;
        this.path = path;
        this.saveDefaultConfig();
    }

    public void reloadConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.path, this.fileName);
        }
        this.dataConfig = YamlConfiguration.loadConfiguration((File)this.configFile);
        InputStream defaultStream = EconomyMain.getInstance().getResource(this.fileName);
        if (defaultStream != null) {
            YamlConfiguration defaultConfig = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(defaultStream));
            this.dataConfig.setDefaults((Configuration)defaultConfig);
        }
    }

    public FileConfiguration getConfig() {
        if (this.dataConfig == null) {
            this.reloadConfig();
        }
        return this.dataConfig;
    }

    public void saveConfig() {
        if (this.dataConfig == null || this.configFile == null) {
            return;
        }
        try {
            this.getConfig().save(this.configFile);
        }
        catch (IOException e) {
            EconomyMain.getInstance().getLogger().log(Level.SEVERE, "Could not save config to " + this.configFile, e);
        }
    }

    public void saveDefaultConfig() {
        if (this.configFile == null) {
            this.configFile = new File(this.path, this.fileName);
        }
        try {
            this.configFile.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!this.configFile.exists()) {
            EconomyMain.getInstance().saveResource(String.valueOf(this.path) + "/" + this.fileName, false);
        }
    }
}

