/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.commands.money;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.commands.CommandExecutor;
import me.scruffyboy13.Economy.data.ConfigHandler;
import me.scruffyboy13.Economy.utils.StringUtils;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class MoneySetCommand
extends CommandExecutor {
    public MoneySetCommand() {
        this.setName("set");
        this.setPermission("economy.command.set");
        this.setUsage(ConfigHandler.getMessage("money.set.usage"));
        this.setBoth(true);
        this.setLengths(Arrays.asList(3));
    }

    @Override
    public void execute(CommandSender sender, String[] args) {
        ArrayList<OfflinePlayer> others = EconomyMain.getPlayersFromString(sender, args[1]);
        if (others.isEmpty() && !args[1].equals("@a")) {
            StringUtils.sendConfigMessage(sender, "messages.money.set.otherDoesntExist", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)args[1]));
            return;
        }
        double amount = 0.0;
        try {
            amount = EconomyMain.getAmountFromString(args[2]);
        }
        catch (NumberFormatException e) {
            StringUtils.sendConfigMessage(sender, "messages.money.set.invalidAmount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%amount%", (Object)args[2]));
            return;
        }
        if (amount < 0.0) {
            StringUtils.sendConfigMessage(sender, "messages.money.set.invalidAmount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%amount%", (Object)args[2]));
            return;
        }
        int total = 0;
        boolean failed = false;
        for (OfflinePlayer other : others) {
            if (!EconomyMain.getEco().hasAccount(other.getUniqueId())) {
                StringUtils.sendConfigMessage(sender, "messages.money.set.otherNoAccount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)other.getName()));
                failed = true;
                continue;
            }
            EconomyMain.getEco().set(other.getUniqueId(), amount);
            if (!(!(other instanceof Player) || sender instanceof Player && ((Player)sender).equals((Player)other))) {
                StringUtils.sendConfigMessage((Player)other, "messages.money.set.set", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%amount%", (Object)EconomyMain.format(amount)));
            }
            ++total;
        }
        if (others.size() == 1) {
            if (!failed) {
                OfflinePlayer other;
                other = (OfflinePlayer)others.get(0);
                StringUtils.sendConfigMessage(sender, "messages.money.set.setter", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%balance%", (Object)EconomyMain.format(amount), (Object)"%player%", (Object)other.getName()));
            }
        } else {
            StringUtils.sendConfigMessage(sender, "messages.money.set.setterMultiple", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%total%", (Object)String.valueOf(total), (Object)"%balance%", (Object)EconomyMain.format(amount)));
        }
    }

    @Override
    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        return null;
    }
}

