/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.commands.money;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.scruffyboy13.Economy.commands.CommandExecutor;
import me.scruffyboy13.Economy.commands.money.MoneyGiveCommand;
import me.scruffyboy13.Economy.commands.money.MoneyHelpCommand;
import me.scruffyboy13.Economy.commands.money.MoneyReloadCommand;
import me.scruffyboy13.Economy.commands.money.MoneySetCommand;
import me.scruffyboy13.Economy.commands.money.MoneyTakeCommand;
import me.scruffyboy13.Economy.utils.StringUtils;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class MoneyCommandHandler
implements org.bukkit.command.CommandExecutor,
TabCompleter {
    private Map<String, CommandExecutor> commands = new HashMap<String, CommandExecutor>();

    public MoneyCommandHandler() {
        this.commands.put("give", new MoneyGiveCommand());
        this.commands.put("help", new MoneyHelpCommand());
        this.commands.put("reload", new MoneyReloadCommand());
        this.commands.put("set", new MoneySetCommand());
        this.commands.put("take", new MoneyTakeCommand());
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (args.length == 0) {
            CommandExecutor command = this.commands.get("help");
            command.execute(sender, args);
        } else {
            String subcmd = args[0].toLowerCase();
            if (this.commands.containsKey(subcmd) || this.aliasesContains(subcmd)) {
                CommandExecutor command = this.getCommand(subcmd);
                if (!sender.hasPermission(command.getPermission())) {
                    StringUtils.sendConfigMessage(sender, "messages.nopermission");
                    return true;
                }
                if (!command.isBoth()) {
                    if (command.isConsole() && sender instanceof Player) {
                        StringUtils.sendConfigMessage(sender, "messages.consoleOnly");
                        return true;
                    }
                    if (command.isPlayer() && sender instanceof ConsoleCommandSender) {
                        StringUtils.sendConfigMessage(sender, "messages.playerOnly");
                        return true;
                    }
                }
                if (!command.getLengths().isEmpty() && !command.getLengths().contains(args.length)) {
                    StringUtils.sendMessage(sender, command.getUsage());
                    return true;
                }
                command.execute(sender, args);
            } else {
                StringUtils.sendConfigMessage(sender, "messages.money.invalidSubCommand");
                return true;
            }
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String label, String[] args) {
        CommandExecutor command;
        if (args.length == 1) {
            ArrayList<String> results = new ArrayList<String>();
            for (String name : this.commands.keySet()) {
                CommandExecutor command2 = this.commands.get(name);
                if (name.toLowerCase().startsWith(args[0].toLowerCase())) {
                    results.add(name.toLowerCase());
                }
                for (String alias : command2.getAliases()) {
                    if (!alias.toLowerCase().startsWith(args[0].toLowerCase())) continue;
                    results.add(alias.toLowerCase());
                }
            }
            return results;
        }
        if (args.length > 1 && (command = this.getCommand(args[0])) != null) {
            return command.onTabComplete(sender, cmd, label, args);
        }
        return null;
    }

    private boolean aliasesContains(String subcmd) {
        for (CommandExecutor cmd : this.commands.values()) {
            if (!cmd.getAliases().contains(subcmd)) continue;
            return true;
        }
        return false;
    }

    public CommandExecutor getCommand(String subcmd) {
        for (String name : this.commands.keySet()) {
            if (name.toLowerCase().equals(subcmd.toLowerCase())) {
                return this.commands.get(name);
            }
            for (String alias : this.commands.get(name).getAliases()) {
                if (!alias.toLowerCase().equals(subcmd.toLowerCase())) continue;
                return this.commands.get(name);
            }
        }
        return null;
    }

    public Map<String, CommandExecutor> getCommands() {
        return this.commands;
    }

    public void addCommand(String name, CommandExecutor cmd) {
        this.commands.put(name, cmd);
    }
}

