/*
 * Decompiled with CFR 0.152.
 */
package me.scruffyboy13.Economy.commands;

import com.google.common.collect.ImmutableMap;
import me.scruffyboy13.Economy.EconomyMain;
import me.scruffyboy13.Economy.utils.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class BalanceCommand
implements CommandExecutor {
    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (sender.hasPermission("economy.command.balance")) {
            if (args.length == 0) {
                if (!(sender instanceof Player)) {
                    StringUtils.sendConfigMessage(sender, "messages.playersOnly");
                    return true;
                }
                Player player = (Player)sender;
                if (!EconomyMain.getEco().hasAccount(player.getUniqueId())) {
                    StringUtils.sendConfigMessage(player, "messages.balance.noAccount");
                    return true;
                }
                Double balance = EconomyMain.getEco().getBalance(player.getUniqueId()).getBalance();
                StringUtils.sendConfigMessage(player, "messages.balance.balance", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%balance%", (Object)String.valueOf(EconomyMain.format(balance))));
                return true;
            }
            if (args.length == 1) {
                OfflinePlayer other = Bukkit.getOfflinePlayer((String)args[0]);
                if (!EconomyMain.getEco().hasAccount(other.getUniqueId())) {
                    StringUtils.sendConfigMessage(sender, "messages.balance.otherNoAccount", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)other.getName()));
                    return true;
                }
                Double balance = EconomyMain.getEco().getBalance(other.getUniqueId()).getBalance();
                StringUtils.sendConfigMessage(sender, "messages.balance.otherBalance", (ImmutableMap<String, String>)ImmutableMap.of((Object)"%player%", (Object)other.getName(), (Object)"%balance%", (Object)String.valueOf(EconomyMain.format(balance))));
                return true;
            }
            StringUtils.sendConfigMessage(sender, "messages.balance.usage");
            return true;
        }
        StringUtils.sendConfigMessage(sender, "messages.nopermission");
        return true;
    }
}

