/*
 * Decompiled with CFR 0.152.
 */
package net.luckperms.api.node;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import net.luckperms.api.node.Node;
import net.luckperms.api.node.SimpleNodeType;
import net.luckperms.api.node.types.ChatMetaNode;
import net.luckperms.api.node.types.DisplayNameNode;
import net.luckperms.api.node.types.InheritanceNode;
import net.luckperms.api.node.types.MetaNode;
import net.luckperms.api.node.types.PermissionNode;
import net.luckperms.api.node.types.PrefixNode;
import net.luckperms.api.node.types.RegexPermissionNode;
import net.luckperms.api.node.types.SuffixNode;
import net.luckperms.api.node.types.WeightNode;
import org.checkerframework.checker.nullness.qual.NonNull;

public interface NodeType<T extends Node> {
    public static final NodeType<PermissionNode> PERMISSION = new SimpleNodeType<PermissionNode>("PERMISSION", n -> n instanceof PermissionNode, n -> (PermissionNode)n);
    public static final NodeType<RegexPermissionNode> REGEX_PERMISSION = new SimpleNodeType<RegexPermissionNode>("REGEX_PERMISSION", n -> n instanceof RegexPermissionNode, n -> (RegexPermissionNode)n);
    public static final NodeType<InheritanceNode> INHERITANCE = new SimpleNodeType<InheritanceNode>("INHERITANCE", n -> n instanceof InheritanceNode, n -> (InheritanceNode)n);
    public static final NodeType<PrefixNode> PREFIX = new SimpleNodeType<PrefixNode>("PREFIX", n -> n instanceof PrefixNode, n -> (PrefixNode)n);
    public static final NodeType<SuffixNode> SUFFIX = new SimpleNodeType<SuffixNode>("SUFFIX", n -> n instanceof SuffixNode, n -> (SuffixNode)n);
    public static final NodeType<MetaNode> META = new SimpleNodeType<MetaNode>("META", n -> n instanceof MetaNode, n -> (MetaNode)n);
    public static final NodeType<WeightNode> WEIGHT = new SimpleNodeType<WeightNode>("WEIGHT", n -> n instanceof WeightNode, n -> (WeightNode)n);
    public static final NodeType<DisplayNameNode> DISPLAY_NAME = new SimpleNodeType<DisplayNameNode>("DISPLAY_NAME", n -> n instanceof DisplayNameNode, n -> (DisplayNameNode)n);
    public static final NodeType<ChatMetaNode<?, ?>> CHAT_META = new SimpleNodeType<ChatMetaNode>("CHAT_META", n -> n instanceof ChatMetaNode, n -> (ChatMetaNode)n);
    public static final NodeType<Node> META_OR_CHAT_META = new SimpleNodeType<Node>("META_OR_CHAT_META", n -> META.matches((Node)n) || CHAT_META.matches((Node)n), Function.identity());

    public @NonNull String name();

    public boolean matches(@NonNull Node var1);

    public @NonNull T cast(@NonNull Node var1);

    default public @NonNull Optional<T> tryCast(@NonNull Node node) {
        Objects.requireNonNull(node, "node");
        if (!this.matches(node)) {
            return Optional.empty();
        }
        return Optional.of(this.cast(node));
    }

    default public @NonNull Predicate<Node> predicate() {
        return this::matches;
    }

    default public @NonNull Predicate<Node> predicate(@NonNull Predicate<? super T> and) {
        return node -> this.matches((Node)node) && and.test((T)this.cast((Node)node));
    }
}

