/*
 * Decompiled with CFR 0.152.
 */
package de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.chunks;

import com.viaversion.viaversion.api.minecraft.chunks.ChunkSection;
import com.viaversion.viaversion.api.minecraft.chunks.DataPalette;
import com.viaversion.viaversion.api.minecraft.chunks.PaletteType;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.CustomByteType;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import de.gerrygames.viarewind.protocol.protocol1_7_6_10to1_8.items.ReplacementRegistry1_7_6_10to1_8;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.util.zip.DeflaterOutputStream;

public class ChunkPacketTransformer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] transformChunkData(byte[] data, int primaryBitMask, boolean skyLight, boolean groundUp) throws Exception {
        ByteBuf inputData = Unpooled.wrappedBuffer((byte[])data);
        ByteBuf finalBuf = ByteBufAllocator.DEFAULT.buffer();
        try {
            int j;
            DataPalette palette;
            ChunkSection section;
            int i;
            ChunkSection[] sections = new ChunkSection[16];
            for (i = 0; i < 16; ++i) {
                if ((primaryBitMask & 1 << i) == 0) continue;
                sections[i] = (ChunkSection)Types1_8.CHUNK_SECTION.read(inputData);
            }
            for (i = 0; i < 16; ++i) {
                if ((primaryBitMask & 1 << i) == 0) continue;
                section = sections[i];
                palette = section.palette(PaletteType.BLOCKS);
                for (int k = 0; k < palette.size(); ++k) {
                    int blockData = palette.idByIndex(k);
                    blockData = ReplacementRegistry1_7_6_10to1_8.replace(blockData);
                    palette.setIdByIndex(k, blockData);
                }
            }
            for (i = 0; i < 16; ++i) {
                if ((primaryBitMask & 1 << i) == 0) continue;
                section = sections[i];
                palette = section.palette(PaletteType.BLOCKS);
                for (j = 0; j < 4096; ++j) {
                    int raw = palette.idAt(j);
                    finalBuf.writeByte(raw >> 4);
                }
            }
            for (i = 0; i < 16; ++i) {
                if ((primaryBitMask & 1 << i) == 0) continue;
                section = sections[i];
                palette = section.palette(PaletteType.BLOCKS);
                for (j = 0; j < 4096; j += 2) {
                    int meta0 = palette.idAt(j) & 0xF;
                    int meta1 = palette.idAt(j + 1) & 0xF;
                    finalBuf.writeByte(meta1 << 4 | meta0);
                }
            }
            int columnCount = Integer.bitCount(primaryBitMask);
            finalBuf.writeBytes(inputData, 2048 * columnCount);
            if (skyLight) {
                finalBuf.writeBytes(inputData, 2048 * columnCount);
            }
            if (groundUp && inputData.isReadable(256)) {
                finalBuf.writeBytes(inputData, 256);
            }
            byte[] byArray = (byte[])Type.REMAINING_BYTES.read(finalBuf);
            return byArray;
        }
        finally {
            finalBuf.release();
        }
    }

    private static int calcSize(int i, boolean hasSkyLight, boolean hasBiome) {
        int blocks = i * 2 * 16 * 16 * 16;
        int blockLight = i * 16 * 16 * 16 / 2;
        int skyLight = hasSkyLight ? i * 16 * 16 * 16 / 2 : 0;
        int biome = hasBiome ? 256 : 0;
        return blocks + blockLight + skyLight + biome;
    }

    public static void transformChunkBulk(PacketWrapper packetWrapper) throws Exception {
        int i;
        int i2;
        boolean skyLightSent = (Boolean)packetWrapper.read((Type)Type.BOOLEAN);
        int columnCount = (Integer)packetWrapper.read((Type)Type.VAR_INT);
        int[] chunkX = new int[columnCount];
        int[] chunkZ = new int[columnCount];
        int[] primaryBitMask = new int[columnCount];
        byte[][] data = new byte[columnCount][];
        for (i2 = 0; i2 < columnCount; ++i2) {
            chunkX[i2] = (Integer)packetWrapper.read((Type)Type.INT);
            chunkZ[i2] = (Integer)packetWrapper.read((Type)Type.INT);
            primaryBitMask[i2] = (Integer)packetWrapper.read((Type)Type.UNSIGNED_SHORT);
        }
        for (i2 = 0; i2 < columnCount; ++i2) {
            int size = ChunkPacketTransformer.calcSize(Integer.bitCount(primaryBitMask[i2]), skyLightSent, true);
            CustomByteType customByteType = new CustomByteType(Integer.valueOf(size));
            data[i2] = ChunkPacketTransformer.transformChunkData((byte[])packetWrapper.read((Type)customByteType), primaryBitMask[i2], skyLightSent, true);
        }
        ByteArrayOutputStream compressedData = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream(compressedData);){
            for (i = 0; i < columnCount; ++i) {
                deflaterStream.write(data[i]);
            }
        }
        packetWrapper.write((Type)Type.SHORT, (Object)((short)columnCount));
        packetWrapper.write((Type)Type.INT, (Object)compressedData.size());
        packetWrapper.write((Type)Type.BOOLEAN, (Object)skyLightSent);
        CustomByteType customByteType = new CustomByteType(Integer.valueOf(compressedData.size()));
        packetWrapper.write((Type)customByteType, (Object)compressedData.toByteArray());
        for (i = 0; i < columnCount; ++i) {
            packetWrapper.write((Type)Type.INT, (Object)chunkX[i]);
            packetWrapper.write((Type)Type.INT, (Object)chunkZ[i]);
            packetWrapper.write((Type)Type.SHORT, (Object)((short)primaryBitMask[i]));
            packetWrapper.write((Type)Type.SHORT, (Object)0);
        }
    }
}

