/*
 * Decompiled with CFR 0.152.
 */
package ir.feathermc.arenasetup.menus;

import ir.feathermc.arenasetup.SetupState;
import ir.feathermc.arenasetup.builder.ItemBuilder;
import ir.feathermc.arenasetup.builder.MenuBuilder;
import ir.feathermc.arenasetup.utils.ColorUtil;
import java.util.HashMap;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class SelectModeMenu
implements Listener {
    private final MenuBuilder selectModeMenu = new MenuBuilder(3, "&8Select a Mode");
    public static final HashMap<UUID, SetupState> playerStateMap = new HashMap();
    private final ItemBuilder solo = new ItemBuilder(Material.NETHER_STAR).setItemName("&aSolo");
    private final ItemBuilder duos = new ItemBuilder(Material.NETHER_STAR).setItemName("&aDoubles");
    private final ItemBuilder trios = new ItemBuilder(Material.NETHER_STAR).setItemName("&a3v3v3v3");
    private final ItemBuilder fours = new ItemBuilder(Material.NETHER_STAR).setItemName("&a4v4v4v4");

    public SelectModeMenu() {
        this.selectModeMenu.setItem(11, this.solo);
        this.selectModeMenu.setItem(13, this.duos);
        this.selectModeMenu.setItem(15, this.trios);
        this.selectModeMenu.setItem(17, this.fours);
    }

    public Inventory getMenu() {
        return this.selectModeMenu.toMenu();
    }

    @EventHandler
    private void onClick(InventoryClickEvent event) {
        if (event.getCurrentItem() == null || event.getSlot() == -999 || event.getCurrentItem().getItemMeta() == null) {
            return;
        }
        if (!event.getView().getTitle().equalsIgnoreCase(ColorUtil.color(this.selectModeMenu.getTitle()))) {
            return;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        HumanEntity humanEntity = event.getWhoClicked();
        if (item.equals((Object)this.solo.toItemStack())) {
            Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw setMaxInTeam 1");
            this.setupSoloDoubles(humanEntity);
            playerStateMap.put(humanEntity.getUniqueId(), SetupState.SOLO);
            humanEntity.closeInventory();
            return;
        }
        if (item.equals((Object)this.duos.toItemStack())) {
            Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw setMaxInTeam 2");
            playerStateMap.put(humanEntity.getUniqueId(), SetupState.SOLO);
            this.setupSoloDoubles(humanEntity);
            humanEntity.closeInventory();
            return;
        }
        if (item.equals((Object)this.trios.toItemStack())) {
            Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw setMaxInTeam 3");
            playerStateMap.put(humanEntity.getUniqueId(), SetupState.TEAMS);
            this.setupTriosFours(humanEntity);
            humanEntity.closeInventory();
            return;
        }
        if (item.equals((Object)this.fours.toItemStack())) {
            Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw setMaxInTeam 4");
            playerStateMap.put(humanEntity.getUniqueId(), SetupState.TEAMS);
            this.setupTriosFours(humanEntity);
            humanEntity.closeInventory();
        }
    }

    private void setupSoloDoubles(HumanEntity humanEntity) {
        this.setupTriosFours(humanEntity);
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Aqua Aqua");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam White White");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Pink Pink");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Gray Dark_Gray");
    }

    private void setupTriosFours(HumanEntity humanEntity) {
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Red Red");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Blue Blue");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Green Green");
        Bukkit.dispatchCommand((CommandSender)humanEntity, (String)"bw createTeam Yellow Yellow");
    }
}

