/*
 * Decompiled with CFR 0.152.
 */
package ir.feathermc.arenasetup.commands;

import ir.feathermc.arenasetup.ArenaSetup;
import ir.feathermc.arenasetup.SetupState;
import ir.feathermc.arenasetup.utils.ColorUtil;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class BedWarsSetup
implements CommandExecutor,
TabCompleter {
    private final String[] completions = new String[]{"waiting", "spawn", "generator"};

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (!(sender instanceof Player)) {
            return true;
        }
        Player player = (Player)sender;
        if (!player.hasPermission("bwsetup.admin")) {
            player.sendMessage(ColorUtil.color("&cYou don't have permission to use this command!"));
            return true;
        }
        if (!ArenaSetup.getBedWars().isInSetupSession(player.getUniqueId())) {
            player.sendMessage(ColorUtil.color("&cYou are not in setup session!"));
            return true;
        }
        if (args.length == 1) {
            switch (args[0].toLowerCase()) {
                case "waiting": {
                    ArenaSetup.getItemUtil().giveItems(player, SetupState.WAITING);
                    break;
                }
                case "spawn": {
                    ArenaSetup.getItemUtil().giveItems(player, SetupState.SPAWN);
                    break;
                }
                case "generator": {
                    ArenaSetup.getItemUtil().giveItems(player, SetupState.GENERATORS);
                    break;
                }
                default: {
                    player.sendMessage(ColorUtil.color("&cUsage: /" + label + " (Waiting|Spawn|Generator)"));
                }
            }
            return true;
        }
        player.sendMessage(ColorUtil.color("&cUsage: /" + label + " (Waiting|Spawn|Generator)"));
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1 && sender.hasPermission("bwsetup.admin")) {
            return Arrays.asList(this.completions);
        }
        return Collections.emptyList();
    }
}

