/*
 * Decompiled with CFR 0.152.
 */
package ir.feathermc.arenasetup;

import com.andrei1058.bedwars.api.BedWars;
import ir.feathermc.arenasetup.commands.BedWarsSetup;
import ir.feathermc.arenasetup.listeners.PlayerBlockPlaceListener;
import ir.feathermc.arenasetup.listeners.PlayerClickEvent;
import ir.feathermc.arenasetup.listeners.PlayerDropListener;
import ir.feathermc.arenasetup.listeners.PlayerInteractListener;
import ir.feathermc.arenasetup.listeners.session.PlayerCloseSessionListener;
import ir.feathermc.arenasetup.listeners.session.PlayerStartSessionListener;
import ir.feathermc.arenasetup.menus.SelectModeMenu;
import ir.feathermc.arenasetup.menus.SelectTeamMenu;
import ir.feathermc.arenasetup.utils.ItemUtil;
import java.util.Arrays;
import org.bukkit.command.CommandExecutor;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ArenaSetup
extends JavaPlugin {
    private static ItemUtil itemUtil;
    private static SelectModeMenu selectModeMenu;
    private static SelectTeamMenu selectTeamMenu;
    private static BedWars bedWars;

    public void onEnable() {
        itemUtil = new ItemUtil();
        this.getCommand("bwsetup").setExecutor((CommandExecutor)new BedWarsSetup());
        if (this.setupBedWars()) {
            bedWars = (BedWars)this.getServer().getServicesManager().getRegistration(BedWars.class).getProvider();
            Listener[] listenerArray = new Listener[8];
            listenerArray[0] = new PlayerInteractListener();
            listenerArray[1] = new PlayerBlockPlaceListener();
            listenerArray[2] = new PlayerDropListener();
            listenerArray[3] = new PlayerClickEvent();
            listenerArray[4] = new PlayerStartSessionListener();
            listenerArray[5] = new PlayerCloseSessionListener();
            selectModeMenu = new SelectModeMenu();
            listenerArray[6] = selectModeMenu;
            selectTeamMenu = new SelectTeamMenu();
            listenerArray[7] = selectTeamMenu;
            this.registerListeners(listenerArray);
        }
    }

    private boolean setupBedWars() {
        Plugin bedWars1058 = this.getServer().getPluginManager().getPlugin("BedWars1058");
        if (bedWars1058 == null) {
            this.getLogger().severe("[ERROR] BedWars1058 not found, disabling plugin...");
            this.setEnabled(false);
            return false;
        }
        return true;
    }

    private void registerListeners(Listener ... listeners) {
        Arrays.stream(listeners).forEach(listener -> this.getServer().getPluginManager().registerEvents(listener, (Plugin)this));
    }

    public static BedWars getBedWars() {
        return bedWars;
    }

    public static ItemUtil getItemUtil() {
        return itemUtil;
    }

    public static SelectModeMenu getSelectModeMenu() {
        return selectModeMenu;
    }

    public static SelectTeamMenu getSelectTeamMenu() {
        return selectTeamMenu;
    }
}

