/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers.nbt;

import com.comphenix.protocol.wrappers.collection.ConvertedList;
import com.comphenix.protocol.wrappers.nbt.NbtBase;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.comphenix.protocol.wrappers.nbt.NbtList;
import com.comphenix.protocol.wrappers.nbt.NbtType;
import com.comphenix.protocol.wrappers.nbt.NbtVisitor;
import com.comphenix.protocol.wrappers.nbt.NbtWrapper;
import com.comphenix.protocol.wrappers.nbt.WrappedElement;
import com.comphenix.protocol.wrappers.nbt.io.NbtBinarySerializer;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.DataOutput;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class WrappedList<TType>
implements NbtWrapper<List<NbtBase<TType>>>,
NbtList<TType> {
    private final WrappedElement<List<Object>> container;
    private ConvertedList<Object, NbtBase<TType>> savedList;
    private NbtType elementType = NbtType.TAG_END;

    public static <T> NbtList<T> fromName(String name) {
        return (NbtList)((Object)NbtFactory.ofWrapper(NbtType.TAG_LIST, name));
    }

    public static <T> NbtList<T> fromArray(String name, T ... elements) {
        NbtList<T> result = WrappedList.fromName(name);
        for (T element : elements) {
            if (element == null) {
                throw new IllegalArgumentException("An NBT list cannot contain a null element!");
            }
            if (element instanceof NbtBase) {
                result.add((NbtBase)element);
                continue;
            }
            result.add(NbtFactory.ofWrapper(element.getClass(), "", element));
        }
        return result;
    }

    public static <T> NbtList<T> fromList(String name, Collection<? extends T> elements) {
        NbtList<T> result = WrappedList.fromName(name);
        for (T element : elements) {
            if (element == null) {
                throw new IllegalArgumentException("An NBT list cannot contain a null element!");
            }
            if (element instanceof NbtBase) {
                result.add((NbtBase)element);
                continue;
            }
            result.add(NbtFactory.ofWrapper(element.getClass(), "", element));
        }
        return result;
    }

    public WrappedList(Object handle) {
        this.container = new WrappedElement(handle);
        this.elementType = this.container.getSubType();
    }

    public WrappedList(Object handle, String name) {
        this.container = new WrappedElement(handle, name);
        this.elementType = this.container.getSubType();
    }

    @Override
    public boolean accept(NbtVisitor visitor) {
        block1: {
            NbtBase node;
            if (!visitor.visitEnter(this)) break block1;
            Iterator iterator = this.getValue().iterator();
            while (iterator.hasNext() && (node = (NbtBase)iterator.next()).accept(visitor)) {
            }
        }
        return visitor.visitLeave(this);
    }

    @Override
    public Object getHandle() {
        return this.container.getHandle();
    }

    @Override
    public NbtType getType() {
        return NbtType.TAG_LIST;
    }

    @Override
    public NbtType getElementType() {
        return this.elementType;
    }

    @Override
    public void setElementType(NbtType type) {
        this.elementType = type;
        this.container.setSubType(type);
    }

    @Override
    public String getName() {
        return this.container.getName();
    }

    @Override
    public void setName(String name) {
        this.container.setName(name);
    }

    @Override
    public List<NbtBase<TType>> getValue() {
        if (this.savedList == null) {
            this.savedList = new ConvertedList<Object, NbtBase<TType>>(this.container.getValue()){

                private void verifyElement(NbtBase<TType> element) {
                    if (element == null) {
                        throw new IllegalArgumentException("Cannot store NULL elements in list.");
                    }
                    if (!element.getName().equals("")) {
                        throw new IllegalArgumentException("Cannot add a the named NBT tag " + element + " to a list.");
                    }
                    if (WrappedList.this.getElementType() != NbtType.TAG_END) {
                        if (!element.getType().equals((Object)WrappedList.this.getElementType())) {
                            throw new IllegalArgumentException("Cannot add " + element + " of " + (Object)((Object)element.getType()) + " to a list of type " + (Object)((Object)WrappedList.this.getElementType()));
                        }
                    } else {
                        WrappedList.this.container.setSubType(element.getType());
                    }
                }

                @Override
                public boolean add(NbtBase<TType> e) {
                    this.verifyElement(e);
                    return super.add(e);
                }

                @Override
                public void add(int index, NbtBase<TType> element) {
                    this.verifyElement(element);
                    super.add(index, element);
                }

                @Override
                public boolean addAll(Collection<? extends NbtBase<TType>> c) {
                    boolean result = false;
                    for (NbtBase element : c) {
                        this.add(element);
                        result = true;
                    }
                    return result;
                }

                @Override
                protected Object toInner(NbtBase<TType> outer) {
                    if (outer == null) {
                        return null;
                    }
                    return NbtFactory.fromBase(outer).getHandle();
                }

                @Override
                protected NbtBase<TType> toOuter(Object inner) {
                    if (inner == null) {
                        return null;
                    }
                    return NbtFactory.fromNMS(inner, null);
                }

                public String toString() {
                    return WrappedList.this.toString();
                }
            };
        }
        return this.savedList;
    }

    @Override
    public NbtBase<List<NbtBase<TType>>> deepClone() {
        return this.container.deepClone();
    }

    @Override
    public void addClosest(Object value) {
        if (this.getElementType() == NbtType.TAG_END) {
            throw new IllegalStateException("This list has not been typed yet.");
        }
        if (value instanceof Number) {
            Number number = (Number)value;
            switch (this.getElementType()) {
                case TAG_BYTE: {
                    this.add(number.byteValue());
                    break;
                }
                case TAG_SHORT: {
                    this.add(number.shortValue());
                    break;
                }
                case TAG_INT: {
                    this.add(number.intValue());
                    break;
                }
                case TAG_LONG: {
                    this.add(number.longValue());
                    break;
                }
                case TAG_FLOAT: {
                    this.add(number.floatValue());
                    break;
                }
                case TAG_DOUBLE: {
                    this.add(number.doubleValue());
                    break;
                }
                case TAG_STRING: {
                    this.add(number.toString());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Cannot convert " + value + " to " + (Object)((Object)this.getType()));
                }
            }
        } else if (value instanceof NbtBase) {
            this.add((NbtBase)value);
        } else {
            this.add(NbtFactory.ofWrapper(this.getElementType(), "", value));
        }
    }

    @Override
    public void add(NbtBase<TType> element) {
        this.getValue().add(element);
    }

    @Override
    public void add(String value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(byte value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(short value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(int value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(long value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(double value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(byte[] value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public void add(int[] value) {
        this.add(NbtFactory.of("", value));
    }

    @Override
    public int size() {
        return this.getValue().size();
    }

    @Override
    public TType getValue(int index) {
        return ((NbtBase)this.getValue().get(index)).getValue();
    }

    @Override
    public Collection<NbtBase<TType>> asCollection() {
        return this.getValue();
    }

    @Override
    public void setValue(List<NbtBase<TType>> newValue) {
        NbtBase<TType> lastElement = null;
        List<Object> list = this.container.getValue();
        list.clear();
        for (NbtBase<TType> type : newValue) {
            if (type != null) {
                lastElement = type;
                list.add(NbtFactory.fromBase(type).getHandle());
                continue;
            }
            list.add(null);
        }
        if (lastElement != null) {
            this.container.setSubType(lastElement.getType());
        }
    }

    @Override
    public void write(DataOutput destination) {
        NbtBinarySerializer.DEFAULT.serialize(this.container, destination);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WrappedList) {
            WrappedList other = (WrappedList)obj;
            return this.container.equals(other.container);
        }
        return false;
    }

    public int hashCode() {
        return this.container.hashCode();
    }

    @Override
    public Iterator<TType> iterator() {
        return Iterables.transform((Iterable)this.getValue(), NbtBase::getValue).iterator();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{\"name\": \"" + this.getName() + "\", \"value\": [");
        if (this.size() > 0) {
            if (this.getElementType() == NbtType.TAG_STRING) {
                builder.append("\"" + Joiner.on((String)"\", \"").join((Iterable)this) + "\"");
            } else {
                builder.append(Joiner.on((String)", ").join((Iterable)this));
            }
        }
        builder.append("]}");
        return builder.toString();
    }

    @Override
    public void remove(Object remove) {
        this.getValue().remove(remove);
    }
}

