/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.BukkitUnwrapper;
import com.comphenix.protocol.reflect.StructureModifier;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Base64;
import org.bukkit.entity.Player;

public class WrappedProfilePublicKey
extends AbstractWrapper {
    private static ConstructorAccessor CONSTRUCTOR;
    private static FieldAccessor DATA_ACCESSOR;
    private static FieldAccessor PROFILE_KEY_ACCESSOR;

    public WrappedProfilePublicKey(Object handle) {
        super(MinecraftReflection.getProfilePublicKeyClass());
        this.setHandle(handle);
    }

    public WrappedProfilePublicKey(WrappedProfileKeyData keyData) {
        super(MinecraftReflection.getProfilePublicKeyClass());
        if (CONSTRUCTOR == null) {
            CONSTRUCTOR = Accessors.getConstructorAccessor(this.getHandleType(), MinecraftReflection.getProfilePublicKeyDataClass());
        }
        this.setHandle(CONSTRUCTOR.invoke(keyData.getHandle()));
    }

    public static WrappedProfilePublicKey ofPlayer(Player player) {
        FieldAccessor accessor = PROFILE_KEY_ACCESSOR;
        if (accessor == null) {
            PROFILE_KEY_ACCESSOR = accessor = Accessors.getFieldAccessor(MinecraftReflection.getEntityHumanClass(), MinecraftReflection.getProfilePublicKeyClass(), true);
        }
        Object nmsPlayer = BukkitUnwrapper.getInstance().unwrapItem(player);
        return new WrappedProfilePublicKey(accessor.get(nmsPlayer));
    }

    public WrappedProfileKeyData getKeyData() {
        if (DATA_ACCESSOR == null) {
            DATA_ACCESSOR = Accessors.getFieldAccessor(this.getHandleType(), MinecraftReflection.getProfilePublicKeyDataClass(), true);
        }
        return new WrappedProfileKeyData(DATA_ACCESSOR.get(this.getHandle()));
    }

    public void setKeyData(WrappedProfileKeyData keyData) {
        if (DATA_ACCESSOR == null) {
            DATA_ACCESSOR = Accessors.getFieldAccessor(this.getHandleType(), MinecraftReflection.getProfilePublicKeyDataClass(), true);
        }
        DATA_ACCESSOR.set(this.getHandle(), keyData.getHandle());
    }

    public static class WrappedProfileKeyData
    extends AbstractWrapper {
        private static ConstructorAccessor CONSTRUCTOR;
        private static final Base64.Encoder MIME_ENCODER;
        private final StructureModifier<Object> modifier;

        public WrappedProfileKeyData(Object handle) {
            super(MinecraftReflection.getProfilePublicKeyDataClass());
            this.setHandle(handle);
            this.modifier = new StructureModifier(MinecraftReflection.getProfilePublicKeyDataClass()).withTarget(handle);
        }

        public WrappedProfileKeyData(Instant expireTime, PublicKey key, byte[] signature) {
            super(MinecraftReflection.getProfilePublicKeyDataClass());
            if (CONSTRUCTOR == null) {
                CONSTRUCTOR = Accessors.getConstructorAccessor(this.getHandleType(), Instant.class, PublicKey.class, byte[].class);
            }
            this.setHandle(CONSTRUCTOR.invoke(expireTime, key, signature));
            this.modifier = new StructureModifier(MinecraftReflection.getProfilePublicKeyDataClass()).withTarget(this.handle);
        }

        public Instant getExpireTime() {
            return (Instant)this.modifier.withType(Instant.class).read(0);
        }

        public void setExpireTime(Instant expireTime) {
            this.modifier.withType(Instant.class).write(0, expireTime);
        }

        public boolean isExpired() {
            return this.getExpireTime().isBefore(Instant.now());
        }

        public String getSignedPayload() {
            String rsaString = "-----BEGIN RSA PUBLIC KEY-----\n" + MIME_ENCODER.encodeToString(this.getKey().getEncoded()) + "\n-----END RSA PUBLIC KEY-----\n";
            return this.getExpireTime().toEpochMilli() + rsaString;
        }

        public PublicKey getKey() {
            return (PublicKey)this.modifier.withType(PublicKey.class).read(0);
        }

        public void setKey(PublicKey key) {
            this.modifier.withType(PublicKey.class).write(0, key);
        }

        public byte[] getSignature() {
            return (byte[])this.modifier.withType(byte[].class).read(0);
        }

        public void setSignature(byte[] signature) {
            this.modifier.withType(byte[].class).write(0, signature);
        }

        static {
            MIME_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
        }
    }
}

