/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.wrappers;

import com.comphenix.protocol.injector.StructureCache;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.ConstructorAccessor;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.ZeroBuffer;
import com.comphenix.protocol.wrappers.AbstractWrapper;
import com.comphenix.protocol.wrappers.MinecraftKey;
import com.comphenix.protocol.wrappers.WrappedRegistry;
import com.comphenix.protocol.wrappers.nbt.NbtCompound;
import com.comphenix.protocol.wrappers.nbt.NbtFactory;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class WrappedLevelChunkData {
    private WrappedLevelChunkData() {
    }

    public static class BlockEntityInfo
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getBlockEntityInfoClass();
        private static final WrappedRegistry REGISTRY = WrappedRegistry.getRegistry(MinecraftReflection.getBlockEntityTypeClass());
        private static final ConstructorAccessor BLOCK_ENTITY_INFO_CONSTRUCTOR;
        private static final FieldAccessor PACKED_XZ_ACCESSOR;
        private static final FieldAccessor Y_ACCESSOR;
        private static final FieldAccessor TYPE_ACCESSOR;
        private static final FieldAccessor TAG_ACCESSOR;

        public BlockEntityInfo(Object handle) {
            super(HANDLE_TYPE);
            this.setHandle(handle);
        }

        public int getSectionX() {
            return (Integer)PACKED_XZ_ACCESSOR.get(this.handle) >> 4;
        }

        public void setSectionX(int sectionX) {
            PACKED_XZ_ACCESSOR.set(this.handle, sectionX << 4 | this.getSectionZ());
        }

        public int getSectionZ() {
            return (Integer)PACKED_XZ_ACCESSOR.get(this.handle) & 0xF;
        }

        public void setSectionZ(int sectionZ) {
            PACKED_XZ_ACCESSOR.set(this.handle, this.getSectionX() << 4 | sectionZ);
        }

        public int getY() {
            return (Integer)Y_ACCESSOR.get(this.handle);
        }

        public void setY(int y) {
            Y_ACCESSOR.set(this.handle, y);
        }

        public MinecraftKey getTypeKey() {
            return REGISTRY.getKey(TYPE_ACCESSOR.get(this.handle));
        }

        public void setTypeKey(MinecraftKey typeKey) {
            TYPE_ACCESSOR.set(this.handle, REGISTRY.get(typeKey));
        }

        @Nullable
        public NbtCompound getAdditionalData() {
            Object tagHandle = TAG_ACCESSOR.get(this.handle);
            return tagHandle == null ? null : NbtFactory.fromNMSCompound(tagHandle);
        }

        public void setAdditionalData(@Nullable NbtCompound additionalData) {
            TAG_ACCESSOR.set(this.handle, additionalData == null ? null : NbtFactory.fromBase(additionalData).getHandle());
        }

        public static BlockEntityInfo fromValues(int sectionX, int sectionZ, int y, MinecraftKey typeKey) {
            return BlockEntityInfo.fromValues(sectionX, sectionZ, y, typeKey, null);
        }

        public static BlockEntityInfo fromValues(int sectionX, int sectionZ, int y, MinecraftKey typeKey, @Nullable NbtCompound additionalData) {
            return new BlockEntityInfo(BLOCK_ENTITY_INFO_CONSTRUCTOR.invoke(sectionX << 4 | sectionZ, y, REGISTRY.get(typeKey), additionalData == null ? null : NbtFactory.fromBase(additionalData).getHandle()));
        }

        static {
            FuzzyReflection reflection = FuzzyReflection.fromClass(HANDLE_TYPE, true);
            List<Field> posFields = reflection.getFieldList(FuzzyFieldContract.newBuilder().typeExact(Integer.TYPE).build());
            BLOCK_ENTITY_INFO_CONSTRUCTOR = Accessors.getConstructorAccessor(HANDLE_TYPE, Integer.TYPE, Integer.TYPE, MinecraftReflection.getBlockEntityTypeClass(), MinecraftReflection.getNBTCompoundClass());
            PACKED_XZ_ACCESSOR = Accessors.getFieldAccessor(posFields.get(0));
            Y_ACCESSOR = Accessors.getFieldAccessor(posFields.get(1));
            TYPE_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getBlockEntityTypeClass()).build()));
            TAG_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getNBTCompoundClass()).build()));
        }
    }

    public static class LightData
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getLightUpdatePacketDataClass();
        private static final ConstructorAccessor LIGHT_UPDATE_PACKET_DATA_CONSTRUCTOR;
        private static final FieldAccessor[] BIT_SET_ACCESSORS;
        private static final FieldAccessor[] BYTE_ARRAY_LIST_ACCESSORS;
        private static final FieldAccessor TRUST_EDGES_ACCESSOR;

        public LightData(Object handle) {
            super(HANDLE_TYPE);
            this.setHandle(handle);
        }

        public BitSet getSkyYMask() {
            return (BitSet)BIT_SET_ACCESSORS[0].get(this.handle);
        }

        public void setSkyYMask(BitSet skyYMask) {
            BIT_SET_ACCESSORS[0].set(this.handle, skyYMask);
        }

        public BitSet getBlockYMask() {
            return (BitSet)BIT_SET_ACCESSORS[1].get(this.handle);
        }

        public void setBlockYMask(BitSet blockYMask) {
            BIT_SET_ACCESSORS[1].set(this.handle, blockYMask);
        }

        public BitSet getEmptySkyYMask() {
            return (BitSet)BIT_SET_ACCESSORS[2].get(this.handle);
        }

        public void setEmptySkyYMask(BitSet emptySkyYMask) {
            BIT_SET_ACCESSORS[2].set(this.handle, emptySkyYMask);
        }

        public BitSet getEmptyBlockYMask() {
            return (BitSet)BIT_SET_ACCESSORS[3].get(this.handle);
        }

        public void setEmptyBlockYMask(BitSet emptyBlockYMask) {
            BIT_SET_ACCESSORS[3].set(this.handle, emptyBlockYMask);
        }

        public List<byte[]> getSkyUpdates() {
            return (List)BYTE_ARRAY_LIST_ACCESSORS[0].get(this.handle);
        }

        public List<byte[]> getBlockUpdates() {
            return (List)BYTE_ARRAY_LIST_ACCESSORS[1].get(this.handle);
        }

        public boolean isTrustEdges() {
            return (Boolean)TRUST_EDGES_ACCESSOR.get(this.handle);
        }

        public void setTrustEdges(boolean trustEdges) {
            TRUST_EDGES_ACCESSOR.set(this.handle, trustEdges);
        }

        public static LightData fromValues(BitSet skyYMask, BitSet blockYMask, BitSet emptySkyYMask, BitSet emptyBlockYMask, List<byte[]> skyUpdates, List<byte[]> blockUpdates, boolean trustEdges) {
            LightData data = new LightData(LIGHT_UPDATE_PACKET_DATA_CONSTRUCTOR.invoke(MinecraftReflection.getPacketDataSerializer((Object)new ZeroBuffer()), 0, 0));
            data.setTrustEdges(trustEdges);
            data.setSkyYMask(skyYMask);
            data.setBlockYMask(blockYMask);
            data.setEmptySkyYMask(emptySkyYMask);
            data.setEmptyBlockYMask(emptyBlockYMask);
            data.getSkyUpdates().addAll(skyUpdates);
            data.getBlockUpdates().addAll(blockUpdates);
            return data;
        }

        static {
            FuzzyReflection reflection = FuzzyReflection.fromClass(HANDLE_TYPE, true);
            LIGHT_UPDATE_PACKET_DATA_CONSTRUCTOR = Accessors.getConstructorAccessor(HANDLE_TYPE, MinecraftReflection.getPacketDataSerializerClass(), Integer.TYPE, Integer.TYPE);
            BIT_SET_ACCESSORS = Accessors.getFieldAccessorArray(HANDLE_TYPE, BitSet.class, true);
            BYTE_ARRAY_LIST_ACCESSORS = Accessors.getFieldAccessorArray(HANDLE_TYPE, List.class, true);
            TRUST_EDGES_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(Boolean.TYPE).build()));
        }
    }

    public static final class ChunkData
    extends AbstractWrapper {
        private static final Class<?> HANDLE_TYPE = MinecraftReflection.getLevelChunkPacketDataClass();
        private static final ConstructorAccessor LEVEL_CHUNK_PACKET_DATA_CONSTRUCTOR;
        private static final FieldAccessor BLOCK_ENTITIES_DATA_ACCESSOR;
        private static final FieldAccessor HEIGHTMAPS_ACCESSOR;
        private static final FieldAccessor BUFFER_ACCESSOR;

        public ChunkData(Object handle) {
            super(HANDLE_TYPE);
            this.setHandle(handle);
        }

        public NbtCompound getHeightmapsTag() {
            return NbtFactory.fromNMSCompound(HEIGHTMAPS_ACCESSOR.get(this.handle));
        }

        public void setHeightmapsTag(NbtCompound heightmapsTag) {
            HEIGHTMAPS_ACCESSOR.set(this.handle, NbtFactory.fromBase(heightmapsTag).getHandle());
        }

        public byte[] getBuffer() {
            return (byte[])BUFFER_ACCESSOR.get(this.handle);
        }

        public void setBuffer(byte[] buffer) {
            BUFFER_ACCESSOR.set(this.handle, buffer);
        }

        public List<BlockEntityInfo> getBlockEntityInfo() {
            return Lists.transform((List)((List)BLOCK_ENTITIES_DATA_ACCESSOR.get(this.handle)), BlockEntityInfo::new);
        }

        public void setBlockEntityInfo(List<BlockEntityInfo> blockEntityInfo) {
            ArrayList<Object> handleList = new ArrayList<Object>(blockEntityInfo.size());
            for (BlockEntityInfo info : blockEntityInfo) {
                handleList.add(info.getHandle());
            }
            BLOCK_ENTITIES_DATA_ACCESSOR.set(this.handle, handleList);
        }

        public static ChunkData fromValues(NbtCompound heightmapsTag, byte[] buffer, List<BlockEntityInfo> blockEntityInfo) {
            ChunkData data = new ChunkData(LEVEL_CHUNK_PACKET_DATA_CONSTRUCTOR.invoke(StructureCache.newNullDataSerializer(), 0, 0));
            data.setHeightmapsTag(heightmapsTag);
            data.setBuffer(buffer);
            data.setBlockEntityInfo(blockEntityInfo);
            return new ChunkData(data);
        }

        static {
            FuzzyReflection reflection = FuzzyReflection.fromClass(HANDLE_TYPE, true);
            LEVEL_CHUNK_PACKET_DATA_CONSTRUCTOR = Accessors.getConstructorAccessor(HANDLE_TYPE, MinecraftReflection.getPacketDataSerializerClass(), Integer.TYPE, Integer.TYPE);
            BLOCK_ENTITIES_DATA_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(List.class).build()));
            HEIGHTMAPS_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(MinecraftReflection.getNBTCompoundClass()).build()));
            BUFFER_ACCESSOR = Accessors.getFieldAccessor(reflection.getField(FuzzyFieldContract.newBuilder().typeExact(byte[].class).build()));
        }
    }
}

