/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.timing;

import com.comphenix.protocol.timing.OnlineComputation;
import com.comphenix.protocol.timing.StatisticsStream;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;

public class HistogramStream
extends OnlineComputation {
    protected List<StatisticsStream> bins;
    protected StatisticsStream current;
    protected int binWidth;
    protected int count;

    public HistogramStream(int binWidth) {
        this(new ArrayList<StatisticsStream>(), new StatisticsStream(), binWidth);
    }

    public HistogramStream(HistogramStream other) {
        for (StatisticsStream stream : other.bins) {
            StatisticsStream copy = stream.copy();
            if (stream == other.current) {
                this.current = copy;
            }
            this.bins.add(copy);
        }
        this.binWidth = other.binWidth;
    }

    protected HistogramStream(List<StatisticsStream> bins, StatisticsStream current, int binWidth) {
        if (binWidth < 1) {
            throw new IllegalArgumentException("binWidth cannot be less than 1");
        }
        this.bins = (List)Preconditions.checkNotNull(bins, (Object)"bins cannot be NULL");
        this.current = (StatisticsStream)Preconditions.checkNotNull((Object)current, (Object)"current cannot be NULL");
        this.binWidth = binWidth;
        if (!this.bins.contains(current)) {
            this.bins.add(current);
        }
    }

    @Override
    public HistogramStream copy() {
        return new HistogramStream(this);
    }

    public ImmutableList<StatisticsStream> getBins() {
        return ImmutableList.copyOf(this.bins);
    }

    @Override
    public void observe(double value) {
        this.checkOverflow();
        ++this.count;
        this.current.observe(value);
    }

    protected void checkOverflow() {
        if (this.current.getCount() >= this.binWidth) {
            this.current = new StatisticsStream();
            this.bins.add(this.current);
        }
    }

    public StatisticsStream getTotal() {
        StatisticsStream sum = null;
        for (StatisticsStream stream : this.bins) {
            sum = sum != null ? stream.add(sum) : stream;
        }
        return sum;
    }

    @Override
    public int getCount() {
        return this.count;
    }
}

