/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.reflect.fuzzy;

import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMatcher;
import com.comphenix.protocol.reflect.fuzzy.AbstractFuzzyMember;
import com.comphenix.protocol.reflect.fuzzy.ClassTypeMatcher;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMatchers;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;

public class FuzzyFieldContract
extends AbstractFuzzyMember<Field> {
    private AbstractFuzzyMatcher<Class<?>> typeMatcher = ClassTypeMatcher.MATCH_ALL;

    private FuzzyFieldContract() {
    }

    private FuzzyFieldContract(FuzzyFieldContract other) {
        super(other);
        this.typeMatcher = other.typeMatcher;
    }

    public static FuzzyFieldContract matchType(AbstractFuzzyMatcher<Class<?>> matcher) {
        return FuzzyFieldContract.newBuilder().typeMatches(matcher).build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public AbstractFuzzyMatcher<Class<?>> getTypeMatcher() {
        return this.typeMatcher;
    }

    @Override
    public boolean isMatch(Field value, Object parent) {
        if (super.isMatch(value, parent)) {
            return this.typeMatcher.isMatch(value.getType(), value);
        }
        return false;
    }

    @Override
    protected Map<String, Object> getKeyValueView() {
        Map<String, Object> member = super.getKeyValueView();
        if (this.typeMatcher != ClassTypeMatcher.MATCH_ALL) {
            member.put("type", this.typeMatcher);
        }
        return member;
    }

    public static class Builder
    extends AbstractFuzzyMember.Builder<FuzzyFieldContract> {
        public Builder requireModifier(int modifier) {
            super.requireModifier(modifier);
            return this;
        }

        public Builder banModifier(int modifier) {
            super.banModifier(modifier);
            return this;
        }

        public Builder requirePublic() {
            super.requirePublic();
            return this;
        }

        public Builder nameRegex(String regex) {
            super.nameRegex(regex);
            return this;
        }

        public Builder nameRegex(Pattern pattern) {
            super.nameRegex(pattern);
            return this;
        }

        public Builder nameExact(String name) {
            super.nameExact(name);
            return this;
        }

        public Builder declaringClassExactType(Class<?> declaringClass) {
            super.declaringClassExactType(declaringClass);
            return this;
        }

        public Builder declaringClassSuperOf(Class<?> declaringClass) {
            super.declaringClassSuperOf(declaringClass);
            return this;
        }

        public Builder declaringClassDerivedOf(Class<?> declaringClass) {
            super.declaringClassDerivedOf(declaringClass);
            return this;
        }

        public Builder declaringClassMatching(AbstractFuzzyMatcher<Class<?>> classMatcher) {
            super.declaringClassMatching(classMatcher);
            return this;
        }

        @Override
        @Nonnull
        protected FuzzyFieldContract initialMember() {
            return new FuzzyFieldContract();
        }

        public Builder typeExact(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchExact(type);
            return this;
        }

        public Builder typeSuperOf(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchSuper(type);
            return this;
        }

        public Builder typeDerivedOf(Class<?> type) {
            ((FuzzyFieldContract)this.member).typeMatcher = FuzzyMatchers.matchDerived(type);
            return this;
        }

        public Builder typeMatches(AbstractFuzzyMatcher<Class<?>> matcher) {
            ((FuzzyFieldContract)this.member).typeMatcher = matcher;
            return this;
        }

        @Override
        public FuzzyFieldContract build() {
            ((FuzzyFieldContract)this.member).prepareBuild();
            return new FuzzyFieldContract((FuzzyFieldContract)this.member);
        }
    }
}

