/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.manager;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLogger;
import com.comphenix.protocol.concurrency.PacketTypeSet;
import com.comphenix.protocol.error.ErrorReporter;
import com.comphenix.protocol.events.NetworkMarker;
import com.comphenix.protocol.events.PacketContainer;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.injector.ListenerInvoker;
import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.Injector;
import com.comphenix.protocol.injector.netty.channel.InjectionFactory;
import com.comphenix.protocol.injector.netty.manager.InjectionChannelInboundHandler;
import com.comphenix.protocol.injector.netty.manager.InjectionChannelInitializer;
import com.comphenix.protocol.injector.netty.manager.ListeningList;
import com.comphenix.protocol.injector.netty.manager.NetworkManagerPacketInjector;
import com.comphenix.protocol.injector.netty.manager.NetworkManagerPlayerInjector;
import com.comphenix.protocol.injector.packet.PacketInjector;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.injector.player.PlayerInjectionHandler;
import com.comphenix.protocol.injector.temporary.TemporaryPlayerFactory;
import com.comphenix.protocol.reflect.FuzzyReflection;
import com.comphenix.protocol.reflect.accessors.Accessors;
import com.comphenix.protocol.reflect.accessors.FieldAccessor;
import com.comphenix.protocol.reflect.fuzzy.FuzzyFieldContract;
import com.comphenix.protocol.reflect.fuzzy.FuzzyMethodContract;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.wrappers.Pair;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInboundHandler;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.bukkit.Server;
import org.bukkit.plugin.Plugin;

public class NetworkManagerInjector
implements ChannelListener {
    private static final String INBOUND_INJECT_HANDLER_NAME = "protocol_lib_inbound_inject";
    private static final TemporaryPlayerFactory PLAYER_FACTORY = new TemporaryPlayerFactory();
    private final PacketTypeSet inboundListeners = new PacketTypeSet();
    private final PacketTypeSet outboundListeners = new PacketTypeSet();
    private final PacketTypeSet mainThreadListeners = new PacketTypeSet();
    private final Set<Pair<Object, FieldAccessor>> overriddenLists = new HashSet<Pair<Object, FieldAccessor>>();
    private final ErrorReporter errorReporter;
    private final ListenerInvoker listenerInvoker;
    private final InjectionFactory injectionFactory;
    private final PacketInjector packetInjector;
    private final PlayerInjectionHandler playerInjectionHandler;
    private final InjectionChannelInitializer pipelineInjectorHandler;
    private boolean debug = false;
    private boolean closed = false;
    private boolean injected = false;

    public NetworkManagerInjector(Plugin plugin, Server server, ListenerInvoker listenerInvoker, ErrorReporter reporter) {
        this.errorReporter = reporter;
        this.listenerInvoker = listenerInvoker;
        this.injectionFactory = new InjectionFactory(plugin, server, reporter);
        InjectionChannelInboundHandler injectionHandler = new InjectionChannelInboundHandler(this.injectionFactory, this, PLAYER_FACTORY);
        this.pipelineInjectorHandler = new InjectionChannelInitializer(INBOUND_INJECT_HANDLER_NAME, (ChannelInboundHandler)injectionHandler);
        this.playerInjectionHandler = new NetworkManagerPlayerInjector(this.outboundListeners, this, this.injectionFactory, this.mainThreadListeners);
        this.packetInjector = new NetworkManagerPacketInjector(this.inboundListeners, this.listenerInvoker, this, this.mainThreadListeners);
    }

    @Override
    public PacketEvent onPacketSending(Injector injector, Object packet, NetworkMarker marker) {
        Class<?> packetClass = packet.getClass();
        if (marker != null || MinecraftReflection.isBundlePacket(packetClass) || this.outboundListeners.contains(packetClass)) {
            PacketContainer container = new PacketContainer(PacketRegistry.getPacketType(packetClass), packet);
            PacketEvent packetEvent = PacketEvent.fromServer(this, container, marker, injector.getPlayer());
            this.listenerInvoker.invokePacketSending(packetEvent);
            return packetEvent;
        }
        return null;
    }

    @Override
    public PacketEvent onPacketReceiving(Injector injector, Object packet, NetworkMarker marker) {
        Class<?> packetClass = packet.getClass();
        if (marker != null || this.inboundListeners.contains(packetClass)) {
            PacketContainer container = new PacketContainer(PacketRegistry.getPacketType(packetClass), packet);
            PacketEvent packetEvent = PacketEvent.fromClient(this, container, marker, injector.getPlayer());
            this.listenerInvoker.invokePacketReceiving(packetEvent);
            return packetEvent;
        }
        return null;
    }

    @Override
    public boolean hasListener(Class<?> packetClass) {
        return this.outboundListeners.contains(packetClass) || this.inboundListeners.contains(packetClass);
    }

    @Override
    public boolean hasMainThreadListener(Class<?> packetClass) {
        return this.mainThreadListeners.contains(packetClass);
    }

    @Override
    public boolean hasMainThreadListener(PacketType type) {
        return this.mainThreadListeners.contains(type);
    }

    @Override
    public ErrorReporter getReporter() {
        return this.errorReporter;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inject() {
        if (this.closed || this.injected) {
            return;
        }
        FuzzyReflection server = FuzzyReflection.fromClass(MinecraftReflection.getMinecraftServerClass());
        List<Method> serverConnectionGetter = server.getMethodList(FuzzyMethodContract.newBuilder().parameterCount(0).banModifier(8).returnTypeExact(MinecraftReflection.getServerConnectionClass()).build());
        Object serverInstance = server.getSingleton();
        Object serverConnection = null;
        for (Method method : serverConnectionGetter) {
            try {
                serverConnection = method.invoke(serverInstance, new Object[0]);
                if (serverConnection == null) continue;
                break;
            }
            catch (Exception exception) {
                ProtocolLogger.debug("Exception invoking getter for server connection " + method, exception);
            }
        }
        if (serverConnection == null) {
            throw new IllegalStateException("Unable to retrieve ServerConnection instance from MinecraftServer");
        }
        FuzzyReflection serverConnectionFuzzy = FuzzyReflection.fromObject(serverConnection, true);
        List<Field> listFields = serverConnectionFuzzy.getFieldList(FuzzyFieldContract.newBuilder().typeDerivedOf(List.class).banModifier(8).build());
        for (Field field : listFields) {
            if (!field.getGenericType().getTypeName().contains(ChannelFuture.class.getName())) continue;
            FieldAccessor accessor = Accessors.getFieldAccessor(field);
            List value = (List)accessor.get(serverConnection);
            this.overriddenLists.add(new Pair<Object, FieldAccessor>(serverConnection, accessor));
            List list = value;
            synchronized (list) {
                ListeningList newList = new ListeningList(value, (ChannelHandler)this.pipelineInjectorHandler);
                accessor.set(serverConnection, newList);
            }
        }
        this.injected = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (this.closed || !this.injected) {
            return;
        }
        this.closed = true;
        this.injected = false;
        for (Pair<Object, FieldAccessor> list : this.overriddenLists) {
            List<Object> original;
            Object currentFieldValue = list.getSecond().get(list.getFirst());
            if (!(currentFieldValue instanceof ListeningList)) continue;
            ListeningList ourList = (ListeningList)currentFieldValue;
            List<Object> list2 = original = ourList.getOriginal();
            synchronized (list2) {
                ourList.unProcessAll();
                list.getSecond().set(list.getFirst(), original);
            }
        }
        this.overriddenLists.clear();
        this.injectionFactory.close();
    }

    public PacketInjector getPacketInjector() {
        return this.packetInjector;
    }

    public PlayerInjectionHandler getPlayerInjectionHandler() {
        return this.playerInjectionHandler;
    }
}

