/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.injector.netty.channel;

import com.comphenix.protocol.injector.netty.ChannelListener;
import com.comphenix.protocol.injector.netty.channel.NettyChannelInjector;
import com.comphenix.protocol.utility.MinecraftReflection;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;

final class InboundPacketInterceptor
extends ChannelInboundHandlerAdapter {
    private final NettyChannelInjector injector;
    private final ChannelListener channelListener;

    public InboundPacketInterceptor(NettyChannelInjector injector, ChannelListener listener) {
        this.injector = injector;
        this.channelListener = listener;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        Class<?> messageClass = msg.getClass();
        if (this.shouldInterceptMessage(messageClass)) {
            this.injector.tryProcessLogin(msg);
            if (!this.channelListener.hasListener(messageClass)) {
                ctx.fireChannelRead(msg);
                return;
            }
            this.injector.processInboundPacket(ctx, msg, messageClass);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private boolean shouldInterceptMessage(Class<?> messageClass) {
        return MinecraftReflection.getPacketClass().isAssignableFrom(messageClass);
    }
}

