/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.error;

import com.google.common.base.Preconditions;
import java.io.File;
import java.net.URLDecoder;
import java.security.CodeSource;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public final class PluginContext {
    private static File pluginFolder;

    private PluginContext() {
    }

    public static String getPluginCaller(Exception ex) {
        StackTraceElement[] elements = ex.getStackTrace();
        String current = PluginContext.getPluginName(elements[0]);
        for (int i = 1; i < elements.length; ++i) {
            String caller = PluginContext.getPluginName(elements[i]);
            if (caller == null || caller.equals(current)) continue;
            return caller;
        }
        return null;
    }

    public static String getPluginName(StackTraceElement element) {
        try {
            if (Bukkit.getServer() == null) {
                return null;
            }
            CodeSource codeSource = Class.forName(element.getClassName()).getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                String encoding = codeSource.getLocation().getPath();
                File path = new File(URLDecoder.decode(encoding, "UTF-8"));
                File plugins = PluginContext.getPluginFolder();
                if (plugins != null && PluginContext.folderContains(plugins, path)) {
                    return path.getName().replaceAll(".jar", "");
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    private static boolean folderContains(File folder, File file) {
        Preconditions.checkNotNull((Object)folder, (Object)"folder cannot be NULL");
        Preconditions.checkNotNull((Object)file, (Object)"file cannot be NULL");
        folder = folder.getAbsoluteFile();
        for (file = file.getAbsoluteFile(); file != null; file = file.getParentFile()) {
            if (!folder.equals(file)) continue;
            return true;
        }
        return false;
    }

    private static File getPluginFolder() {
        Plugin[] plugins;
        File folder = pluginFolder;
        if (folder == null && Bukkit.getServer() != null && (plugins = Bukkit.getPluginManager().getPlugins()).length > 0) {
            pluginFolder = folder = plugins[0].getDataFolder().getParentFile();
        }
        return folder;
    }
}

