/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol.async;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.async.AsyncMarker;
import com.comphenix.protocol.async.PacketEventHolder;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.reflect.FieldAccessException;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.PriorityBlockingQueue;
import org.bukkit.entity.Player;

abstract class PacketSendingQueue {
    public static final int INITIAL_CAPACITY = 10;
    private final boolean notThreadSafe;
    private final PriorityBlockingQueue<PacketEventHolder> sendingQueue = new PriorityBlockingQueue(10);
    private final Executor asynchronousSender;
    private boolean cleanedUp = false;

    public PacketSendingQueue(boolean notThreadSafe, Executor asynchronousSender) {
        this.notThreadSafe = notThreadSafe;
        this.asynchronousSender = asynchronousSender;
    }

    public int size() {
        return this.sendingQueue.size();
    }

    public void enqueue(PacketEvent packet) {
        this.sendingQueue.add(new PacketEventHolder(packet));
    }

    public synchronized void signalPacketUpdate(PacketEvent packetUpdated, boolean onMainThread) {
        AsyncMarker marker = packetUpdated.getAsyncMarker();
        if (marker.getQueuedSendingIndex() != marker.getNewSendingIndex() && !marker.hasExpired()) {
            PacketEvent copy = PacketEvent.fromSynchronous(packetUpdated, marker);
            packetUpdated.setReadOnly(false);
            packetUpdated.setCancelled(true);
            this.enqueue(copy);
        }
        marker.setProcessed(true);
        this.trySendPackets(onMainThread);
    }

    public synchronized void signalPacketUpdate(List<PacketType> packetsRemoved, boolean onMainThread) {
        HashSet<PacketType> lookup = new HashSet<PacketType>(packetsRemoved);
        for (PacketEventHolder holder : this.sendingQueue) {
            PacketEvent event = holder.getEvent();
            if (!lookup.contains(event.getPacketType())) continue;
            event.getAsyncMarker().setProcessed(true);
        }
        this.trySendPackets(onMainThread);
    }

    public void trySendPackets(boolean onMainThread) {
        boolean sending = true;
        while (sending) {
            PacketEventHolder holder = this.sendingQueue.poll();
            if (holder != null) {
                sending = this.processPacketHolder(onMainThread, holder);
                if (sending) continue;
                this.sendingQueue.add(holder);
                continue;
            }
            sending = false;
        }
    }

    private boolean processPacketHolder(boolean onMainThread, PacketEventHolder holder) {
        PacketEvent current = holder.getEvent();
        AsyncMarker marker = current.getAsyncMarker();
        boolean hasExpired = marker.hasExpired();
        if (this.cleanedUp) {
            return true;
        }
        if (marker.isProcessed() || hasExpired) {
            if (hasExpired) {
                this.onPacketTimeout(current);
                marker = current.getAsyncMarker();
                hasExpired = marker.hasExpired();
                if (!marker.isProcessed() && !hasExpired) {
                    return false;
                }
            }
            if (!current.isCancelled() && !hasExpired) {
                if (this.notThreadSafe) {
                    try {
                        boolean wantSync;
                        boolean wantAsync = marker.isMinecraftAsync(current);
                        boolean bl = wantSync = !wantAsync;
                        if (!onMainThread && wantSync) {
                            return false;
                        }
                        if (onMainThread && wantAsync) {
                            this.asynchronousSender.execute(() -> this.processPacketHolder(false, holder));
                            return true;
                        }
                    }
                    catch (FieldAccessException e) {
                        e.printStackTrace();
                        return true;
                    }
                }
                if (this.isOnline(current.getPlayer())) {
                    this.sendPacket(current);
                }
            }
            return true;
        }
        return false;
    }

    protected abstract void onPacketTimeout(PacketEvent var1);

    private boolean isOnline(Player player) {
        return player != null && player.isOnline();
    }

    private void forceSend() {
        PacketEventHolder holder;
        while ((holder = this.sendingQueue.poll()) != null) {
            this.sendPacket(holder.getEvent());
        }
    }

    public boolean isSynchronizeMain() {
        return this.notThreadSafe;
    }

    private void sendPacket(PacketEvent event) {
        try {
            AsyncMarker marker = event.getAsyncMarker();
            if (marker != null && !marker.isTransmitted()) {
                marker.sendPacket(event);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void cleanupAll() {
        if (!this.cleanedUp) {
            this.forceSend();
            this.cleanedUp = true;
        }
    }
}

