/*
 * Decompiled with CFR 0.152.
 */
package com.comphenix.protocol;

import com.comphenix.protocol.PacketTypeEnum;
import com.comphenix.protocol.PacketTypeLookup;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.events.ConnectionSide;
import com.comphenix.protocol.injector.packet.PacketRegistry;
import com.comphenix.protocol.utility.MinecraftReflection;
import com.comphenix.protocol.utility.MinecraftVersion;
import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import org.apache.commons.lang.WordUtils;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitRunnable;

public class PacketType
implements Serializable,
Cloneable,
Comparable<PacketType> {
    private static final long serialVersionUID = 1L;
    public static final int UNKNOWN_PACKET = -1;
    private static PacketTypeLookup LOOKUP;
    private static final MinecraftVersion PROTOCOL_VERSION;
    private final Protocol protocol;
    private final Sender sender;
    private final int currentId;
    private final MinecraftVersion version;
    private final List<String> classNames;
    String[] names;
    private String name;
    private boolean deprecated;
    private boolean forceAsync;
    private boolean dynamic;
    private int hashCode;
    static Consumer<String> onDynamicCreate;

    private static PacketTypeLookup getLookup() {
        if (LOOKUP == null) {
            LOOKUP = new PacketTypeLookup().addPacketTypes(Handshake.Client.getInstance()).addPacketTypes(Handshake.Server.getInstance()).addPacketTypes(Play.Client.getInstance()).addPacketTypes(Play.Server.getInstance()).addPacketTypes(Status.Client.getInstance()).addPacketTypes(Status.Server.getInstance()).addPacketTypes(Login.Client.getInstance()).addPacketTypes(Login.Server.getInstance());
        }
        return LOOKUP;
    }

    public static Iterable<PacketType> values() {
        ArrayList<PacketTypeEnum> sources = new ArrayList<PacketTypeEnum>();
        sources.add(Handshake.Client.getInstance());
        sources.add(Handshake.Server.getInstance());
        sources.add(Play.Client.getInstance());
        sources.add(Play.Server.getInstance());
        sources.add(Status.Client.getInstance());
        sources.add(Status.Server.getInstance());
        sources.add(Login.Client.getInstance());
        sources.add(Login.Server.getInstance());
        return Iterables.concat(sources);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId) {
        PacketType type = PacketType.getLookup().getFromLegacy(packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static PacketType findLegacy(int packetId, Sender preference) {
        if (preference == null) {
            return PacketType.findLegacy(packetId);
        }
        PacketType type = PacketType.getLookup().getFromLegacy(packetId, preference);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find legacy packet " + packetId);
    }

    @Deprecated
    public static boolean hasLegacy(int packetId) {
        return PacketType.getLookup().getFromLegacy(packetId) != null;
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, int packetId) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + packetId + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    public static PacketType findCurrent(Protocol protocol, Sender sender, String name) {
        name = PacketType.formatClassName(protocol, sender, name);
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, name);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Cannot find packet " + name + "(Protocol: " + (Object)((Object)protocol) + ", Sender: " + (Object)((Object)sender) + ")");
    }

    private static String formatMojangClassName(Protocol protocol, Sender sender, String name) {
        return "net.minecraft.network.protocol." + protocol.getMojangName() + "." + sender.getMojangName() + name + "Packet";
    }

    private static String formatClassName(Protocol protocol, Sender sender, String name) {
        if (MinecraftVersion.CAVES_CLIFFS_1.atOrAbove()) {
            return "net.minecraft.network.protocol." + protocol.getMojangName() + ".Packet" + protocol.getPacketName() + sender.getPacketName() + name;
        }
        String base = MinecraftReflection.getMinecraftPackage() + ".Packet";
        if (name.startsWith(base)) {
            return name;
        }
        if (name.contains("$")) {
            String[] split = name.split("\\$");
            String parent = split[0];
            String child = split[1];
            return base + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)parent) + "$Packet" + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)child);
        }
        return base + protocol.getPacketName() + sender.getPacketName() + WordUtils.capitalize((String)name);
    }

    private static boolean isMcpPacketName(String packetName) {
        return packetName.startsWith("C00") || packetName.startsWith("CPacket") || packetName.startsWith("SPacket");
    }

    private static String formatMcpClassName(Protocol protocol, Sender sender, String name) {
        return "net.minecraft.network." + protocol.getMcpPacketName() + "." + sender.getMcpPacketName() + "." + name;
    }

    public static boolean hasCurrent(Protocol protocol, Sender sender, int packetId) {
        return PacketType.getLookup().getFromCurrent(protocol, sender, packetId) != null;
    }

    public static PacketType fromID(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        PacketType type = PacketType.getLookup().getFromCurrent(protocol, sender, packetId);
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, PROTOCOL_VERSION, packetClass.getName());
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
        }
        return type;
    }

    public static PacketType fromCurrent(Protocol protocol, Sender sender, int packetId, Class<?> packetClass) {
        String className;
        PacketTypeLookup.ClassLookup lookup = PacketType.getLookup().getClassLookup();
        Map<String, PacketType> map = lookup.getMap(protocol, sender);
        PacketType type = PacketType.find(map, className = packetClass.getName());
        if (type == null) {
            type = new PacketType(protocol, sender, packetId, PROTOCOL_VERSION, className);
            type.dynamic = true;
            PacketType.scheduleRegister(type, "Dynamic-" + UUID.randomUUID().toString());
            onDynamicCreate.accept(className);
        }
        return type;
    }

    private static PacketType find(Map<String, PacketType> map, String clazz) {
        PacketType ret = map.get(clazz);
        if (ret != null) {
            return ret;
        }
        for (PacketType check : map.values()) {
            List<String> aliases = check.getClassNames();
            if (aliases.size() <= 1) continue;
            for (String alias : aliases) {
                if (!alias.equals(clazz)) continue;
                return check;
            }
        }
        return null;
    }

    public static PacketType fromClass(Class<?> packetClass) {
        PacketType type = PacketRegistry.getPacketType(packetClass);
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Class " + packetClass + " is not a registered packet.");
    }

    public static Collection<PacketType> fromName(String name) {
        return PacketType.getLookup().getFromName(name);
    }

    @Deprecated
    public static boolean hasClass(Class<?> packetClass) {
        return PacketRegistry.getPacketType(packetClass) != null;
    }

    public static void scheduleRegister(final PacketType type, final String name) {
        BukkitRunnable runnable = new BukkitRunnable(){

            public void run() {
                PacketTypeEnum objEnum = PacketType.getObjectEnum(type);
                if (objEnum.registerMember(type, name)) {
                    PacketType.getLookup().addPacketTypes(Collections.singletonList(type));
                }
            }
        };
        if (Bukkit.getServer() == null || Bukkit.isPrimaryThread()) {
            try {
                runnable.run();
            }
            catch (Exception exception) {}
        } else {
            runnable.runTaskLater(ProtocolLibrary.getPlugin(), 0L);
        }
    }

    public static PacketTypeEnum getObjectEnum(PacketType type) {
        switch (type.getProtocol()) {
            case HANDSHAKING: {
                return type.isClient() ? Handshake.Client.getInstance() : Handshake.Server.getInstance();
            }
            case PLAY: {
                return type.isClient() ? Play.Client.getInstance() : Play.Server.getInstance();
            }
            case STATUS: {
                return type.isClient() ? Status.Client.getInstance() : Status.Server.getInstance();
            }
            case LOGIN: {
                return type.isClient() ? Login.Client.getInstance() : Login.Server.getInstance();
            }
        }
        throw new IllegalStateException("Unexpected protocol: " + (Object)((Object)type.getProtocol()));
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, String ... names) {
        this(protocol, sender, currentId, PROTOCOL_VERSION, names);
    }

    public PacketType(Protocol protocol, Sender sender, int currentId, MinecraftVersion version, String ... names) {
        this.protocol = (Protocol)((Object)Preconditions.checkNotNull((Object)((Object)protocol), (Object)"protocol cannot be NULL"));
        this.sender = (Sender)((Object)Preconditions.checkNotNull((Object)((Object)sender), (Object)"sender cannot be NULL"));
        this.currentId = currentId;
        this.version = version;
        this.classNames = new ArrayList<String>();
        for (int i = 0; i < names.length; ++i) {
            if (PacketType.isMcpPacketName(names[i])) {
                this.classNames.add(PacketType.formatMcpClassName(protocol, sender, names[i]));
                continue;
            }
            this.classNames.add(PacketType.formatClassName(protocol, sender, names[i]));
            this.classNames.add(PacketType.formatMojangClassName(protocol, sender, names[i]));
        }
        this.names = names;
    }

    public boolean isSupported() {
        return PacketRegistry.isSupported(this);
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Sender getSender() {
        return this.sender;
    }

    public boolean isClient() {
        return this.sender == Sender.CLIENT;
    }

    public boolean isServer() {
        return this.sender == Sender.SERVER;
    }

    @Deprecated
    public int getCurrentId() {
        return this.currentId;
    }

    public List<String> getClassNames() {
        return this.classNames;
    }

    public Class<?> getPacketClass() {
        return PacketRegistry.tryGetPacketClass(this).orElse(null);
    }

    void setName(String name) {
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    void setDeprecated() {
        this.deprecated = true;
    }

    public boolean isDeprecated() {
        return this.deprecated;
    }

    void forceAsync() {
        this.forceAsync = true;
    }

    public boolean isAsyncForced() {
        return this.forceAsync;
    }

    public MinecraftVersion getCurrentVersion() {
        return this.version;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public int hashCode() {
        int hash = this.hashCode;
        if (hash == 0) {
            hash = this.protocol.hashCode();
            hash = 31 * hash + this.sender.hashCode();
            this.hashCode = hash = 31 * hash + Integer.hashCode(this.currentId);
        }
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof PacketType) {
            PacketType other = (PacketType)obj;
            return this.protocol == other.protocol && this.sender == other.sender && this.currentId == other.currentId;
        }
        return false;
    }

    @Override
    public int compareTo(PacketType other) {
        return ComparisonChain.start().compare((Comparable)((Object)this.protocol), (Comparable)((Object)other.getProtocol())).compare((Comparable)((Object)this.sender), (Comparable)((Object)other.getSender())).compare(this.currentId, other.getCurrentId()).result();
    }

    public String toString() {
        Class<?> clazz = this.getPacketClass();
        if (clazz == null) {
            return this.name() + "[" + (Object)((Object)this.protocol) + ", " + (Object)((Object)this.sender) + ", " + this.currentId + ", classNames: " + this.classNames + " (unregistered)]";
        }
        return this.name() + "[class=" + clazz.getSimpleName() + ", id=" + this.currentId + "]";
    }

    public PacketType clone() {
        try {
            return (PacketType)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("This shouldn't happen", ex);
        }
    }

    static {
        PROTOCOL_VERSION = MinecraftVersion.LATEST;
        onDynamicCreate = x -> {};
    }

    public static class Handshake {
        static final Protocol PROTOCOL = Protocol.HANDSHAKING;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Server getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            @ForceAsync
            public static final PacketType SET_PROTOCOL = new PacketType(PROTOCOL, SENDER, 0, "SetProtocol", "C00Handshake");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Client getInstance() {
                return INSTANCE;
            }

            public static Sender getSender() {
                return SENDER;
            }
        }
    }

    public static class Play {
        static final Protocol PROTOCOL = Protocol.PLAY;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType TELEPORT_ACCEPT = new PacketType(PROTOCOL, SENDER, 0, "TeleportAccept", "CPacketConfirmTeleport");
            public static final PacketType TILE_NBT_QUERY = new PacketType(PROTOCOL, SENDER, 1, "TileNBTQuery");
            public static final PacketType DIFFICULTY_CHANGE = new PacketType(PROTOCOL, SENDER, 2, "DifficultyChange");
            public static final PacketType CHAT_ACK = new PacketType(PROTOCOL, SENDER, 3, "ChatAck");
            public static final PacketType CHAT_COMMAND = new PacketType(PROTOCOL, SENDER, 4, "ChatCommand");
            public static final PacketType CHAT = new PacketType(PROTOCOL, SENDER, 5, "Chat", "CPacketChatMessage");
            public static final PacketType CHAT_SESSION_UPDATE = new PacketType(PROTOCOL, SENDER, 6, "ChatSessionUpdate");
            public static final PacketType CLIENT_COMMAND = new PacketType(PROTOCOL, SENDER, 7, "ClientCommand", "CPacketClientStatus");
            public static final PacketType SETTINGS = new PacketType(PROTOCOL, SENDER, 8, "Settings", "CPacketClientSettings");
            public static final PacketType TAB_COMPLETE = new PacketType(PROTOCOL, SENDER, 9, "TabComplete", "CPacketTabComplete");
            public static final PacketType ENCHANT_ITEM = new PacketType(PROTOCOL, SENDER, 10, "EnchantItem", "CPacketEnchantItem");
            public static final PacketType WINDOW_CLICK = new PacketType(PROTOCOL, SENDER, 11, "WindowClick", "CPacketClickWindow");
            public static final PacketType CLOSE_WINDOW = new PacketType(PROTOCOL, SENDER, 12, "CloseWindow", "CPacketCloseWindow");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(PROTOCOL, SENDER, 13, "CustomPayload", "CPacketCustomPayload");
            public static final PacketType B_EDIT = new PacketType(PROTOCOL, SENDER, 14, "BEdit");
            public static final PacketType ENTITY_NBT_QUERY = new PacketType(PROTOCOL, SENDER, 15, "EntityNBTQuery");
            public static final PacketType USE_ENTITY = new PacketType(PROTOCOL, SENDER, 16, "UseEntity", "CPacketUseEntity");
            public static final PacketType JIGSAW_GENERATE = new PacketType(PROTOCOL, SENDER, 17, "JigsawGenerate");
            public static final PacketType KEEP_ALIVE = new PacketType(PROTOCOL, SENDER, 18, "KeepAlive", "CPacketKeepAlive");
            public static final PacketType DIFFICULTY_LOCK = new PacketType(PROTOCOL, SENDER, 19, "DifficultyLock");
            public static final PacketType POSITION = new PacketType(PROTOCOL, SENDER, 20, "Flying$Position", "Flying$PacketPlayInPosition", "CPacketPlayer$Position");
            public static final PacketType POSITION_LOOK = new PacketType(PROTOCOL, SENDER, 21, "Flying$PositionLook", "Flying$PacketPlayInPositionLook", "CPacketPlayer$PositionRotation");
            public static final PacketType LOOK = new PacketType(PROTOCOL, SENDER, 22, "Flying$Look", "Flying$PacketPlayInLook", "CPacketPlayer$Rotation");
            public static final PacketType GROUND = new PacketType(PROTOCOL, SENDER, 23, "Flying$d");
            public static final PacketType VEHICLE_MOVE = new PacketType(PROTOCOL, SENDER, 24, "VehicleMove", "CPacketVehicleMove");
            public static final PacketType BOAT_MOVE = new PacketType(PROTOCOL, SENDER, 25, "BoatMove", "CPacketSteerBoat");
            public static final PacketType PICK_ITEM = new PacketType(PROTOCOL, SENDER, 26, "PickItem");
            public static final PacketType AUTO_RECIPE = new PacketType(PROTOCOL, SENDER, 27, "AutoRecipe", "CPacketPlaceRecipe");
            public static final PacketType ABILITIES = new PacketType(PROTOCOL, SENDER, 28, "Abilities", "CPacketPlayerAbilities");
            public static final PacketType BLOCK_DIG = new PacketType(PROTOCOL, SENDER, 29, "BlockDig", "CPacketPlayerDigging");
            public static final PacketType ENTITY_ACTION = new PacketType(PROTOCOL, SENDER, 30, "EntityAction", "CPacketEntityAction");
            public static final PacketType STEER_VEHICLE = new PacketType(PROTOCOL, SENDER, 31, "SteerVehicle", "CPacketInput");
            public static final PacketType PONG = new PacketType(PROTOCOL, SENDER, 32, "Pong");
            public static final PacketType RECIPE_SETTINGS = new PacketType(PROTOCOL, SENDER, 33, "RecipeSettings");
            public static final PacketType RECIPE_DISPLAYED = new PacketType(PROTOCOL, SENDER, 34, "RecipeDisplayed", "CPacketRecipeInfo");
            public static final PacketType ITEM_NAME = new PacketType(PROTOCOL, SENDER, 35, "ItemName");
            public static final PacketType RESOURCE_PACK_STATUS = new PacketType(PROTOCOL, SENDER, 36, "ResourcePackStatus", "CPacketResourcePackStatus");
            public static final PacketType ADVANCEMENTS = new PacketType(PROTOCOL, SENDER, 37, "Advancements", "CPacketSeenAdvancements");
            public static final PacketType TR_SEL = new PacketType(PROTOCOL, SENDER, 38, "TrSel");
            public static final PacketType BEACON = new PacketType(PROTOCOL, SENDER, 39, "Beacon");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(PROTOCOL, SENDER, 40, "HeldItemSlot", "CPacketHeldItemChange");
            public static final PacketType SET_COMMAND_BLOCK = new PacketType(PROTOCOL, SENDER, 41, "SetCommandBlock");
            public static final PacketType SET_COMMAND_MINECART = new PacketType(PROTOCOL, SENDER, 42, "SetCommandMinecart");
            public static final PacketType SET_CREATIVE_SLOT = new PacketType(PROTOCOL, SENDER, 43, "SetCreativeSlot", "CPacketCreativeInventoryAction");
            public static final PacketType SET_JIGSAW = new PacketType(PROTOCOL, SENDER, 44, "SetJigsaw");
            public static final PacketType STRUCT = new PacketType(PROTOCOL, SENDER, 45, "Struct");
            public static final PacketType UPDATE_SIGN = new PacketType(PROTOCOL, SENDER, 46, "UpdateSign", "CPacketUpdateSign");
            public static final PacketType ARM_ANIMATION = new PacketType(PROTOCOL, SENDER, 47, "ArmAnimation", "CPacketAnimation");
            public static final PacketType SPECTATE = new PacketType(PROTOCOL, SENDER, 48, "Spectate", "CPacketSpectate");
            public static final PacketType USE_ITEM = new PacketType(PROTOCOL, SENDER, 49, "UseItem", "CPacketPlayerTryUseItemOnBlock");
            public static final PacketType BLOCK_PLACE = new PacketType(PROTOCOL, SENDER, 50, "BlockPlace", "CPacketPlayerTryUseItem");
            @Deprecated
            public static final PacketType TRANSACTION = new PacketType(PROTOCOL, SENDER, 255, "Transaction", "CPacketConfirmTransaction");
            @Deprecated
            public static final PacketType FLYING = new PacketType(PROTOCOL, SENDER, 254, "Flying", "CPacketPlayer");
            @Deprecated
            public static final PacketType CHAT_PREVIEW = new PacketType(PROTOCOL, SENDER, 6, "ChatPreview");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            public static final PacketType BUNDLE = new PacketType(PROTOCOL, SENDER, 0, "Delimiter", "BundleDelimiterPacket");
            public static final PacketType SPAWN_ENTITY = new PacketType(PROTOCOL, SENDER, 1, "SpawnEntity", "SPacketSpawnObject");
            public static final PacketType SPAWN_ENTITY_EXPERIENCE_ORB = new PacketType(PROTOCOL, SENDER, 2, "SpawnEntityExperienceOrb", "SPacketSpawnExperienceOrb");
            public static final PacketType NAMED_ENTITY_SPAWN = new PacketType(PROTOCOL, SENDER, 3, "NamedEntitySpawn", "SPacketSpawnPlayer");
            public static final PacketType ANIMATION = new PacketType(PROTOCOL, SENDER, 4, "Animation", "SPacketAnimation");
            public static final PacketType STATISTIC = new PacketType(PROTOCOL, SENDER, 5, "Statistic", "SPacketStatistics");
            public static final PacketType BLOCK_CHANGED_ACK = new PacketType(PROTOCOL, SENDER, 6, "BlockChangedAck");
            public static final PacketType BLOCK_BREAK_ANIMATION = new PacketType(PROTOCOL, SENDER, 7, "BlockBreakAnimation", "SPacketBlockBreakAnim");
            public static final PacketType TILE_ENTITY_DATA = new PacketType(PROTOCOL, SENDER, 8, "TileEntityData", "SPacketUpdateTileEntity");
            public static final PacketType BLOCK_ACTION = new PacketType(PROTOCOL, SENDER, 9, "BlockAction", "SPacketBlockAction");
            public static final PacketType BLOCK_CHANGE = new PacketType(PROTOCOL, SENDER, 10, "BlockChange", "SPacketBlockChange");
            public static final PacketType BOSS = new PacketType(PROTOCOL, SENDER, 11, "Boss", "SPacketUpdateBossInfo");
            public static final PacketType SERVER_DIFFICULTY = new PacketType(PROTOCOL, SENDER, 12, "ServerDifficulty", "SPacketServerDifficulty");
            public static final PacketType CHUNKS_BIOMES = new PacketType(PROTOCOL, SENDER, 13, "ChunksBiomes", "ClientboundChunksBiomesPacket");
            public static final PacketType CLEAR_TITLES = new PacketType(PROTOCOL, SENDER, 14, "ClearTitles");
            public static final PacketType TAB_COMPLETE = new PacketType(PROTOCOL, SENDER, 15, "TabComplete", "SPacketTabComplete");
            public static final PacketType COMMANDS = new PacketType(PROTOCOL, SENDER, 16, "Commands");
            public static final PacketType CLOSE_WINDOW = new PacketType(PROTOCOL, SENDER, 17, "CloseWindow", "SPacketCloseWindow");
            public static final PacketType WINDOW_ITEMS = new PacketType(PROTOCOL, SENDER, 18, "WindowItems", "SPacketWindowItems");
            public static final PacketType WINDOW_DATA = new PacketType(PROTOCOL, SENDER, 19, "WindowData", "SPacketWindowProperty");
            public static final PacketType SET_SLOT = new PacketType(PROTOCOL, SENDER, 20, "SetSlot", "SPacketSetSlot");
            public static final PacketType SET_COOLDOWN = new PacketType(PROTOCOL, SENDER, 21, "SetCooldown", "SPacketCooldown");
            public static final PacketType CUSTOM_CHAT_COMPLETIONS = new PacketType(PROTOCOL, SENDER, 22, "CustomChatCompletions");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(PROTOCOL, SENDER, 23, "CustomPayload", "SPacketCustomPayload");
            public static final PacketType DAMAGE_EVENT = new PacketType(PROTOCOL, SENDER, 24, "DamageEvent", "ClientboundDamageEventPacket");
            public static final PacketType DELETE_CHAT_MESSAGE = new PacketType(PROTOCOL, SENDER, 25, "DeleteChat");
            public static final PacketType KICK_DISCONNECT = new PacketType(PROTOCOL, SENDER, 26, "KickDisconnect", "SPacketDisconnect");
            public static final PacketType DISGUISED_CHAT = new PacketType(PROTOCOL, SENDER, 27, "DisguisedChat");
            public static final PacketType ENTITY_STATUS = new PacketType(PROTOCOL, SENDER, 28, "EntityStatus", "SPacketEntityStatus");
            public static final PacketType EXPLOSION = new PacketType(PROTOCOL, SENDER, 29, "Explosion", "SPacketExplosion");
            public static final PacketType UNLOAD_CHUNK = new PacketType(PROTOCOL, SENDER, 30, "UnloadChunk", "SPacketUnloadChunk");
            public static final PacketType GAME_STATE_CHANGE = new PacketType(PROTOCOL, SENDER, 31, "GameStateChange", "SPacketChangeGameState");
            public static final PacketType OPEN_WINDOW_HORSE = new PacketType(PROTOCOL, SENDER, 32, "OpenWindowHorse");
            public static final PacketType HURT_ANIMATION = new PacketType(PROTOCOL, SENDER, 33, "HurtAnimation", "ClientboundHurtAnimationPacket");
            public static final PacketType INITIALIZE_BORDER = new PacketType(PROTOCOL, SENDER, 34, "InitializeBorder");
            public static final PacketType KEEP_ALIVE = new PacketType(PROTOCOL, SENDER, 35, "KeepAlive", "SPacketKeepAlive");
            public static final PacketType MAP_CHUNK = new PacketType(PROTOCOL, SENDER, 36, "LevelChunkWithLight", "MapChunk", "SPacketChunkData");
            public static final PacketType WORLD_EVENT = new PacketType(PROTOCOL, SENDER, 37, "WorldEvent", "SPacketEffect");
            public static final PacketType WORLD_PARTICLES = new PacketType(PROTOCOL, SENDER, 38, "WorldParticles", "SPacketParticles");
            public static final PacketType LIGHT_UPDATE = new PacketType(PROTOCOL, SENDER, 39, "LightUpdate");
            public static final PacketType LOGIN = new PacketType(PROTOCOL, SENDER, 40, "Login", "SPacketJoinGame");
            public static final PacketType MAP = new PacketType(PROTOCOL, SENDER, 41, "Map", "SPacketMaps");
            public static final PacketType OPEN_WINDOW_MERCHANT = new PacketType(PROTOCOL, SENDER, 42, "OpenWindowMerchant");
            public static final PacketType REL_ENTITY_MOVE = new PacketType(PROTOCOL, SENDER, 43, "Entity$RelEntityMove", "Entity$PacketPlayOutRelEntityMove");
            public static final PacketType REL_ENTITY_MOVE_LOOK = new PacketType(PROTOCOL, SENDER, 44, "Entity$RelEntityMoveLook", "Entity$PacketPlayOutRelEntityMoveLook");
            public static final PacketType ENTITY_LOOK = new PacketType(PROTOCOL, SENDER, 45, "Entity$EntityLook", "Entity$PacketPlayOutEntityLook");
            public static final PacketType VEHICLE_MOVE = new PacketType(PROTOCOL, SENDER, 46, "VehicleMove", "SPacketMoveVehicle");
            public static final PacketType OPEN_BOOK = new PacketType(PROTOCOL, SENDER, 47, "OpenBook");
            public static final PacketType OPEN_WINDOW = new PacketType(PROTOCOL, SENDER, 48, "OpenWindow", "SPacketOpenWindow");
            public static final PacketType OPEN_SIGN_EDITOR = new PacketType(PROTOCOL, SENDER, 49, "OpenSignEditor", "SPacketSignEditorOpen");
            public static final PacketType PING = new PacketType(PROTOCOL, SENDER, 50, "Ping");
            public static final PacketType AUTO_RECIPE = new PacketType(PROTOCOL, SENDER, 51, "AutoRecipe", "SPacketPlaceGhostRecipe");
            public static final PacketType ABILITIES = new PacketType(PROTOCOL, SENDER, 52, "Abilities", "SPacketPlayerAbilities");
            public static final PacketType CHAT = new PacketType(PROTOCOL, SENDER, 53, "PlayerChat", "Chat", "SPacketChat");
            public static final PacketType PLAYER_COMBAT_END = new PacketType(PROTOCOL, SENDER, 54, "PlayerCombatEnd");
            public static final PacketType PLAYER_COMBAT_ENTER = new PacketType(PROTOCOL, SENDER, 55, "PlayerCombatEnter");
            public static final PacketType PLAYER_COMBAT_KILL = new PacketType(PROTOCOL, SENDER, 56, "PlayerCombatKill");
            public static final PacketType PLAYER_INFO_REMOVE = new PacketType(PROTOCOL, SENDER, 57, "PlayerInfoRemove");
            public static final PacketType PLAYER_INFO = new PacketType(PROTOCOL, SENDER, 58, "PlayerInfoUpdate", "PlayerInfo");
            public static final PacketType LOOK_AT = new PacketType(PROTOCOL, SENDER, 59, "LookAt", "SPacketPlayerPosLook");
            public static final PacketType POSITION = new PacketType(PROTOCOL, SENDER, 60, "Position");
            public static final PacketType RECIPES = new PacketType(PROTOCOL, SENDER, 61, "Recipes", "SPacketRecipeBook");
            public static final PacketType ENTITY_DESTROY = new PacketType(PROTOCOL, SENDER, 62, "EntityDestroy", "SPacketDestroyEntities");
            public static final PacketType REMOVE_ENTITY_EFFECT = new PacketType(PROTOCOL, SENDER, 63, "RemoveEntityEffect", "SPacketRemoveEntityEffect");
            public static final PacketType RESOURCE_PACK_SEND = new PacketType(PROTOCOL, SENDER, 64, "ResourcePackSend", "SPacketResourcePackSend");
            public static final PacketType RESPAWN = new PacketType(PROTOCOL, SENDER, 65, "Respawn", "SPacketRespawn");
            public static final PacketType ENTITY_HEAD_ROTATION = new PacketType(PROTOCOL, SENDER, 66, "EntityHeadRotation", "SPacketEntityHeadLook");
            public static final PacketType MULTI_BLOCK_CHANGE = new PacketType(PROTOCOL, SENDER, 67, "MultiBlockChange", "SPacketMultiBlockChange");
            public static final PacketType SELECT_ADVANCEMENT_TAB = new PacketType(PROTOCOL, SENDER, 68, "SelectAdvancementTab", "SPacketSelectAdvancementsTab");
            public static final PacketType SERVER_DATA = new PacketType(PROTOCOL, SENDER, 69, "ServerData");
            public static final PacketType SET_ACTION_BAR_TEXT = new PacketType(PROTOCOL, SENDER, 70, "SetActionBarText");
            public static final PacketType SET_BORDER_CENTER = new PacketType(PROTOCOL, SENDER, 71, "SetBorderCenter");
            public static final PacketType SET_BORDER_LERP_SIZE = new PacketType(PROTOCOL, SENDER, 72, "SetBorderLerpSize");
            public static final PacketType SET_BORDER_SIZE = new PacketType(PROTOCOL, SENDER, 73, "SetBorderSize");
            public static final PacketType SET_BORDER_WARNING_DELAY = new PacketType(PROTOCOL, SENDER, 74, "SetBorderWarningDelay");
            public static final PacketType SET_BORDER_WARNING_DISTANCE = new PacketType(PROTOCOL, SENDER, 75, "SetBorderWarningDistance");
            public static final PacketType CAMERA = new PacketType(PROTOCOL, SENDER, 76, "Camera", "SPacketCamera");
            public static final PacketType HELD_ITEM_SLOT = new PacketType(PROTOCOL, SENDER, 77, "HeldItemSlot", "SPacketHeldItemChange");
            public static final PacketType VIEW_CENTRE = new PacketType(PROTOCOL, SENDER, 78, "ViewCentre");
            public static final PacketType VIEW_DISTANCE = new PacketType(PROTOCOL, SENDER, 79, "ViewDistance");
            public static final PacketType SPAWN_POSITION = new PacketType(PROTOCOL, SENDER, 80, "SpawnPosition", "SPacketSpawnPosition");
            public static final PacketType SCOREBOARD_DISPLAY_OBJECTIVE = new PacketType(PROTOCOL, SENDER, 81, "ScoreboardDisplayObjective", "SPacketDisplayObjective");
            public static final PacketType ENTITY_METADATA = new PacketType(PROTOCOL, SENDER, 82, "EntityMetadata", "SPacketEntityMetadata");
            public static final PacketType ATTACH_ENTITY = new PacketType(PROTOCOL, SENDER, 83, "AttachEntity", "SPacketEntityAttach");
            public static final PacketType ENTITY_VELOCITY = new PacketType(PROTOCOL, SENDER, 84, "EntityVelocity", "SPacketEntityVelocity");
            public static final PacketType ENTITY_EQUIPMENT = new PacketType(PROTOCOL, SENDER, 85, "EntityEquipment", "SPacketEntityEquipment");
            public static final PacketType EXPERIENCE = new PacketType(PROTOCOL, SENDER, 86, "Experience", "SPacketSetExperience");
            public static final PacketType UPDATE_HEALTH = new PacketType(PROTOCOL, SENDER, 87, "UpdateHealth", "SPacketUpdateHealth");
            public static final PacketType SCOREBOARD_OBJECTIVE = new PacketType(PROTOCOL, SENDER, 88, "ScoreboardObjective", "SPacketScoreboardObjective");
            public static final PacketType MOUNT = new PacketType(PROTOCOL, SENDER, 89, "Mount", "SPacketSetPassengers");
            public static final PacketType SCOREBOARD_TEAM = new PacketType(PROTOCOL, SENDER, 90, "ScoreboardTeam", "SPacketTeams");
            public static final PacketType SCOREBOARD_SCORE = new PacketType(PROTOCOL, SENDER, 91, "ScoreboardScore", "SPacketUpdateScore");
            public static final PacketType UPDATE_SIMULATION_DISTANCE = new PacketType(PROTOCOL, SENDER, 92, "SetSimulationDistance");
            public static final PacketType SET_SUBTITLE_TEXT = new PacketType(PROTOCOL, SENDER, 93, "SetSubtitleText");
            public static final PacketType UPDATE_TIME = new PacketType(PROTOCOL, SENDER, 94, "UpdateTime", "SPacketTimeUpdate");
            public static final PacketType SET_TITLE_TEXT = new PacketType(PROTOCOL, SENDER, 95, "SetTitleText");
            public static final PacketType SET_TITLES_ANIMATION = new PacketType(PROTOCOL, SENDER, 96, "SetTitlesAnimation");
            public static final PacketType ENTITY_SOUND = new PacketType(PROTOCOL, SENDER, 97, "EntitySound", "SPacketSoundEffect");
            public static final PacketType NAMED_SOUND_EFFECT = new PacketType(PROTOCOL, SENDER, 98, "NamedSoundEffect");
            public static final PacketType STOP_SOUND = new PacketType(PROTOCOL, SENDER, 99, "StopSound");
            public static final PacketType SYSTEM_CHAT = new PacketType(PROTOCOL, SENDER, 100, "SystemChat");
            public static final PacketType PLAYER_LIST_HEADER_FOOTER = new PacketType(PROTOCOL, SENDER, 101, "PlayerListHeaderFooter", "SPacketPlayerListHeaderFooter");
            public static final PacketType NBT_QUERY = new PacketType(PROTOCOL, SENDER, 102, "NBTQuery");
            public static final PacketType COLLECT = new PacketType(PROTOCOL, SENDER, 103, "Collect", "SPacketCollectItem");
            public static final PacketType ENTITY_TELEPORT = new PacketType(PROTOCOL, SENDER, 104, "EntityTeleport", "SPacketEntityTeleport");
            public static final PacketType ADVANCEMENTS = new PacketType(PROTOCOL, SENDER, 105, "Advancements", "SPacketAdvancementInfo");
            public static final PacketType UPDATE_ATTRIBUTES = new PacketType(PROTOCOL, SENDER, 106, "UpdateAttributes", "SPacketEntityProperties");
            public static final PacketType UPDATE_ENABLED_FEATURES = new PacketType(PROTOCOL, SENDER, 107, "UpdateEnabledFeatures");
            public static final PacketType ENTITY_EFFECT = new PacketType(PROTOCOL, SENDER, 108, "EntityEffect", "SPacketEntityEffect");
            public static final PacketType RECIPE_UPDATE = new PacketType(PROTOCOL, SENDER, 109, "RecipeUpdate");
            public static final PacketType TAGS = new PacketType(PROTOCOL, SENDER, 110, "Tags");
            @Deprecated
            public static final PacketType MAP_CHUNK_BULK = new PacketType(PROTOCOL, SENDER, 255, "MapChunkBulk");
            @Deprecated
            public static final PacketType SET_COMPRESSION = new PacketType(PROTOCOL, SENDER, 254, "SetCompression");
            @Deprecated
            public static final PacketType UPDATE_ENTITY_NBT = new PacketType(PROTOCOL, SENDER, 253, "UpdateEntityNBT");
            @Deprecated
            public static final PacketType CRAFT_PROGRESS_BAR = WINDOW_DATA.clone();
            @Deprecated
            public static final PacketType ENTITY_MOVE_LOOK = REL_ENTITY_MOVE_LOOK.clone();
            @Deprecated
            public static final PacketType STATISTICS = STATISTIC.clone();
            @Deprecated
            public static final PacketType OPEN_SIGN_ENTITY = OPEN_SIGN_EDITOR.clone();
            @Deprecated
            public static final PacketType UPDATE_SIGN = MinecraftReflection.signUpdateExists() ? new PacketType(PROTOCOL, SENDER, 252, "UpdateSign") : TILE_ENTITY_DATA.clone();
            @Deprecated
            public static final PacketType BED = new PacketType(PROTOCOL, SENDER, 251, "Bed", "SPacketUseBed");
            @Deprecated
            public static final PacketType USE_BED = BED.clone();
            @Deprecated
            public static final PacketType SPAWN_ENTITY_WEATHER = new PacketType(PROTOCOL, SENDER, 250, "SpawnEntityWeather", "SPacketSpawnGlobalEntity");
            @Deprecated
            public static final PacketType TITLE = new PacketType(PROTOCOL, SENDER, 249, "Title");
            @Deprecated
            public static final PacketType WORLD_BORDER = new PacketType(PROTOCOL, SENDER, 248, "WorldBorder");
            @Deprecated
            public static final PacketType COMBAT_EVENT = new PacketType(PROTOCOL, SENDER, 247, "CombatEvent");
            @Deprecated
            public static final PacketType TRANSACTION = new PacketType(PROTOCOL, SENDER, 246, "Transaction", "SPacketConfirmTransaction");
            @Deprecated
            public static final PacketType ENTITY = new PacketType(PROTOCOL, SENDER, 245, "Entity", "SPacketEntity");
            @Deprecated
            public static final PacketType SPAWN_ENTITY_LIVING = new PacketType(PROTOCOL, SENDER, 244, "SpawnEntityLiving", "SPacketSpawnMob");
            @Deprecated
            public static final PacketType SPAWN_ENTITY_PAINTING = new PacketType(PROTOCOL, SENDER, 243, "SpawnEntityPainting", "SPacketSpawnPainting");
            @Deprecated
            public static final PacketType ADD_VIBRATION_SIGNAL = new PacketType(PROTOCOL, SENDER, 242, "AddVibrationSignal");
            @Deprecated
            public static final PacketType BLOCK_BREAK = new PacketType(PROTOCOL, SENDER, 241, "BlockBreak");
            @Deprecated
            public static final PacketType CHAT_PREVIEW = new PacketType(PROTOCOL, SENDER, 12, "ChatPreview");
            @Deprecated
            public static final PacketType PLAYER_CHAT_HEADER = new PacketType(PROTOCOL, SENDER, 50, "PlayerChatHeader");
            @Deprecated
            public static final PacketType SET_DISPLAY_CHAT_PREVIEW = new PacketType(PROTOCOL, SENDER, 78, "SetDisplayChatPreview");
            @Deprecated
            public static final PacketType CUSTOM_SOUND_EFFECT = new PacketType(PROTOCOL, SENDER, 22, "CustomSoundEffect", "SPacketCustomSound");
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Status {
        static final Protocol PROTOCOL = Protocol.STATUS;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(PROTOCOL, SENDER, 0, "Start", "CPacketServerQuery");
            @ForceAsync
            public static final PacketType PING = new PacketType(PROTOCOL, SENDER, 1, "Ping", "CPacketPing");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            @ForceAsync
            public static final PacketType SERVER_INFO = new PacketType(PROTOCOL, SENDER, 0, "ServerInfo", "SPacketServerInfo");
            @ForceAsync
            public static final PacketType PONG = new PacketType(PROTOCOL, SENDER, 1, "Pong", "SPacketPong");
            @Deprecated
            @ForceAsync
            public static final PacketType OUT_SERVER_INFO = SERVER_INFO.clone();
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static class Login {
        static final Protocol PROTOCOL = Protocol.LOGIN;

        public static Protocol getProtocol() {
            return PROTOCOL;
        }

        public static class Client
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.CLIENT;
            public static final PacketType START = new PacketType(PROTOCOL, SENDER, 0, "Start", "CPacketLoginStart");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(PROTOCOL, SENDER, 1, "EncryptionBegin", "CPacketEncryptionResponse");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(PROTOCOL, SENDER, 2, "CustomPayload", "CPacketCustomPayload");
            private static final Client INSTANCE = new Client();

            private Client() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Client getInstance() {
                return INSTANCE;
            }
        }

        public static class Server
        extends PacketTypeEnum {
            private static final Sender SENDER = Sender.SERVER;
            @ForceAsync
            public static final PacketType DISCONNECT = new PacketType(PROTOCOL, SENDER, 0, "Disconnect", "SPacketDisconnect");
            public static final PacketType ENCRYPTION_BEGIN = new PacketType(PROTOCOL, SENDER, 1, "EncryptionBegin", "SPacketEncryptionRequest");
            public static final PacketType SUCCESS = new PacketType(PROTOCOL, SENDER, 2, "Success", "SPacketLoginSuccess");
            public static final PacketType SET_COMPRESSION = new PacketType(PROTOCOL, SENDER, 3, "SetCompression", "SPacketEnableCompression");
            public static final PacketType CUSTOM_PAYLOAD = new PacketType(PROTOCOL, SENDER, 4, "CustomPayload", "SPacketCustomPayload");
            private static final Server INSTANCE = new Server();

            private Server() {
            }

            public static Sender getSender() {
                return SENDER;
            }

            public static Server getInstance() {
                return INSTANCE;
            }
        }
    }

    public static enum Sender {
        CLIENT("Serverbound", "In", "client"),
        SERVER("Clientbound", "Out", "server");

        private String mojangName;
        private String packetName;
        private String mcpName;

        private Sender(String mojangName, String packetName, String mcpName) {
            this.mojangName = mojangName;
            this.packetName = packetName;
            this.mcpName = mcpName;
        }

        public ConnectionSide toSide() {
            return this == CLIENT ? ConnectionSide.CLIENT_SIDE : ConnectionSide.SERVER_SIDE;
        }

        public String getPacketName() {
            return this.packetName;
        }

        public String getMcpPacketName() {
            return this.mcpName;
        }

        public String getMojangName() {
            return this.mojangName;
        }
    }

    public static enum Protocol {
        HANDSHAKING("Handshaking", "handshake"),
        PLAY("Play", "game"),
        STATUS("Status", "status"),
        LOGIN("Login", "login"),
        LEGACY("", "");

        private String packetName;
        private String mojangName;

        private Protocol(String packetName, String mojangName) {
            this.packetName = packetName;
            this.mojangName = mojangName;
        }

        public static Protocol fromVanilla(Enum<?> vanilla) {
            String name = vanilla.name();
            if ("HANDSHAKING".equals(name)) {
                return HANDSHAKING;
            }
            if ("PLAY".equals(name)) {
                return PLAY;
            }
            if ("STATUS".equals(name)) {
                return STATUS;
            }
            if ("LOGIN".equals(name)) {
                return LOGIN;
            }
            throw new IllegalArgumentException("Unrecognized vanilla enum " + vanilla);
        }

        public String getPacketName() {
            return this.packetName;
        }

        public String getMojangName() {
            return this.mojangName;
        }

        public String getMcpPacketName() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ForceAsync {
    }
}

