/*
 * Decompiled with CFR 0.152.
 */
package com.extendedclip.deluxemenus.utils;

import com.extendedclip.deluxemenus.DeluxeMenus;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.reflect.Field;
import java.util.Base64;
import java.util.UUID;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.jetbrains.annotations.NotNull;

public class SkullUtils {
    @NotNull
    public static String getEncoded(@NotNull String url) {
        byte[] encodedData = Base64.getEncoder().encode(String.format("{textures:{SKIN:{url:\"%s\"}}}", "https://textures.minecraft.net/texture/" + url).getBytes());
        return new String(encodedData);
    }

    @NotNull
    public static ItemStack getSkull(@NotNull String skinUrl) {
        ItemStack head = DeluxeMenus.getInstance().getHead().clone();
        if (skinUrl.isEmpty()) {
            return head;
        }
        SkullMeta headMeta = (SkullMeta)head.getItemMeta();
        if (headMeta == null) {
            return head;
        }
        GameProfile profile = SkullUtils.getGameProfile(skinUrl);
        try {
            Field profileField = headMeta.getClass().getDeclaredField("profile");
            profileField.setAccessible(true);
            profileField.set(headMeta, profile);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException exception) {
            exception.printStackTrace();
        }
        head.setItemMeta((ItemMeta)headMeta);
        return head;
    }

    @NotNull
    public static GameProfile getGameProfile(@NotNull String url) {
        GameProfile profile = new GameProfile(UUID.randomUUID(), null);
        profile.getProperties().put((Object)"textures", (Object)new Property("textures", url));
        return profile;
    }
}

